/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp.fcp07;

import frost.Core;
import frost.ext.DefaultMIMETypes;
import frost.fcp.FcpResultGet;
import frost.fcp.FcpResultPut;
import frost.fcp.FcpToolsException;
import frost.fcp.NodeAddress;
import frost.fcp.fcp07.FcpSocket;
import frost.fcp.fcp07.FreenetKey;
import frost.fcp.fcp07.NodeMessage;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.util.FileAccess;
import frost.util.Logging;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcpConnection {
    private static final Logger logger = Logger.getLogger(FcpConnection.class.getName());
    private final FcpSocket fcpSocket;

    public FcpConnection(NodeAddress na) throws UnknownHostException, IOException {
        this.fcpSocket = new FcpSocket(na);
    }

    public void close() {
        this.fcpSocket.close();
    }

    public List<String> getNodeInfo() throws IOException {
        String tmp;
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new InputStreamReader(this.fcpSocket.getFcpSock().getInputStream()));
        this.fcpSocket.getFcpOut().println("ClientHello");
        this.fcpSocket.getFcpOut().println("Name=hello-" + FcpSocket.getNextFcpId());
        this.fcpSocket.getFcpOut().println("ExpectedVersion=2.0");
        this.fcpSocket.getFcpOut().println("EndMessage");
        this.fcpSocket.getFcpOut().flush();
        while ((tmp = in.readLine()) != null && !tmp.trim().equals("EndMessage")) {
            result.add(tmp);
        }
        in.close();
        this.close();
        if (result.isEmpty()) {
            logger.warning("No ClientInfo response!");
            return null;
        }
        return result;
    }

    public FcpResultGet getKeyToFile(int type, String keyString, File targetFile, int maxSize, int maxRetries, FrostDownloadItem dlItem) throws IOException, FcpToolsException, InterruptedIOException {
        NodeMessage nodeMsg;
        File ddaTempFile = null;
        keyString = FcpConnection.stripSlashes(keyString);
        FreenetKey key = new FreenetKey(keyString);
        logger.fine("KeyString = " + keyString + "\n" + "Key =       " + key + "\n" + "KeyType =   " + key.getKeyType());
        boolean useDDA = type == 1 ? false : this.fcpSocket.isDDA();
        if (useDDA) {
            targetFile.delete();
        }
        this.fcpSocket.getFcpOut().println("ClientGet");
        this.fcpSocket.getFcpOut().println("IgnoreDS=false");
        this.fcpSocket.getFcpOut().println("DSOnly=false");
        this.fcpSocket.getFcpOut().println("URI=" + key);
        this.fcpSocket.getFcpOut().println("Identifier=get-" + FcpSocket.getNextFcpId());
        if (maxRetries <= 0) {
            maxRetries = 1;
        }
        this.fcpSocket.getFcpOut().println("MaxRetries=" + Integer.toString(maxRetries));
        this.fcpSocket.getFcpOut().println("Verbosity=-1");
        if (useDDA) {
            this.fcpSocket.getFcpOut().println("Persistence=connection");
            this.fcpSocket.getFcpOut().println("ReturnType=disk");
            this.fcpSocket.getFcpOut().println("Filename=" + targetFile.getAbsolutePath());
            ddaTempFile = new File(targetFile.getAbsolutePath() + "-w");
            if (ddaTempFile.isFile()) {
                ddaTempFile.delete();
            }
            this.fcpSocket.getFcpOut().println("TempFilename=" + ddaTempFile.getAbsolutePath());
        } else {
            this.fcpSocket.getFcpOut().println("ReturnType=direct");
        }
        int prio = type == 2 ? Core.frostSettings.getIntValue("fcp2.defaultPriorityFileDownload") : (type == 1 ? Core.frostSettings.getIntValue("fcp2.defaultPriorityMessageDownload") : 3);
        this.fcpSocket.getFcpOut().println("PriorityClass=" + Integer.toString(prio));
        if (maxSize > 0) {
            this.fcpSocket.getFcpOut().println("MaxSize=" + Integer.toString(maxSize));
        }
        this.fcpSocket.getFcpOut().println("EndMessage");
        this.fcpSocket.getFcpOut().flush();
        boolean isSuccess = false;
        int returnCode = -1;
        String codeDescription = null;
        boolean isFatal = false;
        String redirectURI = null;
        while ((nodeMsg = NodeMessage.readMessage(this.fcpSocket.getFcpIn())) != null) {
            String endMarker;
            if (Logging.inst().doLogFcp2Messages()) {
                System.out.println("*GET** INFO - NodeMessage:");
                System.out.println(nodeMsg.toString());
            }
            if ((endMarker = nodeMsg.getMessageEnd()) == null) {
                System.out.println("*GET** ENDMARKER is NULL!");
                break;
            }
            if (!useDDA && nodeMsg.isMessageName("AllData") && endMarker.equals("Data")) {
                int count;
                long dataLength = nodeMsg.getLongValue("DataLength");
                BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(targetFile));
                byte[] b = new byte[4096];
                long bytesLeft = dataLength;
                long bytesWritten = 0L;
                while (bytesLeft > 0L && (count = this.fcpSocket.getFcpIn().read(b, 0, bytesLeft > (long)b.length ? b.length : (int)bytesLeft)) >= 0) {
                    bytesLeft -= (long)count;
                    fileOut.write(b, 0, count);
                    bytesWritten += (long)count;
                }
                fileOut.close();
                if (Logging.inst().doLogFcp2Messages()) {
                    System.out.println("*GET** Wrote " + bytesWritten + " of " + dataLength + " bytes to file.");
                }
                if (bytesWritten != dataLength) break;
                isSuccess = true;
                if (dlItem == null || dlItem.getRequiredBlocks() <= 0) break;
                dlItem.setFinalized(true);
                dlItem.setDoneBlocks(dlItem.getRequiredBlocks());
                dlItem.fireValueChanged();
                break;
            }
            if (useDDA && nodeMsg.isMessageName("DataFound")) {
                long dataLength = nodeMsg.getLongValue("DataLength");
                isSuccess = true;
                System.out.println("*GET**: DataFound, len=" + dataLength);
                if (dlItem == null || dlItem.getRequiredBlocks() <= 0) break;
                dlItem.setFinalized(true);
                dlItem.setDoneBlocks(dlItem.getRequiredBlocks());
                dlItem.fireValueChanged();
                break;
            }
            if (nodeMsg.isMessageName("ProtocolError")) {
                returnCode = nodeMsg.getIntValue("Code");
                isFatal = nodeMsg.getBoolValue("Fatal");
                codeDescription = nodeMsg.getStringValue("CodeDescription");
                break;
            }
            if (nodeMsg.isMessageName("IdentifierCollision") || nodeMsg.isMessageName("UnknownNodeIdentifier") || nodeMsg.isMessageName("UnknownPeerNoteType")) break;
            if (nodeMsg.isMessageName("GetFailed")) {
                returnCode = nodeMsg.getIntValue("Code");
                codeDescription = nodeMsg.getStringValue("CodeDescription");
                isFatal = nodeMsg.getBoolValue("Fatal");
                redirectURI = nodeMsg.getStringValue("RedirectURI");
                break;
            }
            if (dlItem == null || !nodeMsg.isMessageName("SimpleProgress")) continue;
            int doneBlocks = nodeMsg.getIntValue("Succeeded");
            int requiredBlocks = nodeMsg.getIntValue("Required");
            int totalBlocks = nodeMsg.getIntValue("Total");
            boolean isFinalized = nodeMsg.getBoolValue("FinalizedTotal");
            if (totalBlocks <= 0 || requiredBlocks <= 0) continue;
            dlItem.setDoneBlocks(doneBlocks);
            dlItem.setRequiredBlocks(requiredBlocks);
            dlItem.setTotalBlocks(totalBlocks);
            dlItem.setFinalized(isFinalized);
            dlItem.fireValueChanged();
        }
        this.close();
        FcpResultGet result = null;
        if (!isSuccess) {
            if (targetFile.isFile()) {
                targetFile.delete();
            }
            result = new FcpResultGet(false, returnCode, codeDescription, isFatal, redirectURI);
        } else {
            result = new FcpResultGet(true);
        }
        if (ddaTempFile != null && ddaTempFile.isFile()) {
            ddaTempFile.delete();
        }
        return result;
    }

    public FcpResultPut putKeyFromFile(int type, String keyString, File sourceFile, boolean getChkOnly, boolean doMime, FrostUploadItem ulItem) throws IOException {
        NodeMessage nodeMsg;
        keyString = FcpConnection.stripSlashes(keyString);
        boolean useDDA = type == 1 ? false : this.fcpSocket.isDDA();
        BufferedOutputStream dataOutput = null;
        if (!useDDA) {
            dataOutput = new BufferedOutputStream(this.fcpSocket.getFcpSock().getOutputStream());
        }
        this.fcpSocket.getFcpOut().println("ClientPut");
        this.fcpSocket.getFcpOut().println("URI=" + keyString);
        this.fcpSocket.getFcpOut().println("Identifier=put-" + FcpSocket.getNextFcpId());
        this.fcpSocket.getFcpOut().println("Verbosity=-1");
        this.fcpSocket.getFcpOut().println("MaxRetries=3");
        this.fcpSocket.getFcpOut().println("DontCompress=false");
        if (keyString.equals("CHK@")) {
            if (ulItem != null && ulItem.getSharedFileItem() != null) {
                this.fcpSocket.getFcpOut().println("TargetFilename=");
            } else {
                this.fcpSocket.getFcpOut().println("TargetFilename=" + sourceFile.getName());
            }
        }
        if (getChkOnly) {
            this.fcpSocket.getFcpOut().println("GetCHKOnly=true");
            this.fcpSocket.getFcpOut().println("PriorityClass=3");
        } else {
            int prio;
            if (type == 2) {
                if (doMime) {
                    this.fcpSocket.getFcpOut().println("Metadata.ContentType=" + DefaultMIMETypes.guessMIMEType(sourceFile.getAbsolutePath()));
                } else {
                    this.fcpSocket.getFcpOut().println("Metadata.ContentType=application/octet-stream");
                }
                prio = Core.frostSettings.getIntValue("fcp2.defaultPriorityFileUpload");
            } else {
                prio = type == 1 ? Core.frostSettings.getIntValue("fcp2.defaultPriorityMessageUpload") : 3;
            }
            this.fcpSocket.getFcpOut().println("PriorityClass=" + Integer.toString(prio));
        }
        this.fcpSocket.getFcpOut().println("Persistence=connection");
        if (useDDA) {
            this.fcpSocket.getFcpOut().println("UploadFrom=disk");
            this.fcpSocket.getFcpOut().println("Filename=" + sourceFile.getAbsolutePath());
            this.fcpSocket.getFcpOut().println("EndMessage");
            this.fcpSocket.getFcpOut().flush();
        } else {
            int d;
            this.fcpSocket.getFcpOut().println("UploadFrom=direct");
            this.fcpSocket.getFcpOut().println("DataLength=" + Long.toString(sourceFile.length()));
            this.fcpSocket.getFcpOut().println("Data");
            this.fcpSocket.getFcpOut().flush();
            BufferedInputStream fileInput = new BufferedInputStream(new FileInputStream(sourceFile));
            while ((d = fileInput.read()) >= 0) {
                dataOutput.write(d);
            }
            fileInput.close();
            dataOutput.flush();
        }
        boolean isSuccess = false;
        int returnCode = -1;
        String codeDescription = null;
        boolean isFatal = false;
        String chkKey = null;
        while ((nodeMsg = NodeMessage.readMessage(this.fcpSocket.getFcpIn())) != null) {
            if (Logging.inst().doLogFcp2Messages()) {
                System.out.println("*PUT** INFO - NodeMessage:");
                System.out.println(nodeMsg.toString());
            }
            if (getChkOnly && nodeMsg.isMessageName("URIGenerated")) {
                isSuccess = true;
                chkKey = nodeMsg.getStringValue("URI");
                break;
            }
            if (!getChkOnly && nodeMsg.isMessageName("PutSuccessful")) {
                isSuccess = true;
                chkKey = nodeMsg.getStringValue("URI");
                if (ulItem == null || ulItem.getTotalBlocks() <= 0) break;
                ulItem.setDoneBlocks(ulItem.getTotalBlocks());
                break;
            }
            if (nodeMsg.isMessageName("PutFailed")) {
                returnCode = nodeMsg.getIntValue("Code");
                isFatal = nodeMsg.getBoolValue("Fatal");
                codeDescription = nodeMsg.getStringValue("CodeDescription");
                break;
            }
            if (nodeMsg.isMessageName("ProtocolError")) {
                returnCode = nodeMsg.getIntValue("Code");
                isFatal = nodeMsg.getBoolValue("Fatal");
                codeDescription = nodeMsg.getStringValue("CodeDescription");
                break;
            }
            if (nodeMsg.isMessageName("IdentifierCollision") || nodeMsg.isMessageName("UnknownNodeIdentifier") || nodeMsg.isMessageName("UnknownPeerNoteType")) break;
            if (ulItem == null || !nodeMsg.isMessageName("SimpleProgress")) continue;
            int doneBlocks = nodeMsg.getIntValue("Succeeded");
            int totalBlocks = nodeMsg.getIntValue("Total");
            boolean isFinalized = nodeMsg.getBoolValue("FinalizedTotal");
            if (totalBlocks <= 0) continue;
            ulItem.setDoneBlocks(doneBlocks);
            ulItem.setTotalBlocks(totalBlocks);
            ulItem.setFinalized(isFinalized);
            ulItem.fireValueChanged();
        }
        if (dataOutput != null) {
            dataOutput.close();
        }
        this.close();
        if (!isSuccess) {
            if (returnCode == 9) {
                return new FcpResultPut(2, returnCode, codeDescription, isFatal);
            }
            if (returnCode == 5) {
                return new FcpResultPut(4, returnCode, codeDescription, isFatal);
            }
            return new FcpResultPut(3, returnCode, codeDescription, isFatal);
        }
        int pos = chkKey.indexOf("CHK@");
        if (pos > -1) {
            chkKey = chkKey.substring(pos).trim();
        }
        return new FcpResultPut(1, chkKey);
    }

    public String generateCHK(File file) throws IOException {
        FcpResultPut result = this.putKeyFromFile(2, "CHK@", file, true, true, null);
        if (result == null || !result.isSuccess()) {
            return null;
        }
        return result.getChkKey();
    }

    public String[] getKeyPair() throws IOException, ConnectException {
        this.fcpSocket.getFcpOut().println("GenerateSSK");
        this.fcpSocket.getFcpOut().println("Identifier=genssk-" + FcpSocket.getNextFcpId());
        this.fcpSocket.getFcpOut().println("EndMessage");
        this.fcpSocket.getFcpOut().flush();
        String[] result = null;
        NodeMessage nodeMsg = NodeMessage.readMessage(this.fcpSocket.getFcpIn());
        if (nodeMsg != null) {
            System.out.println("*GENERATESSK** INFO - NodeMessage:");
            System.out.println(nodeMsg.toString());
            if (nodeMsg.isMessageName("SSKKeypair")) {
                String insertURI = nodeMsg.getStringValue("InsertURI");
                String requestURI = nodeMsg.getStringValue("RequestURI");
                int pos = insertURI.indexOf("SSK@");
                if (pos > -1) {
                    insertURI = insertURI.substring(pos).trim();
                }
                if (insertURI.endsWith("/")) {
                    insertURI = insertURI.substring(0, insertURI.length() - 1);
                }
                if ((pos = requestURI.indexOf("SSK@")) > -1) {
                    requestURI = requestURI.substring(pos).trim();
                }
                if (requestURI.endsWith("/")) {
                    requestURI = requestURI.substring(0, requestURI.length() - 1);
                }
                result = new String[]{insertURI, requestURI};
            }
        }
        this.close();
        return result;
    }

    public static String stripSlashes(String uri) {
        if (uri.startsWith("KSK@")) {
            String myUri = null;
            myUri = uri.replace('/', '|');
            return myUri;
        }
        if (uri.startsWith("SSK@")) {
            String sskpart = uri.substring(0, uri.indexOf(47) + 1);
            String datapart = uri.substring(uri.indexOf(47) + 1).replace('/', '|');
            return sskpart + datapart;
        }
        return uri;
    }

    public boolean testNodeDDA() {
        NodeMessage nodeMsg;
        File testFile = this.createTestFile();
        if (testFile == null) {
            return false;
        }
        this.fcpSocket.getFcpOut().println("ClientPut");
        this.fcpSocket.getFcpOut().println("URI=CHK@");
        this.fcpSocket.getFcpOut().println("Identifier=testdda-" + FcpSocket.getNextFcpId());
        this.fcpSocket.getFcpOut().println("Verbosity=0");
        this.fcpSocket.getFcpOut().println("MaxRetries=0");
        this.fcpSocket.getFcpOut().println("PriorityClass=1");
        this.fcpSocket.getFcpOut().println("GetCHKOnly=true");
        this.fcpSocket.getFcpOut().println("Global=false");
        this.fcpSocket.getFcpOut().println("Persistence=connection");
        this.fcpSocket.getFcpOut().println("DontCompress=true");
        this.fcpSocket.getFcpOut().println("ClientToken=testdda");
        this.fcpSocket.getFcpOut().println("UploadFrom=disk");
        this.fcpSocket.getFcpOut().println("Filename=" + testFile.getAbsolutePath());
        this.fcpSocket.getFcpOut().println("EndMessage");
        this.fcpSocket.getFcpOut().flush();
        boolean isSuccess = false;
        while ((nodeMsg = NodeMessage.readMessage(this.fcpSocket.getFcpIn())) != null) {
            if (Logging.inst().doLogFcp2Messages()) {
                System.out.println("*TESTDDA** INFO - NodeMessage:");
                System.out.println(nodeMsg.toString());
            }
            if (nodeMsg.isMessageName("PutSuccessful")) {
                System.out.println("DDA is possible!");
                isSuccess = true;
                break;
            }
            if (nodeMsg.isMessageName("PutFailed")) {
                System.out.println(nodeMsg.toString());
                break;
            }
            if (nodeMsg.isMessageName("ProtocolError")) {
                System.out.println(nodeMsg.toString());
                break;
            }
            if (nodeMsg.isMessageName("IdentifierCollision")) {
                System.out.println(nodeMsg.toString());
                break;
            }
            if (nodeMsg.isMessageName("UnknownNodeIdentifier")) {
                System.out.println(nodeMsg.toString());
                break;
            }
            if (!nodeMsg.isMessageName("UnknownPeerNoteType")) continue;
            System.out.println(nodeMsg.toString());
            break;
        }
        this.close();
        testFile.delete();
        return isSuccess;
    }

    private File createTestFile() {
        File file = FileAccess.createTempFile("dda_", ".tmp");
        byte[] b = new byte[1024];
        Core.getCrypto().getSecureRandom().nextBytes(b);
        try {
            file.deleteOnExit();
            FileOutputStream os = new FileOutputStream(file);
            os.write(b, 0, b.length);
            os.close();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "DDA testfile creation failed", ex);
            return null;
        }
        return file;
    }
}

