/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp.fcp07;

import frost.fcp.NodeAddress;
import frost.fcp.fcp07.FcpSocket;
import frost.fcp.fcp07.NodeMessage;
import frost.fcp.fcp07.NodeMessageListener;
import frost.util.Logging;
import frost.util.Mixed;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcpMultiRequestConnection {
    private static final Logger logger = Logger.getLogger(FcpMultiRequestConnection.class.getName());
    private final NodeAddress nodeAddress;
    private FcpSocket fcpSocket = null;
    private final ReentrantLock writeSocketLock;
    private ReceiveThread receiveThread;
    private EventListenerList listenerList = new EventListenerList();

    protected FcpMultiRequestConnection(NodeAddress na) throws UnknownHostException, IOException {
        this.nodeAddress = na;
        this.fcpSocket = new FcpSocket(this.nodeAddress);
        this.notifyConnected();
        this.writeSocketLock = new ReentrantLock(true);
        this.receiveThread = new ReceiveThread(this.fcpSocket.getFcpIn());
        this.receiveThread.start();
    }

    public static FcpMultiRequestConnection createInstance(NodeAddress na) throws UnknownHostException, IOException {
        return new FcpMultiRequestConnection(na);
    }

    public FcpSocket getFcpSocket() {
        return this.fcpSocket;
    }

    protected void reconnect() {
        this.notifyDisconnected();
        int count = 0;
        while (true) {
            logger.severe("reconnect try no. " + count);
            try {
                this.fcpSocket = new FcpSocket(this.nodeAddress);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "reconnect failed, exception catched: " + t.getMessage());
                logger.severe("waiting 30 seconds before next reconnect try");
                Mixed.wait(30000);
                ++count;
                continue;
            }
            break;
        }
        logger.severe("reconnect was successful, restarting ReceiveThread now");
        this.notifyConnected();
        this.receiveThread = new ReceiveThread(this.fcpSocket.getFcpIn());
        this.receiveThread.start();
    }

    public boolean isDDA() {
        return this.fcpSocket.isDDA();
    }

    public NodeAddress getNodeAddress() {
        return this.fcpSocket.getNodeAddress();
    }

    public void addNodeMessageListener(NodeMessageListener l) {
        this.listenerList.add(NodeMessageListener.class, l);
    }

    public void NodeMessageListener(NodeMessageListener l) {
        this.listenerList.remove(NodeMessageListener.class, l);
    }

    protected void handleNodeMessage(NodeMessage nodeMsg) {
        String id = nodeMsg.getStringValue("Identifier");
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != NodeMessageListener.class) continue;
            if (id != null) {
                ((NodeMessageListener)listeners[i + 1]).handleNodeMessage(id, nodeMsg);
                continue;
            }
            ((NodeMessageListener)listeners[i + 1]).handleNodeMessage(nodeMsg);
        }
    }

    protected void notifyConnected() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != NodeMessageListener.class) continue;
            ((NodeMessageListener)listeners[i + 1]).connected();
        }
    }

    protected void notifyDisconnected() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != NodeMessageListener.class) continue;
            ((NodeMessageListener)listeners[i + 1]).disconnected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessage(List<String> message, boolean sendEndMsg) {
        this.writeSocketLock.lock();
        try {
            if (Logging.inst().doLogFcp2Messages()) {
                System.out.println("### SEND >>>>>>>");
            }
            for (String msgLine : message) {
                this.fcpSocket.getFcpOut().println(msgLine);
                if (!Logging.inst().doLogFcp2Messages()) continue;
                System.out.println(msgLine);
            }
            if (sendEndMsg) {
                this.fcpSocket.getFcpOut().println("EndMessage");
                if (Logging.inst().doLogFcp2Messages()) {
                    System.out.println("*EndMessage*");
                }
            }
            boolean isError = this.fcpSocket.getFcpOut().checkError();
            if (Logging.inst().doLogFcp2Messages()) {
                System.out.println("### SEND <<<<<<< isError=" + isError);
            }
            boolean bl = isError;
            return bl;
        }
        finally {
            this.writeSocketLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessageAndData(List<String> message, boolean sendEndMsg, File sourceFile) {
        this.writeSocketLock.lock();
        try {
            int d;
            if (Logging.inst().doLogFcp2Messages()) {
                System.out.println("### SEND_DATA >>>>>>>");
            }
            for (String msgLine : message) {
                this.fcpSocket.getFcpOut().println(msgLine);
                if (!Logging.inst().doLogFcp2Messages()) continue;
                System.out.println(msgLine);
            }
            if (sendEndMsg) {
                this.fcpSocket.getFcpOut().println("Data");
            }
            this.fcpSocket.getFcpOut().flush();
            BufferedInputStream fileInput = new BufferedInputStream(new FileInputStream(sourceFile));
            while ((d = fileInput.read()) >= 0) {
                this.fcpSocket.getFcpRawOut().write(d);
            }
            fileInput.close();
            this.fcpSocket.getFcpRawOut().flush();
            if (Logging.inst().doLogFcp2Messages()) {
                System.out.println("### SEND_DATA <<<<<<<");
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error sending file to socket", t);
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeSocketLock.unlock();
        }
    }

    public void closeConnection() {
        this.fcpSocket.close();
    }

    public void doHandshake() throws IOException, ConnectException {
        this.fcpSocket.getFcpOut().println("ClientHello");
        this.fcpSocket.getFcpOut().println("Name=hello-" + FcpSocket.getNextFcpId());
        this.fcpSocket.getFcpOut().println("ExpectedVersion=2.0");
        this.fcpSocket.getFcpOut().println("EndMessage");
        this.fcpSocket.getFcpOut().flush();
        boolean isSuccess = false;
        NodeMessage nodeMsg = NodeMessage.readMessage(this.fcpSocket.getFcpIn());
        if (nodeMsg != null && nodeMsg.isMessageName("NodeHello")) {
            isSuccess = true;
        }
        if (!isSuccess) {
            throw new ConnectException();
        }
    }

    private class ReceiveThread
    extends Thread {
        private final BufferedInputStream fcpInp;

        public ReceiveThread(BufferedInputStream newFcpInp) {
            this.fcpInp = newFcpInp;
        }

        public void run() {
            NodeMessage nodeMsg;
            while ((nodeMsg = NodeMessage.readMessage(this.fcpInp)) != null) {
                FcpMultiRequestConnection.this.handleNodeMessage(nodeMsg);
            }
            logger.severe("Socket closed, ReceiveThread ended, trying to reconnect");
            System.out.println("ReceiveThread ended, trying to reconnect");
            FcpMultiRequestConnection.this.reconnect();
        }
    }
}

