/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp.fcp07;

import frost.fcp.DataNotFoundException;
import frost.fcp.FcpResultGet;
import frost.fcp.FcpToolsException;
import frost.fcp.fcp07.FcpConnection;
import frost.fcp.fcp07.FcpFactory;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.util.FileAccess;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FcpRequest {
    static final boolean DEBUG = true;
    private static final Logger logger = Logger.getLogger(FcpRequest.class.getName());

    public static FcpResultGet getFile(int type, String key, Long size, File target, int maxSize, int maxRetries, boolean createTempFile, FrostDownloadItem dlItem) {
        File tempFile = null;
        tempFile = createTempFile ? FileAccess.createTempFile("getFile_", ".tmp") : new File(target.getPath() + ".tmp");
        FcpResultGet results = FcpRequest.getKey(type, key, tempFile, maxSize, maxRetries, dlItem);
        if (results.isSuccess()) {
            boolean wasOK;
            if (target.isFile()) {
                target.delete();
            }
            if (!(wasOK = tempFile.renameTo(target))) {
                logger.severe("ERROR: Could not move file '" + tempFile.getPath() + "' to '" + target.getPath() + "'.\n" + "Maybe the locations are on different filesystems where a move is not allowed.\n" + "Please try change the location of 'temp.dir' in the frost.ini file," + " and copy the file to a save location by yourself.");
                return FcpResultGet.RESULT_FAILED;
            }
        } else {
            tempFile.delete();
        }
        return results;
    }

    private static FcpResultGet getKey(int type, String key, File target, int maxSize, int maxRetries, FrostDownloadItem dlItem) {
        FcpConnection connection;
        if (key == null || key.length() == 0 || key.startsWith("null")) {
            System.out.println("getKey: KEY IS NULL!");
            return FcpResultGet.RESULT_FAILED;
        }
        try {
            connection = FcpFactory.getFcpConnectionInstance();
        }
        catch (ConnectException e1) {
            connection = null;
        }
        FcpResultGet results = null;
        if (connection != null) {
            int maxtries = 3;
            for (int tries = 0; tries < 3; ++tries) {
                try {
                    results = connection.getKeyToFile(type, key, target, maxSize, maxRetries, dlItem);
                    break;
                }
                catch (ConnectException e) {
                    continue;
                }
                catch (DataNotFoundException ex) {
                    logger.log(Level.INFO, "FcpRequest.getKey(1): DataNotFoundException (usual if not found)", ex);
                    break;
                }
                catch (FcpToolsException e) {
                    logger.log(Level.SEVERE, "FcpRequest.getKey(1): FcpToolsException", e);
                    break;
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "FcpRequest.getKey(1): IOException", e);
                    break;
                }
            }
        }
        String printableKey = null;
        String keyPrefix = "";
        if (key.indexOf("@") > -1) {
            keyPrefix = key.substring(0, key.indexOf("@") + 1);
        }
        String keyUrl = "";
        if (key.indexOf("/") > -1) {
            keyUrl = key.substring(key.indexOf("/"));
        }
        printableKey = keyPrefix + "..." + keyUrl;
        System.out.println("getKey: file='" + target.getPath() + "' ; len=" + target.length());
        if (results == null) {
            results = FcpResultGet.RESULT_FAILED;
            System.out.println("getKey - Failed, result=null");
        } else if (results.isSuccess() && target.length() > 0L) {
            logger.info("getKey - Success: " + printableKey);
            System.out.println("getKey - Success: " + printableKey);
        } else {
            target.delete();
            logger.info("getKey - Failed: " + printableKey + "; rc=" + results.getReturnCode() + "; isFatal=" + results.isFatal());
            System.out.println("getKey - Failed: " + printableKey + "; rc=" + results.getReturnCode() + "; isFatal=" + results.isFatal());
        }
        return results;
    }
}

