/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp.fcp07.messagetransfer;

import frost.fcp.FcpResultGet;
import frost.fcp.FcpResultPut;
import java.io.File;

public class MessageTransferTask {
    public static final int MODE_DOWNLOAD = 1;
    public static final int MODE_UPLOAD = 2;
    private final int transferMode;
    private final String identifier;
    private final String key;
    private final File file;
    private final int maxSize;
    private final int priority;
    private final int maxRetries;
    private boolean taskFinished = false;
    FcpResultPut putResult = null;
    FcpResultGet getResult = null;

    public MessageTransferTask(String id, String key, File targetFile, int prio, int maxSize, int maxRetries) {
        this.transferMode = 1;
        this.identifier = id;
        this.key = key;
        this.file = targetFile;
        this.maxSize = maxSize;
        this.priority = prio;
        this.maxRetries = maxRetries;
    }

    public MessageTransferTask(String id, String key, File sourceFile, int prio) {
        this.transferMode = 2;
        this.identifier = id;
        this.key = key;
        this.file = sourceFile;
        this.maxSize = -1;
        this.priority = prio;
        this.maxRetries = -1;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public File getFile() {
        return this.file;
    }

    public String getKey() {
        return this.key;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public synchronized void waitForFinished() {
        if (this.taskFinished) {
            return;
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void setFinished() {
        this.taskFinished = true;
        this.notifyAll();
    }

    public boolean isModeUpload() {
        return this.transferMode == 2;
    }

    public boolean isModeDownload() {
        return this.transferMode == 1;
    }

    public FcpResultPut getFcpResultPut() {
        return this.putResult;
    }

    public void setFcpResultPut(FcpResultPut putResult) {
        this.putResult = putResult;
    }

    public FcpResultGet getFcpResultGet() {
        return this.getResult;
    }

    public void setFcpResultGet(FcpResultGet getResult) {
        this.getResult = getResult;
        if (!getResult.isSuccess() && this.getFile().isFile()) {
            this.getFile().delete();
        }
    }

    public void setFailed() {
        if (this.isModeDownload()) {
            this.getResult = FcpResultGet.RESULT_FAILED;
        } else {
            this.putResult = FcpResultPut.NO_CONNECTION_RESULT;
        }
    }

    public int getPriority() {
        return this.priority;
    }
}

