/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer;

import frost.Core;
import frost.fcp.FcpHandler;
import frost.fileTransfer.FileListFileContent;
import frost.fileTransfer.SharedFileXmlFile;
import frost.identities.Identity;
import frost.util.FileAccess;
import frost.util.XMLTools;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileListFile {
    private static final Logger logger = Logger.getLogger(FileListFile.class.getName());
    private static final String TAG_FrostFileListFile = "FrostFileListFile";
    private static final String TAG_timestamp = "timestamp";
    private static final String TAG_sign = "sign";
    private static final String TAG_File = "File";
    private static final String TAG_files = "files";
    private static final String TAG_Identity = "Identity";

    public static boolean writeFileListFile(FileListFileContent content, File targetFile) {
        Document doc = XMLTools.createDomDocument();
        if (doc == null) {
            logger.severe("Error - writeFileListFile: factory could'nt create XML Document.");
            return false;
        }
        Element rootElement = doc.createElement(TAG_FrostFileListFile);
        doc.appendChild(rootElement);
        Element timeStampElement = doc.createElement(TAG_timestamp);
        Text timeStampText = doc.createTextNode(Long.toString(content.getTimestamp()));
        timeStampElement.appendChild(timeStampText);
        rootElement.appendChild(timeStampElement);
        Element _sharer = ((Identity)content.getSendOwner()).getXMLElement(doc);
        rootElement.appendChild(_sharer);
        String signContent = FileListFile.getSignableContent(content.getFileList(), content.getSendOwner().getUniqueName(), content.getTimestamp());
        String sig = Core.getCrypto().detachedSign(signContent, content.getSendOwner().getPrivateKey());
        if (sig == null) {
            return false;
        }
        Element element = doc.createElement(TAG_sign);
        CDATASection cdata = doc.createCDATASection(sig);
        element.appendChild(cdata);
        rootElement.appendChild(element);
        Element filesElement = doc.createElement(TAG_files);
        for (SharedFileXmlFile current : content.getFileList()) {
            Element currentElement = current.getXMLElement(doc);
            filesElement.appendChild(currentElement);
        }
        rootElement.appendChild(filesElement);
        boolean writeOK = false;
        try {
            writeOK = XMLTools.writeXmlFile(doc, targetFile);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception in writeFileListFile/writeXmlFile", t);
        }
        if (writeOK && FcpHandler.isFreenet05()) {
            File tmp = new File(targetFile.getPath() + ".flftmp");
            if (!FileAccess.compressFileGZip(targetFile, tmp)) {
                return false;
            }
            targetFile.delete();
            if (!tmp.renameTo(targetFile)) {
                logger.severe("Error: rename failed: " + tmp.getPath() + "','" + targetFile.getPath() + "'");
                return false;
            }
        }
        return writeOK;
    }

    public static FileListFileContent readFileListFile(File sourceFile) {
        if (!sourceFile.isFile() || sourceFile.length() <= 0L) {
            return null;
        }
        if (FcpHandler.isFreenet05()) {
            File tmp = new File(sourceFile.getPath() + ".flftmp");
            if (!FileAccess.decompressFileGZip(sourceFile, tmp)) {
                return null;
            }
            sourceFile.delete();
            if (!tmp.renameTo(sourceFile)) {
                logger.severe("Error: rename failed: " + tmp.getPath() + "','" + sourceFile.getPath() + "'");
                return null;
            }
        }
        Document d = null;
        try {
            d = XMLTools.parseXmlFile(sourceFile.getPath(), false);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception during XML parsing", t);
            return null;
        }
        if (d == null) {
            logger.log(Level.SEVERE, "Could'nt parse the file");
            return null;
        }
        Element rootNode = d.getDocumentElement();
        if (!rootNode.getTagName().equals(TAG_FrostFileListFile)) {
            logger.severe("Error: xml file does not contain the root tag 'FrostFileListFile'");
            return null;
        }
        String timeStampStr = XMLTools.getChildElementsTextValue(rootNode, TAG_timestamp);
        if (timeStampStr == null) {
            logger.severe("Error: xml file does not contain the tag 'timestamp'");
            return null;
        }
        long timestamp = Long.parseLong(timeStampStr);
        String signature = XMLTools.getChildElementsCDATAValue(rootNode, TAG_sign);
        if (signature == null) {
            logger.severe("Error: xml file does not contain the tag 'sign'");
            return null;
        }
        Element identityNode = null;
        Element filesNode = null;
        List<Element> nodelist = XMLTools.getChildElementsByTagName(rootNode, TAG_Identity);
        if (nodelist.size() != 1) {
            logger.severe("Error: xml files must contain exactly one element 'Identity'");
            return null;
        }
        identityNode = nodelist.get(0);
        nodelist = XMLTools.getChildElementsByTagName(rootNode, TAG_files);
        if (nodelist.size() != 1) {
            logger.severe("Error: xml files must contain exactly one element 'files'");
            return null;
        }
        filesNode = nodelist.get(0);
        LinkedList<SharedFileXmlFile> files = new LinkedList<SharedFileXmlFile>();
        List<Element> _files = XMLTools.getChildElementsByTagName(filesNode, TAG_File);
        for (Element el : _files) {
            SharedFileXmlFile file = SharedFileXmlFile.getInstance(el);
            if (file == null) {
                logger.severe("Error: shared files xml parsing failed, most likely the signature verification will fail!");
                continue;
            }
            files.add(file);
        }
        Identity owner = Identity.createIdentityFromXmlElement(identityNode);
        if (owner == null) {
            logger.severe("Error: invalid identity information");
            return null;
        }
        if (!Core.getIdentities().isNewIdentityValid(owner)) {
            logger.severe("Error: identity failed verification, file list from owner: " + owner.getUniqueName());
            return null;
        }
        String signContent = FileListFile.getSignableContent(files, owner.getUniqueName(), timestamp);
        boolean sigIsValid = Core.getCrypto().detachedVerify(signContent, owner.getPublicKey(), signature);
        if (!sigIsValid) {
            logger.severe("Error: invalid file signature from owner " + owner.getUniqueName());
            return null;
        }
        Iterator i = files.iterator();
        while (i.hasNext()) {
            SharedFileXmlFile file = (SharedFileXmlFile)i.next();
            if (file.isSharedFileValid()) continue;
            String txt = "Shared file is invalid (missing fields or wrong contents):\n  size=" + file.getSize() + "\n  sha=" + file.getSha() + "\n  name=" + file.getFilename() + "\n  key=" + file.getKey();
            logger.log(Level.SEVERE, txt);
            i.remove();
        }
        FileListFileContent content = new FileListFileContent(timestamp, owner, files);
        return content;
    }

    private static String getSignableContent(LinkedList<SharedFileXmlFile> files, String owner, long timestamp) {
        StringBuilder signContent = new StringBuilder();
        signContent.append(owner);
        signContent.append(timestamp);
        for (SharedFileXmlFile sfo : files) {
            signContent.append(sfo.getSha());
            signContent.append(sfo.getFilename());
            signContent.append(sfo.getSize().toString());
            if (sfo.getKey() != null) {
                signContent.append(sfo.getKey());
            }
            if (sfo.getLastUploaded() != null) {
                signContent.append(sfo.getLastUploaded());
            }
            if (sfo.getComment() != null) {
                signContent.append(sfo.getComment());
            }
            if (sfo.getKeywords() == null) continue;
            signContent.append(sfo.getKeywords());
        }
        return signContent.toString();
    }
}

