/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer;

import frost.Core;
import frost.MainFrame;
import frost.fileTransfer.FileSharingManager;
import frost.fileTransfer.FileTransferInformation;
import frost.fileTransfer.NewUploadFilesManager;
import frost.fileTransfer.PersistenceManager;
import frost.fileTransfer.download.DownloadManager;
import frost.fileTransfer.search.SearchManager;
import frost.fileTransfer.sharing.FrostSharedFileItem;
import frost.fileTransfer.sharing.SharedFilesManager;
import frost.fileTransfer.upload.UploadManager;
import frost.identities.LocalIdentity;
import frost.storage.AutoSavable;
import frost.storage.ExitSavable;
import frost.storage.StorageException;
import frost.util.model.ModelItem;

public class FileTransferManager
implements ExitSavable,
AutoSavable {
    private DownloadManager downloadManager;
    private SearchManager searchManager;
    private UploadManager uploadManager;
    private SharedFilesManager sharedFilesManager;
    private NewUploadFilesManager newUploadFilesManager;
    private PersistenceManager persistenceManager = null;
    private static FileTransferManager instance = null;

    private FileTransferManager() {
    }

    public static FileTransferManager inst() {
        if (instance == null) {
            instance = new FileTransferManager();
        }
        return instance;
    }

    public void initialize() throws StorageException {
        this.getDownloadManager().initialize();
        this.getSearchManager().initialize();
        this.getSharedFilesManager().initialize();
        this.getUploadManager().initialize(this.getSharedFilesManager().getSharedFileItemList());
        this.getNewUploadFilesManager().initialize();
        if (PersistenceManager.isPersistenceEnabled() && Core.isFreenetOnline()) {
            try {
                this.persistenceManager = new PersistenceManager(this.getUploadManager().getModel(), this.getDownloadManager().getModel());
            }
            catch (Throwable t) {
                System.out.println("FAILED TO ESTABLISH THE PERSISTENT CONNECTION!");
                t.printStackTrace();
            }
        }
        MainFrame mainFrame = MainFrame.getInstance();
        this.getDownloadManager().addPanelToMainFrame(mainFrame);
        this.getUploadManager().addPanelToMainFrame(mainFrame);
        this.getSearchManager().addPanelToMainFrame(mainFrame);
        this.getSharedFilesManager().addPanelToMainFrame(mainFrame);
    }

    public PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    public void startTickers() {
        this.getDownloadManager().startTicker();
        this.getUploadManager().startTicker();
        this.getNewUploadFilesManager().start();
        if (this.getPersistenceManager() != null) {
            this.getPersistenceManager().startThreads();
        }
    }

    public DownloadManager getDownloadManager() {
        if (this.downloadManager == null) {
            this.downloadManager = new DownloadManager();
        }
        return this.downloadManager;
    }

    public FileTransferInformation getFileTransferInformation() {
        FileTransferInformation infos = new FileTransferInformation();
        this.getDownloadManager().updateFileTransferInformation(infos);
        this.getUploadManager().updateFileTransferInformation(infos);
        infos.setFileListDownloadQueueSize(FileSharingManager.getFileListDownloadQueueSize());
        return infos;
    }

    public void updateWaitingCountInPanels(FileTransferInformation infos) {
        if (infos == null) {
            return;
        }
        this.getDownloadManager().getPanel().setDownloadItemCount(infos.getDownloadsWaiting());
        this.getUploadManager().getPanel().setUploadItemCount(infos.getUploadsWaiting());
    }

    public int countFilesSharedByLocalIdentity(LocalIdentity li) {
        int count = 0;
        for (int x = 0; x < this.getSharedFilesManager().getModel().getItemCount(); ++x) {
            FrostSharedFileItem item = (FrostSharedFileItem)this.getSharedFilesManager().getModel().getItemAt(x);
            if (!item.getOwner().equals(li.getUniqueName())) continue;
            ++count;
        }
        return count;
    }

    public void removeFilesSharedByLocalIdentity(LocalIdentity li) {
        int x;
        for (x = this.getUploadManager().getModel().getItemCount() - 1; x >= 0; --x) {
            FrostSharedFileItem suf;
            ModelItem obj = this.getUploadManager().getModel().getItemAt(x);
            if (!(obj instanceof FrostSharedFileItem) || !(suf = (FrostSharedFileItem)obj).getOwner().equals(li.getUniqueName())) continue;
            this.getUploadManager().getModel().removeItems(new ModelItem[]{suf});
        }
        for (x = 0; x < this.getSharedFilesManager().getModel().getItemCount(); ++x) {
            FrostSharedFileItem item = (FrostSharedFileItem)this.getSharedFilesManager().getModel().getItemAt(x);
            if (!item.getOwner().equals(li.getUniqueName())) continue;
            this.getSharedFilesManager().getModel().removeItems(new ModelItem[]{item});
        }
    }

    public SearchManager getSearchManager() {
        if (this.searchManager == null) {
            this.searchManager = new SearchManager();
        }
        return this.searchManager;
    }

    public UploadManager getUploadManager() {
        if (this.uploadManager == null) {
            this.uploadManager = new UploadManager();
        }
        return this.uploadManager;
    }

    public SharedFilesManager getSharedFilesManager() {
        if (this.sharedFilesManager == null) {
            this.sharedFilesManager = new SharedFilesManager();
        }
        return this.sharedFilesManager;
    }

    public NewUploadFilesManager getNewUploadFilesManager() {
        if (this.newUploadFilesManager == null) {
            this.newUploadFilesManager = new NewUploadFilesManager();
        }
        return this.newUploadFilesManager;
    }

    public void exitSave() throws StorageException {
        this.save();
    }

    public void autoSave() throws StorageException {
        this.save();
    }

    public void save() throws StorageException {
        this.getDownloadManager().exitSave();
        this.getUploadManager().exitSave();
        this.getSharedFilesManager().exitSave();
        this.getNewUploadFilesManager().exitSave();
    }
}

