/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.download;

import frost.Core;
import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.FrostFileListFileObject;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.storage.ExitSavable;
import frost.storage.StorageException;
import frost.storage.perst.FrostFilesStorage;
import frost.util.model.ModelItem;
import frost.util.model.SortedModel;
import frost.util.model.SortedTableFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DownloadModel
extends SortedModel
implements ExitSavable {
    private static final Logger logger = Logger.getLogger(DownloadModel.class.getName());

    public DownloadModel(SortedTableFormat f) {
        super(f);
    }

    public synchronized boolean addDownloadItem(FrostDownloadItem itemToAdd) {
        FrostFileListFileObject flfToAdd = itemToAdd.getFileListFileObject();
        for (int x = 0; x < this.getItemCount(); ++x) {
            FrostDownloadItem item = (FrostDownloadItem)this.getItemAt(x);
            FrostFileListFileObject flf = item.getFileListFileObject();
            if (flfToAdd != null && flf != null && flfToAdd.getSha().equals(flf.getSha())) {
                return false;
            }
            if (itemToAdd.getKey() != null && item.getKey() != null && item.getKey().equals(itemToAdd.getKey())) {
                return false;
            }
            if (!item.getFilename().equals(itemToAdd.getFilename())) continue;
            int cnt = 2;
            while (true) {
                String nextNewName = itemToAdd.getFilename() + "_" + cnt;
                itemToAdd.setFileName(nextNewName);
                if (this.addDownloadItem(itemToAdd)) {
                    return true;
                }
                ++cnt;
            }
        }
        this.addItem(itemToAdd);
        return true;
    }

    public void addExternalItem(FrostDownloadItem i) {
        this.addItem(i);
    }

    public synchronized boolean containsItemWithSha(String sha) {
        for (int x = 0; x < this.getItemCount(); ++x) {
            FrostDownloadItem dlItem = (FrostDownloadItem)this.getItemAt(x);
            FrostFileListFileObject flf = dlItem.getFileListFileObject();
            if (flf == null || !flf.getSha().equals(sha)) continue;
            return true;
        }
        return false;
    }

    public synchronized void removeFinishedDownloads() {
        ArrayList<FrostDownloadItem> items = new ArrayList<FrostDownloadItem>();
        for (int i = this.getItemCount() - 1; i >= 0; --i) {
            FrostDownloadItem dlItem = (FrostDownloadItem)this.getItemAt(i);
            if (dlItem.getState() != 3) continue;
            items.add(dlItem);
        }
        if (items.size() > 0) {
            ModelItem[] itemsArray = new FrostDownloadItem[items.size()];
            for (int i = 0; i < itemsArray.length; ++i) {
                itemsArray[i] = (FrostDownloadItem)items.get(i);
            }
            this.removeItems(itemsArray);
        }
    }

    public synchronized void removeExternalDownloads() {
        ArrayList<FrostDownloadItem> items = new ArrayList<FrostDownloadItem>();
        for (int i = this.getItemCount() - 1; i >= 0; --i) {
            FrostDownloadItem dlItem = (FrostDownloadItem)this.getItemAt(i);
            if (!dlItem.isExternal()) continue;
            items.add(dlItem);
        }
        if (items.size() > 0) {
            ModelItem[] itemsArray = new FrostDownloadItem[items.size()];
            items.toArray(itemsArray);
            this.removeItems(itemsArray);
        }
    }

    public boolean removeItems(ModelItem[] items) {
        ArrayList<String> oldChunkFilesList = new ArrayList<String>(items.length);
        String dlDir = Core.frostSettings.getValue("downloadDirectory");
        for (ModelItem element : items) {
            FrostDownloadItem item = (FrostDownloadItem)element;
            oldChunkFilesList.add(item.getFilename());
        }
        RemoveChunksThread t = new RemoveChunksThread(oldChunkFilesList, dlDir);
        t.start();
        return super.removeItems(items);
    }

    public void restartItems(ModelItem[] items) {
        for (int x = items.length - 1; x >= 0; --x) {
            FrostDownloadItem dlItem = (FrostDownloadItem)items[x];
            if (dlItem.getState() != 4 && dlItem.getState() != 1 && dlItem.getState() != 3) continue;
            dlItem.setState(1);
            dlItem.setRetries(0);
            dlItem.setLastDownloadStopTime(0L);
            dlItem.setEnabled(true);
        }
    }

    public synchronized void setAllItemsEnabled(Boolean enabled) {
        for (int x = 0; x < this.getItemCount(); ++x) {
            FrostDownloadItem dlItem = (FrostDownloadItem)this.getItemAt(x);
            if (dlItem.getState() == 3) continue;
            dlItem.setEnabled(enabled);
            FileTransferManager.inst().getDownloadManager().notifyDownloadItemEnabledStateChanged(dlItem);
        }
    }

    public void setItemsEnabled(Boolean enabled, ModelItem[] items) {
        for (ModelItem element : items) {
            FrostDownloadItem item = (FrostDownloadItem)element;
            if (item.getState() == 3) continue;
            item.setEnabled(enabled);
            FileTransferManager.inst().getDownloadManager().notifyDownloadItemEnabledStateChanged(item);
        }
    }

    public void exitSave() throws StorageException {
        List itemList = this.getItems();
        try {
            FrostFilesStorage.inst().saveDownloadFiles(itemList);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Error saving download items", e);
            throw new StorageException("Error saving download items");
        }
    }

    public void initialize() throws StorageException {
        List<FrostDownloadItem> downloadItems;
        try {
            downloadItems = FrostFilesStorage.inst().loadDownloadFiles();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Error loading download items", e);
            throw new StorageException("Error loading download items");
        }
        for (FrostDownloadItem di : downloadItems) {
            this.addDownloadItem(di);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemoveChunksThread
    extends Thread {
        private final ArrayList<String> oldChunkFilesList;
        private final String dlDir;

        public RemoveChunksThread(ArrayList<String> al, String dlDir) {
            this.oldChunkFilesList = al;
            this.dlDir = dlDir;
        }

        @Override
        public void run() {
            File[] files = new File(this.dlDir).listFiles();
            for (int i = 0; i < this.oldChunkFilesList.size(); ++i) {
                String filename = this.oldChunkFilesList.get(i);
                for (File element : files) {
                    if (!element.getName().equals(filename + ".data") && !element.getName().equals(filename + ".redirect") && !element.getName().equals(filename + ".checkblocks")) continue;
                    logger.info("Removing " + element.getName());
                    element.delete();
                }
            }
        }
    }
}

