/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.search;

import frost.util.TextSearchFun;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchParameters {
    private final boolean isSimpleSearch;
    public static final int EXTENSIONS_ALL = 1;
    public static final int EXTENSIONS_AUDIO = 2;
    public static final int EXTENSIONS_VIDEO = 3;
    public static final int EXTENSIONS_IMAGES = 4;
    public static final int EXTENSIONS_DOCUMENTS = 5;
    public static final int EXTENSIONS_ARCHIVES = 6;
    public static final int EXTENSIONS_EXECUTABLES = 7;
    private int extensions = 1;
    private String tabText = null;
    private boolean hideFilesWithoutChkKey = false;
    private boolean hideBadUserFiles = false;
    private boolean hideCheckUserFiles = false;
    private boolean hideObserveUserFiles = false;
    private List<String> simpleSearchStrings = null;
    private List<String> simpleSearchNotStrings = null;
    private List<String> name = null;
    private List<String> comment = null;
    private List<String> keyword = null;
    private List<String> owner = null;
    private List<String> notName = null;
    private List<String> notComment = null;
    private List<String> notKeyword = null;
    private List<String> notOwner = null;
    private static List<String> emptyList = new LinkedList<String>();

    public SearchParameters(boolean simpleSearch) {
        this.isSimpleSearch = simpleSearch;
    }

    public String getTabText() {
        if (this.tabText == null) {
            ArrayList<String> allStrings = new ArrayList<String>();
            if (this.isSimpleSearch()) {
                allStrings.addAll(this.getSimpleSearchStrings());
                if (this.getSimpleSearchNotStrings().size() > 0) {
                    allStrings.add("NOT");
                    allStrings.addAll(this.getSimpleSearchNotStrings());
                }
            } else {
                allStrings.addAll(this.getName());
                allStrings.addAll(this.getComment());
                allStrings.addAll(this.getKeyword());
                allStrings.addAll(this.getOwner());
                if (this.getNotName().size() > 0 || this.getNotComment().size() > 0 || this.getNotKeyword().size() > 0 || this.getNotOwner().size() > 0) {
                    allStrings.add("NOT");
                    allStrings.addAll(this.getNotName());
                    allStrings.addAll(this.getNotComment());
                    allStrings.addAll(this.getNotKeyword());
                    allStrings.addAll(this.getNotOwner());
                }
            }
            int maxTextLength = 30;
            StringBuilder sb = new StringBuilder();
            Iterator i = allStrings.iterator();
            while (i.hasNext() && sb.length() <= 30) {
                String s = (String)i.next();
                sb.append(s).append(" ");
            }
            if (sb.length() > 30) {
                sb.setLength(30);
                sb.append("...");
            }
            this.tabText = sb.toString().trim();
            if (this.tabText.length() == 0) {
                this.tabText = "*";
            }
        }
        return this.tabText;
    }

    public void setExtensions(String searchType) {
        this.extensions = 1;
        if (searchType.equals("SearchPane.fileTypes.audio")) {
            this.extensions = 2;
        } else if (searchType.equals("SearchPane.fileTypes.video")) {
            this.extensions = 3;
        } else if (searchType.equals("SearchPane.fileTypes.images")) {
            this.extensions = 4;
        } else if (searchType.equals("SearchPane.fileTypes.documents")) {
            this.extensions = 5;
        } else if (searchType.equals("SearchPane.fileTypes.executables")) {
            this.extensions = 7;
        } else if (searchType.equals("SearchPane.fileTypes.archives")) {
            this.extensions = 6;
        }
    }

    public int getExtensions() {
        return this.extensions;
    }

    public void setSimpleSearchString(String simpleSearchStr) {
        List<String>[] res = TextSearchFun.splitStrings(simpleSearchStr, true);
        this.simpleSearchStrings = res[0];
        this.simpleSearchNotStrings = res[1];
    }

    public void setCommentString(String commentStr) {
        List<String>[] res = TextSearchFun.splitStrings(commentStr, true);
        this.comment = res[0];
        this.notComment = res[1];
    }

    public void setKeywordString(String keywordStr) {
        List<String>[] res = TextSearchFun.splitStrings(keywordStr, true);
        this.keyword = res[0];
        this.notKeyword = res[1];
    }

    public void setNameString(String nameStr) {
        List<String>[] res = TextSearchFun.splitStrings(nameStr, true);
        this.name = res[0];
        this.notName = res[1];
    }

    public void setOwnerString(String ownerStr) {
        List<String>[] res = TextSearchFun.splitStrings(ownerStr, true);
        this.owner = res[0];
        this.notOwner = res[1];
    }

    public List<String> getComment() {
        if (this.comment == null) {
            return emptyList;
        }
        return this.comment;
    }

    public List<String> getKeyword() {
        if (this.keyword == null) {
            return emptyList;
        }
        return this.keyword;
    }

    public List<String> getName() {
        if (this.name == null) {
            return emptyList;
        }
        return this.name;
    }

    public List<String> getOwner() {
        if (this.owner == null) {
            return emptyList;
        }
        return this.owner;
    }

    public List<String> getNotComment() {
        if (this.notComment == null) {
            return emptyList;
        }
        return this.notComment;
    }

    public List<String> getNotKeyword() {
        if (this.notKeyword == null) {
            return emptyList;
        }
        return this.notKeyword;
    }

    public List<String> getNotName() {
        if (this.notName == null) {
            return emptyList;
        }
        return this.notName;
    }

    public List<String> getNotOwner() {
        if (this.notOwner == null) {
            return emptyList;
        }
        return this.notOwner;
    }

    public boolean isSimpleSearch() {
        return this.isSimpleSearch;
    }

    public List<String> getSimpleSearchNotStrings() {
        return this.simpleSearchNotStrings;
    }

    public List<String> getSimpleSearchStrings() {
        return this.simpleSearchStrings;
    }

    public boolean isHideFilesWithoutChkKey() {
        return this.hideFilesWithoutChkKey;
    }

    public void setHideFilesWithoutChkKey(boolean hideFilesWithoutChkKey) {
        this.hideFilesWithoutChkKey = hideFilesWithoutChkKey;
    }

    public boolean isHideBadUserFiles() {
        return this.hideBadUserFiles;
    }

    public void setHideBadUserFiles(boolean hideBadUserFiles) {
        this.hideBadUserFiles = hideBadUserFiles;
    }

    public boolean isHideCheckUserFiles() {
        return this.hideCheckUserFiles;
    }

    public void setHideCheckUserFiles(boolean hideCheckUserFiles) {
        this.hideCheckUserFiles = hideCheckUserFiles;
    }

    public boolean isHideObserveUserFiles() {
        return this.hideObserveUserFiles;
    }

    public void setHideObserveUserFiles(boolean hideObserveUserFiles) {
        this.hideObserveUserFiles = hideObserveUserFiles;
    }
}

