/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.search;

import frost.Core;
import frost.MainFrame;
import frost.fcp.FcpHandler;
import frost.fileTransfer.common.FileListFileDetailsDialog;
import frost.fileTransfer.search.FrostSearchItem;
import frost.fileTransfer.search.SearchModel;
import frost.util.CopyToClipboard;
import frost.util.gui.CloseableTabbedPane;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.model.ModelItem;
import frost.util.model.SortedModelTable;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class SearchTable
extends SortedModelTable {
    private SearchModel searchModel;
    private CloseableTabbedPane tabPane;
    private String searchText;
    private PopupMenuSearch popupMenuSearch = null;
    private Language language = Language.getInstance();
    private List<FrostSearchItem> searchItems = new LinkedList<FrostSearchItem>();

    public SearchTable(SearchModel m, CloseableTabbedPane t, String searchText) {
        super(m);
        this.searchModel = m;
        this.tabPane = t;
        this.searchText = searchText;
        this.setupTableFont();
        Listener l = new Listener();
        this.getTable().addMouseListener(l);
        this.getScrollPane().addMouseListener(l);
    }

    public void addSearchItem(FrostSearchItem i) {
        this.searchItems.add(i);
    }

    public void searchFinished(Component tabComponent) {
        for (FrostSearchItem fsi : this.searchItems) {
            this.searchModel.addSearchItem(fsi);
        }
        this.searchItems.clear();
        int myIx = this.tabPane.indexOfComponent(tabComponent);
        String newTitle = this.searchText + " (" + this.searchModel.getItemCount() + ")";
        this.tabPane.setTitleAt(myIx, newTitle);
    }

    public void searchCancelled() {
        this.searchItems.clear();
    }

    private PopupMenuSearch getPopupMenuSearch() {
        if (this.popupMenuSearch == null) {
            this.popupMenuSearch = new PopupMenuSearch();
            this.language.addLanguageListener(this.popupMenuSearch);
        }
        return this.popupMenuSearch;
    }

    private void setupTableFont() {
        int fontSize;
        int fontStyle;
        String fontName = Core.frostSettings.getValue("fileListFontName");
        Font font = new Font(fontName, fontStyle = Core.frostSettings.getIntValue("fileListFontStyle"), fontSize = Core.frostSettings.getIntValue("fileListFontSize"));
        if (!font.getFamily().equals(fontName)) {
            Core.frostSettings.setValue("fileListFontName", "SansSerif");
            font = new Font("SansSerif", fontStyle, fontSize);
        }
        this.getTable().setFont(font);
    }

    private void searchTableDoubleClick(MouseEvent e) {
        int row = this.getTable().rowAtPoint(e.getPoint());
        int col = this.getTable().columnAtPoint(e.getPoint());
        if (row > -1 && col == 8) {
            this.showDetails();
            return;
        }
        this.addItemsToDownloadTable(this.getSelectedItems());
    }

    private void showDetails() {
        ModelItem[] selectedItems = this.getSelectedItems();
        if (selectedItems.length != 1) {
            return;
        }
        FrostSearchItem item = (FrostSearchItem)selectedItems[0];
        new FileListFileDetailsDialog((Frame)MainFrame.getInstance(), true).startDialog(item.getFrostFileListFileObject());
    }

    private void addItemsToDownloadTable(ModelItem[] selectedItems) {
        if (selectedItems == null) {
            selectedItems = (ModelItem[])this.searchModel.getItems().toArray();
        }
        this.searchModel.addItemsToDownloadTable(selectedItems);
        for (int x = 0; x < selectedItems.length; ++x) {
            FrostSearchItem si = (FrostSearchItem)selectedItems[x];
            int i = this.model.indexOf(si);
            this.fireTableRowsUpdated(i, i);
        }
    }

    private class PopupMenuSearch
    extends JSkinnablePopupMenu
    implements ActionListener,
    LanguageListener {
        JMenuItem cancelItem = new JMenuItem();
        JMenuItem downloadAllKeysItem = new JMenuItem();
        JMenuItem downloadSelectedKeysItem = new JMenuItem();
        private JMenu copyToClipboardMenu = new JMenu();
        private JMenuItem copyKeysAndNamesItem = new JMenuItem();
        private JMenuItem copyKeysItem = new JMenuItem();
        private JMenuItem copyExtendedInfoItem = new JMenuItem();
        private JMenuItem detailsItem = new JMenuItem();

        public PopupMenuSearch() {
            this.initialize();
        }

        private void initialize() {
            this.refreshLanguage();
            this.copyToClipboardMenu.add(this.copyKeysAndNamesItem);
            if (FcpHandler.isFreenet05()) {
                this.copyToClipboardMenu.add(this.copyKeysItem);
            }
            this.copyToClipboardMenu.add(this.copyExtendedInfoItem);
            this.downloadSelectedKeysItem.addActionListener(this);
            this.downloadAllKeysItem.addActionListener(this);
            this.copyKeysAndNamesItem.addActionListener(this);
            this.copyKeysItem.addActionListener(this);
            this.copyExtendedInfoItem.addActionListener(this);
            this.detailsItem.addActionListener(this);
        }

        private void refreshLanguage() {
            this.downloadSelectedKeysItem.setText(SearchTable.this.language.getString("SearchPane.resultTable.popupmenu.downloadSelectedKeys"));
            this.downloadAllKeysItem.setText(SearchTable.this.language.getString("SearchPane.resultTable.popupmenu.downloadAllKeys"));
            this.cancelItem.setText(SearchTable.this.language.getString("Common.cancel"));
            this.copyKeysItem.setText(SearchTable.this.language.getString("Common.copyToClipBoard.copyKeysOnly"));
            this.copyKeysAndNamesItem.setText(SearchTable.this.language.getString("Common.copyToClipBoard.copyKeysWithFilenames"));
            this.copyExtendedInfoItem.setText(SearchTable.this.language.getString("Common.copyToClipBoard.copyExtendedInfo"));
            this.copyToClipboardMenu.setText(SearchTable.this.language.getString("Common.copyToClipBoard") + "...");
            this.detailsItem.setText(SearchTable.this.language.getString("Common.details"));
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.downloadSelectedKeysItem) {
                this.downloadSelectedKeys();
            }
            if (e.getSource() == this.downloadAllKeysItem) {
                this.downloadAllKeys();
            }
            if (e.getSource() == this.copyKeysItem) {
                CopyToClipboard.copyKeys(SearchTable.this.getSelectedItems());
            }
            if (e.getSource() == this.copyKeysAndNamesItem) {
                CopyToClipboard.copyKeysAndFilenames(SearchTable.this.getSelectedItems());
            }
            if (e.getSource() == this.copyExtendedInfoItem) {
                CopyToClipboard.copyExtendedInfo(SearchTable.this.getSelectedItems());
            }
            if (e.getSource() == this.detailsItem) {
                SearchTable.this.showDetails();
            }
        }

        private void downloadAllKeys() {
            SearchTable.this.addItemsToDownloadTable(null);
        }

        private void downloadSelectedKeys() {
            SearchTable.this.addItemsToDownloadTable(SearchTable.this.getSelectedItems());
        }

        public void languageChanged(LanguageEvent event) {
            this.refreshLanguage();
        }

        public void show(Component invoker, int x, int y) {
            this.removeAll();
            ModelItem[] selectedItems = SearchTable.this.getSelectedItems();
            if (selectedItems.length > 0) {
                this.add(this.copyToClipboardMenu);
                this.addSeparator();
            }
            if (selectedItems.length != 0) {
                this.add(this.downloadSelectedKeysItem);
                this.addSeparator();
            }
            this.add(this.downloadAllKeysItem);
            if (selectedItems.length == 1) {
                this.addSeparator();
                this.add(this.detailsItem);
            }
            super.show(invoker, x, y);
        }
    }

    private class Listener
    extends MouseAdapter
    implements MouseListener {
        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2) {
                if (e.getSource() == SearchTable.this.getTable()) {
                    SearchTable.this.searchTableDoubleClick(e);
                }
            } else if (e.isPopupTrigger() && (e.getSource() == SearchTable.this.getTable() || e.getSource() == SearchTable.this.getScrollPane())) {
                this.showSearchTablePopupMenu(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getClickCount() == 1 && e.isPopupTrigger() && (e.getSource() == SearchTable.this.getTable() || e.getSource() == SearchTable.this.getScrollPane())) {
                this.showSearchTablePopupMenu(e);
            }
        }

        private void showSearchTablePopupMenu(MouseEvent e) {
            Point p = e.getPoint();
            int y = SearchTable.this.getTable().rowAtPoint(p);
            if (y < 0) {
                return;
            }
            if (!SearchTable.this.getTable().getSelectionModel().isSelectedIndex(y)) {
                SearchTable.this.getTable().getSelectionModel().setSelectionInterval(y, y);
            }
            SearchTable.this.getPopupMenuSearch().show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

