/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.search;

import frost.Core;
import frost.fileTransfer.FrostFileListFileObject;
import frost.fileTransfer.FrostFileListFileObjectOwner;
import frost.fileTransfer.search.FrostSearchItem;
import frost.fileTransfer.search.SearchPanel;
import frost.fileTransfer.search.SearchParameters;
import frost.fileTransfer.search.SearchTable;
import frost.identities.Identity;
import frost.storage.FileListCallback;
import frost.storage.perst.filelist.FileListStorage;
import frost.util.TextSearchFun;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

class SearchThread
extends Thread
implements FileListCallback {
    private static final Logger logger = Logger.getLogger(SearchThread.class.getName());
    private SearchParameters searchParams;
    private String[] audioExtension;
    private String[] videoExtension;
    private String[] imageExtension;
    private String[] documentExtension;
    private String[] executableExtension;
    private String[] archiveExtension;
    private int allFileCount;
    private int maxSearchResults;
    private SearchTable searchTable;
    private boolean isCancelRequested = false;
    private boolean isMaximumSearchResultsReached = false;
    private SearchPanel.ProxyPanel tabComponent;

    private boolean isCancelRequested() {
        return this.isCancelRequested;
    }

    public void requestCancel() {
        this.isCancelRequested = true;
    }

    private boolean isMaximumSearchResultsReached() {
        return this.isMaximumSearchResultsReached;
    }

    public void maximumSearchResultsReached() {
        this.isMaximumSearchResultsReached = true;
    }

    private String lowerCase(String s) {
        if (s == null) {
            return "";
        }
        return s.toLowerCase();
    }

    private boolean searchFile1(FrostFileListFileObject fo) {
        FrostFileListFileObjectOwner ob;
        Iterator<FrostFileListFileObjectOwner> i;
        boolean accept;
        if (this.searchParams.isHideFilesWithoutChkKey() && (fo.getKey() == null || fo.getKey().length() == 0)) {
            return false;
        }
        if (this.searchParams.isHideBadUserFiles() || this.searchParams.isHideCheckUserFiles() || this.searchParams.isHideObserveUserFiles()) {
            accept = true;
            i = fo.getFrostFileListFileObjectOwnerIterator();
            while (i.hasNext()) {
                Identity id;
                ob = i.next();
                if (ob.getOwner() == null || (id = Core.getIdentities().getIdentity(ob.getOwner())) == null) continue;
                if (id.isBAD() && this.searchParams.isHideBadUserFiles()) {
                    accept = false;
                } else if (id.isCHECK() && this.searchParams.isHideCheckUserFiles()) {
                    accept = false;
                } else if (id.isOBSERVE() && this.searchParams.isHideObserveUserFiles()) {
                    accept = false;
                }
                if (!id.isGOOD() && (!id.isOBSERVE() || this.searchParams.isHideObserveUserFiles())) continue;
                accept = true;
                break;
            }
            if (!accept) {
                return false;
            }
        }
        if (this.searchParams.getExtensions() != 1) {
            accept = false;
            i = fo.getFrostFileListFileObjectOwnerIterator();
            while (i.hasNext()) {
                ob = i.next();
                String name = this.lowerCase(ob.getName());
                if (this.searchParams.getExtensions() == 2) {
                    accept = this.checkType(this.audioExtension, name);
                } else if (this.searchParams.getExtensions() == 3) {
                    accept = this.checkType(this.videoExtension, name);
                } else if (this.searchParams.getExtensions() == 4) {
                    accept = this.checkType(this.imageExtension, name);
                } else if (this.searchParams.getExtensions() == 5) {
                    accept = this.checkType(this.documentExtension, name);
                } else if (this.searchParams.getExtensions() == 6) {
                    accept = this.checkType(this.archiveExtension, name);
                } else if (this.searchParams.getExtensions() == 7) {
                    accept = this.checkType(this.executableExtension, name);
                }
                if (!accept) continue;
                break;
            }
            if (!accept) {
                return false;
            }
        }
        return true;
    }

    private boolean searchFile2(FrostFileListFileObject fo) {
        if (this.searchParams.isSimpleSearch()) {
            return this.searchFile2NotStringsSimple(fo) && this.searchFile2StringsSimple(fo);
        }
        return this.searchFile2NotStringsAdvanced(fo) && this.searchFile2StringsAdvanced(fo);
    }

    private boolean searchFile2NotStringsAdvanced(FrostFileListFileObject fo) {
        if (this.searchParams.getNotName().isEmpty() && this.searchParams.getNotComment().isEmpty() && this.searchParams.getNotKeyword().isEmpty() && this.searchParams.getNotOwner().isEmpty()) {
            return true;
        }
        Iterator<FrostFileListFileObjectOwner> i = fo.getFrostFileListFileObjectOwnerIterator();
        while (i.hasNext()) {
            FrostFileListFileObjectOwner ob = i.next();
            if (TextSearchFun.containsAnyString(this.lowerCase(ob.getName()), this.searchParams.getNotName())) {
                return false;
            }
            if (TextSearchFun.containsAnyString(this.lowerCase(ob.getComment()), this.searchParams.getNotComment())) {
                return false;
            }
            if (TextSearchFun.containsAnyString(this.lowerCase(ob.getKeywords()), this.searchParams.getNotKeyword())) {
                return false;
            }
            if (!TextSearchFun.containsAnyString(this.lowerCase(ob.getOwner()), this.searchParams.getNotOwner())) continue;
            return false;
        }
        return true;
    }

    private boolean searchFile2NotStringsSimple(FrostFileListFileObject fo) {
        if (this.searchParams.getSimpleSearchNotStrings().isEmpty()) {
            return true;
        }
        Iterator<FrostFileListFileObjectOwner> i = fo.getFrostFileListFileObjectOwnerIterator();
        while (i.hasNext()) {
            FrostFileListFileObjectOwner ob = i.next();
            String name = this.lowerCase(ob.getName());
            String comment = this.lowerCase(ob.getComment());
            String keyword = this.lowerCase(ob.getKeywords());
            for (int x = 0; x < this.searchParams.getSimpleSearchNotStrings().size(); ++x) {
                String notString = this.searchParams.getSimpleSearchNotStrings().get(x);
                if (name.indexOf(notString) > -1) {
                    return false;
                }
                if (comment.indexOf(notString) > -1) {
                    return false;
                }
                if (keyword.indexOf(notString) <= -1) continue;
                return false;
            }
        }
        return true;
    }

    private boolean searchFile2StringsAdvanced(FrostFileListFileObject fo) {
        boolean nameFound = false;
        boolean commentFound = false;
        boolean keywordFound = false;
        boolean ownerFound = false;
        if (this.searchParams.getName().isEmpty()) {
            nameFound = true;
        }
        if (this.searchParams.getComment().isEmpty()) {
            commentFound = true;
        }
        if (this.searchParams.getKeyword().isEmpty()) {
            keywordFound = true;
        }
        if (this.searchParams.getOwner().isEmpty()) {
            ownerFound = true;
        }
        if (nameFound && commentFound && keywordFound && ownerFound) {
            return true;
        }
        Iterator<FrostFileListFileObjectOwner> i = fo.getFrostFileListFileObjectOwnerIterator();
        while (i.hasNext()) {
            FrostFileListFileObjectOwner ob = i.next();
            String name = this.lowerCase(ob.getName());
            if (!nameFound && name.length() > 0 && TextSearchFun.containsEachString(name, this.searchParams.getName())) {
                nameFound = true;
            }
            String comment = this.lowerCase(ob.getComment());
            if (!commentFound && comment.length() > 0 && TextSearchFun.containsEachString(comment, this.searchParams.getComment())) {
                commentFound = true;
            }
            String keyword = this.lowerCase(ob.getKeywords());
            if (!keywordFound && keyword.length() > 0 && TextSearchFun.containsEachString(keyword, this.searchParams.getKeyword())) {
                keywordFound = true;
            }
            String owner = this.lowerCase(ob.getOwner());
            if (!ownerFound && owner.length() > 0 && TextSearchFun.containsEachString(owner, this.searchParams.getOwner())) {
                ownerFound = true;
            }
            if (!nameFound || !commentFound || !keywordFound || !ownerFound) continue;
            return true;
        }
        return nameFound && commentFound && keywordFound && ownerFound;
    }

    private boolean searchFile2StringsSimple(FrostFileListFileObject fo) {
        if (this.searchParams.getSimpleSearchStrings().isEmpty()) {
            return true;
        }
        HashMap<String, Boolean> searchStrings = new HashMap<String, Boolean>();
        for (int x = 0; x < this.searchParams.getSimpleSearchStrings().size(); ++x) {
            String string = this.searchParams.getSimpleSearchStrings().get(x);
            searchStrings.put(string, Boolean.FALSE);
        }
        Iterator<FrostFileListFileObjectOwner> i = fo.getFrostFileListFileObjectOwnerIterator();
        while (i.hasNext()) {
            FrostFileListFileObjectOwner ob = i.next();
            String name = this.lowerCase(ob.getName());
            String comment = this.lowerCase(ob.getComment());
            String keyword = this.lowerCase(ob.getKeywords());
            for (int x = 0; x < this.searchParams.getSimpleSearchStrings().size(); ++x) {
                String string = this.searchParams.getSimpleSearchStrings().get(x);
                if (name.indexOf(string) > -1) {
                    searchStrings.put(string, Boolean.TRUE);
                }
                if (comment.indexOf(string) > -1) {
                    searchStrings.put(string, Boolean.TRUE);
                }
                if (keyword.indexOf(string) <= -1) continue;
                searchStrings.put(string, Boolean.TRUE);
            }
        }
        boolean allFound = true;
        for (Boolean b : searchStrings.values()) {
            if (b.booleanValue()) continue;
            allFound = false;
            break;
        }
        return allFound;
    }

    private boolean checkType(String[] extension, String filename) {
        boolean accepted = false;
        for (int i = 0; i < extension.length; ++i) {
            if (!filename.endsWith(extension[i])) continue;
            accepted = true;
        }
        return accepted;
    }

    private void addSearchResult(FrostFileListFileObject fo) {
        ++this.allFileCount;
        if (this.allFileCount > this.maxSearchResults) {
            logger.info("NOTE: maxSearchResults reached (" + this.maxSearchResults + ")!");
            this.maximumSearchResultsReached();
            return;
        }
        FrostSearchItem searchItem = new FrostSearchItem(fo);
        this.searchTable.addSearchItem(searchItem);
    }

    public boolean fileRetrieved(FrostFileListFileObject fo) {
        if (this.isMaximumSearchResultsReached()) {
            return this.isMaximumSearchResultsReached();
        }
        if (this.searchFile1(fo) && this.searchFile2(fo)) {
            this.addSearchResult(fo);
        }
        return this.isCancelRequested();
    }

    public void run() {
        this.allFileCount = 0;
        String[] searchForExtensions = null;
        if (this.searchParams.getExtensions() != 1) {
            if (this.searchParams.getExtensions() == 2) {
                searchForExtensions = this.audioExtension;
            } else if (this.searchParams.getExtensions() == 3) {
                searchForExtensions = this.videoExtension;
            } else if (this.searchParams.getExtensions() == 4) {
                searchForExtensions = this.imageExtension;
            } else if (this.searchParams.getExtensions() == 5) {
                searchForExtensions = this.documentExtension;
            } else if (this.searchParams.getExtensions() == 6) {
                searchForExtensions = this.archiveExtension;
            } else if (this.searchParams.getExtensions() == 7) {
                searchForExtensions = this.executableExtension;
            }
        }
        if (this.searchParams.isSimpleSearch()) {
            FileListStorage.inst().retrieveFiles(this, this.searchParams.getSimpleSearchStrings(), this.searchParams.getSimpleSearchStrings(), this.searchParams.getSimpleSearchStrings(), null, searchForExtensions);
        } else {
            FileListStorage.inst().retrieveFiles(this, this.searchParams.getName(), this.searchParams.getComment(), this.searchParams.getKeyword(), this.searchParams.getOwner(), searchForExtensions);
        }
        if (this.isCancelRequested()) {
            this.searchTable.searchCancelled();
        } else {
            this.searchTable.searchFinished(this.tabComponent);
        }
    }

    public SearchThread(SearchParameters searchParams, SearchTable searchTable, SearchPanel.ProxyPanel tabComponent) {
        this.searchParams = searchParams;
        this.tabComponent = tabComponent;
        tabComponent.setSearchThread(this);
        this.searchTable = searchTable;
        this.audioExtension = Core.frostSettings.getArrayValue("audioExtension");
        this.videoExtension = Core.frostSettings.getArrayValue("videoExtension");
        this.documentExtension = Core.frostSettings.getArrayValue("documentExtension");
        this.executableExtension = Core.frostSettings.getArrayValue("executableExtension");
        this.archiveExtension = Core.frostSettings.getArrayValue("archiveExtension");
        this.imageExtension = Core.frostSettings.getArrayValue("imageExtension");
        this.maxSearchResults = Core.frostSettings.getIntValue("maxSearchResults");
        if (this.maxSearchResults <= 0) {
            this.maxSearchResults = 10000;
        }
    }
}

