/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.upload;

import frost.fcp.FcpHandler;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.fileTransfer.upload.UploadTicker;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenerateChkThread
extends Thread {
    private UploadTicker ticker;
    private static final Logger logger = Logger.getLogger(GenerateChkThread.class.getName());
    FrostUploadItem uploadItem = null;

    protected GenerateChkThread(UploadTicker newTicker, FrostUploadItem ulItem) {
        this.ticker = newTicker;
        this.uploadItem = ulItem;
    }

    public void run() {
        this.ticker.generatingThreadStarted();
        try {
            this.generateCHK();
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Exception thrown in run()", e);
        }
        this.ticker.generatingThreadFinished();
    }

    private void generateCHK() {
        logger.info("CHK generation started for file: " + this.uploadItem.getFile().getName());
        String chkkey = null;
        try {
            chkkey = FcpHandler.inst().generateCHK(this.uploadItem.getFile());
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Encoding failed", t);
            this.uploadItem.setState(7);
            return;
        }
        if (chkkey != null) {
            String prefix = new String("freenet:");
            if (chkkey.startsWith(prefix)) {
                chkkey = chkkey.substring(prefix.length());
            }
        } else {
            logger.warning("Could not generate CHK key for file.");
            logger.log(Level.SEVERE, "Encoding failed");
            this.uploadItem.setState(7);
            return;
        }
        this.uploadItem.setKey(chkkey);
        this.uploadItem.setState(7);
    }
}

