/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.upload;

import frost.MainFrame;
import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.sharing.FrostSharedFileItem;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.storage.ExitSavable;
import frost.storage.StorageException;
import frost.storage.perst.FrostFilesStorage;
import frost.util.gui.translation.Language;
import frost.util.model.ModelItem;
import frost.util.model.SortedModel;
import frost.util.model.SortedTableFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadModel
extends SortedModel
implements ExitSavable {
    private static final Logger logger = Logger.getLogger(UploadModel.class.getName());

    public UploadModel(SortedTableFormat f) {
        super(f);
    }

    public boolean addNewUploadItemFromSharedFile(FrostSharedFileItem sfi) {
        FrostUploadItem newUlItem = new FrostUploadItem(sfi.getFile());
        newUlItem.setSharedFileItem(sfi);
        return this.addNewUploadItem(newUlItem);
    }

    public void addExternalItem(FrostUploadItem i) {
        this.addItem(i);
    }

    public synchronized boolean addNewUploadItem(FrostUploadItem itemToAdd) {
        String pathToAdd = itemToAdd.getFile().getPath();
        for (int x = 0; x < this.getItemCount(); ++x) {
            FrostUploadItem item = (FrostUploadItem)this.getItemAt(x);
            if (!pathToAdd.equals(item.getFile().getPath())) continue;
            if (itemToAdd.isSharedFile() && !item.isSharedFile()) {
                item.setSharedFileItem(itemToAdd.getSharedFileItem());
                return true;
            }
            return false;
        }
        this.addItem(itemToAdd);
        return true;
    }

    private synchronized void addConsistentUploadItem(FrostUploadItem itemToAdd) {
        this.addItem(itemToAdd);
    }

    public void notifySharedFileUploadWasSuccessful(FrostUploadItem ulItemToRemove) {
        for (int i = this.getItemCount() - 1; i >= 0; --i) {
            FrostUploadItem ulItem = (FrostUploadItem)this.getItemAt(i);
            if (ulItem != ulItemToRemove) continue;
            this.removeItems(new FrostUploadItem[]{ulItemToRemove});
            break;
        }
    }

    public synchronized void removeNotExistingFiles() {
        ArrayList<FrostUploadItem> items = new ArrayList<FrostUploadItem>();
        for (int i = this.getItemCount() - 1; i >= 0; --i) {
            FrostUploadItem ulItem = (FrostUploadItem)this.getItemAt(i);
            if (ulItem.isExternal()) continue;
            if (!ulItem.getFile().exists()) {
                items.add(ulItem);
                logger.severe("Upload items file does not exist, removed from upload files: " + ulItem.getFile().getPath());
                continue;
            }
            if (ulItem.getFileSize() == ulItem.getFile().length()) continue;
            items.add(ulItem);
            logger.severe("Upload items file size changed, removed from upload files: " + ulItem.getFile().getPath());
        }
        if (items.size() > 0) {
            ModelItem[] itemsArray = new FrostUploadItem[items.size()];
            for (int i = 0; i < itemsArray.length; ++i) {
                itemsArray[i] = (FrostUploadItem)items.get(i);
            }
            this.removeItems(itemsArray);
            Language language = Language.getInstance();
            String title = language.getString("UploadPane.invalidUploadFilesRemoved.title");
            String text = language.getString("UploadPane.invalidUploadFilesRemoved.text");
            JOptionPane.showMessageDialog(MainFrame.getInstance(), text, title, 0);
        }
    }

    public void uploadItems(ModelItem[] items) {
        for (ModelItem element : items) {
            FrostUploadItem ulItem = (FrostUploadItem)element;
            if (ulItem.getState() != 8 && ulItem.getState() != 1) continue;
            ulItem.setRetries(0);
            ulItem.setLastUploadStopTimeMillis(0L);
            ulItem.setEnabled(true);
            ulItem.setState(7);
        }
    }

    public void generateChkItems(ModelItem[] items) {
        for (ModelItem element : items) {
            FrostUploadItem ulItem = (FrostUploadItem)element;
            if (ulItem.getState() != 7 && ulItem.getState() != 8 || ulItem.getKey() != null || ulItem.isSharedFile()) continue;
            ulItem.setState(5);
        }
    }

    public synchronized void removeFinishedUploads() {
        ArrayList<FrostUploadItem> items = new ArrayList<FrostUploadItem>();
        for (int i = this.getItemCount() - 1; i >= 0; --i) {
            FrostUploadItem ulItem = (FrostUploadItem)this.getItemAt(i);
            if (ulItem.getState() != 1) continue;
            items.add(ulItem);
        }
        if (items.size() > 0) {
            ModelItem[] itemsArray = new FrostUploadItem[items.size()];
            items.toArray(itemsArray);
            this.removeItems(itemsArray);
        }
    }

    public synchronized void removeExternalUploads() {
        ArrayList<FrostUploadItem> items = new ArrayList<FrostUploadItem>();
        for (int i = this.getItemCount() - 1; i >= 0; --i) {
            FrostUploadItem ulItem = (FrostUploadItem)this.getItemAt(i);
            if (!ulItem.isExternal()) continue;
            items.add(ulItem);
        }
        if (items.size() > 0) {
            ModelItem[] itemsArray = new FrostUploadItem[items.size()];
            items.toArray(itemsArray);
            this.removeItems(itemsArray);
        }
    }

    public void initialize(List<FrostSharedFileItem> sharedFiles) throws StorageException {
        List<FrostUploadItem> uploadItems;
        try {
            uploadItems = FrostFilesStorage.inst().loadUploadFiles(sharedFiles);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Error loading upload items", e);
            throw new StorageException("Error loading upload items");
        }
        for (FrostUploadItem di : uploadItems) {
            this.addConsistentUploadItem(di);
        }
    }

    @Override
    public void exitSave() throws StorageException {
        List itemList = this.getItems();
        try {
            FrostFilesStorage.inst().saveUploadFiles(itemList);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Error saving upload items", e);
            throw new StorageException("Error saving upload items");
        }
    }

    public synchronized void setAllItemsEnabled(Boolean enabled) {
        for (int x = 0; x < this.getItemCount(); ++x) {
            FrostUploadItem ulItem = (FrostUploadItem)this.getItemAt(x);
            if (ulItem.getState() == 1) continue;
            ulItem.setEnabled(enabled);
            FileTransferManager.inst().getUploadManager().notifyUploadItemEnabledStateChanged(ulItem);
        }
    }

    public void setItemsEnabled(Boolean enabled, ModelItem[] items) {
        for (ModelItem element : items) {
            FrostUploadItem item = (FrostUploadItem)element;
            if (item.getState() == 1) continue;
            item.setEnabled(enabled);
            FileTransferManager.inst().getUploadManager().notifyUploadItemEnabledStateChanged(item);
        }
    }
}

