/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.upload;

import frost.Core;
import frost.fcp.FcpHandler;
import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.PersistenceManager;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.fileTransfer.upload.GenerateChkThread;
import frost.fileTransfer.upload.UploadModel;
import frost.fileTransfer.upload.UploadThread;
import frost.util.Mixed;

public class UploadTicker
extends Thread {
    private final int MAX_GENERATING_THREADS = 1;
    private UploadModel model;
    private int removeNotExistingFilesCounter = 0;
    private int allocatedUploadingThreads = 0;
    private int allocatedGeneratingThreads = 0;
    private int runningUploadingThreads = 0;
    private int runningGeneratingThreads = 0;
    private Object uploadingCountLock = new Object();
    private Object generatingCountLock = new Object();

    public UploadTicker(UploadModel newModel) {
        super("Upload");
        this.model = newModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocateUploadingThread() {
        Object object = this.uploadingCountLock;
        synchronized (object) {
            ++this.allocatedUploadingThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canAllocateUploadingThread() {
        Object object = this.uploadingCountLock;
        synchronized (object) {
            if (this.allocatedUploadingThreads < Core.frostSettings.getIntValue("uploadThreads")) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean allocateGeneratingThread() {
        Object object = this.generatingCountLock;
        synchronized (object) {
            if (this.allocatedGeneratingThreads < 1) {
                ++this.allocatedGeneratingThreads;
                return true;
            }
        }
        return false;
    }

    public void generatingThreadStarted() {
        ++this.runningGeneratingThreads;
    }

    public void generatingThreadFinished() {
        --this.runningGeneratingThreads;
        this.releaseGeneratingThread();
    }

    void uploadingThreadStarted() {
        ++this.runningUploadingThreads;
    }

    void uploadThreadFinished() {
        --this.runningUploadingThreads;
        this.releaseUploadingThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseUploadingThread() {
        Object object = this.uploadingCountLock;
        synchronized (object) {
            if (this.allocatedUploadingThreads > 0) {
                --this.allocatedUploadingThreads;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseGeneratingThread() {
        Object object = this.generatingCountLock;
        synchronized (object) {
            if (this.allocatedGeneratingThreads > 0) {
                --this.allocatedGeneratingThreads;
            }
        }
    }

    public void run() {
        super.run();
        while (true) {
            Mixed.wait(1000);
            ++this.removeNotExistingFilesCounter;
            this.removeNotExistingFiles();
            this.generateCHKs();
            if (PersistenceManager.isPersistenceEnabled()) continue;
            this.startUploadThread();
        }
    }

    private void generateCHKs() {
        if (Core.isFreenetOnline() && this.allocateGeneratingThread()) {
            boolean threadLaunched = false;
            for (int i = 0; i < this.model.getItemCount() && !threadLaunched; ++i) {
                FrostUploadItem ulItem = (FrostUploadItem)this.model.getItemAt(i);
                if (ulItem.getState() != 5 && (!FcpHandler.isFreenet05() || ulItem.getKey() != null || ulItem.getState() != 7)) continue;
                GenerateChkThread newInsert = new GenerateChkThread(this, ulItem);
                ulItem.setState(6);
                newInsert.start();
                threadLaunched = true;
            }
            if (!threadLaunched) {
                this.releaseGeneratingThread();
            }
        }
    }

    private void startUploadThread() {
        if (Core.isFreenetOnline() && this.canAllocateUploadingThread()) {
            FrostUploadItem uploadItem = FileTransferManager.inst().getUploadManager().selectNextUploadItem();
            this.startUpload(uploadItem);
        }
    }

    public boolean startUpload(FrostUploadItem ulItem) {
        if (!Core.isFreenetOnline()) {
            return false;
        }
        if (ulItem == null || ulItem.getState() != 7) {
            return false;
        }
        this.allocateUploadingThread();
        ulItem.setUploadStartedMillis(System.currentTimeMillis());
        ulItem.setState(4);
        boolean doMime = !ulItem.isSharedFile();
        UploadThread newInsert = new UploadThread(this, ulItem, doMime);
        newInsert.start();
        return true;
    }

    private void removeNotExistingFiles() {
        if (this.removeNotExistingFilesCounter >= 300) {
            this.model.removeNotExistingFiles();
            this.removeNotExistingFilesCounter = 0;
        }
    }

    public int getRunningGeneratingThreads() {
        return this.runningGeneratingThreads;
    }

    public int getRunningUploadingThreads() {
        return this.runningUploadingThreads;
    }
}

