/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.boards.Board;
import frost.util.gui.translation.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoardsChooser
extends JDialog {
    private final Language language = Language.getInstance();
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    JTable boardsTable;
    BoardsTableModel boardsTableModel;
    JButton Bcancel;
    List<BoardTableEntry> boardList;
    JButton Bok;
    boolean okPressed = false;

    public BoardsChooser(Frame parent, List<Board> boards, List<Board> preselectedBoards) {
        super(parent);
        this.setModal(true);
        this.setTitle(this.language.getString("BoardsChooser.title"));
        this.boardList = new ArrayList<BoardTableEntry>();
        for (Board b : boards) {
            BoardTableEntry e = new BoardTableEntry();
            e.board = b;
            e.isSelected = Boolean.FALSE;
            if (preselectedBoards != null) {
                for (Board sb : preselectedBoards) {
                    if (!b.getName().equals(sb.getName())) continue;
                    e.isSelected = Boolean.TRUE;
                }
            }
            this.boardList.add(e);
        }
        this.initGui();
        this.setLocationRelativeTo(parent);
    }

    public BoardsChooser(Frame parent, List<Board> boards) {
        this(parent, boards, null);
    }

    private void initGui() {
        this.Bok = new JButton(this.language.getString("Common.ok"));
        this.Bok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BoardsChooser.this.okPressed = true;
                BoardsChooser.this.setVisible(false);
            }
        });
        this.Bcancel = new JButton(this.language.getString("Common.cancel"));
        this.Bcancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BoardsChooser.this.okPressed = false;
                BoardsChooser.this.setVisible(false);
            }
        });
        JPanel buttonsPanel = new JPanel(new FlowLayout(2, 8, 8));
        buttonsPanel.add(this.Bok);
        buttonsPanel.add(this.Bcancel);
        this.boardsTableModel = new BoardsTableModel(this.boardList);
        this.boardsTable = new JTable(this.boardsTableModel);
        this.boardsTable.setShowGrid(false);
        this.boardsTable.setTableHeader(null);
        this.boardsTable.setSelectionMode(0);
        this.boardsTable.setRowSelectionAllowed(true);
        this.boardsTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    int row = BoardsChooser.this.boardsTable.getSelectedRow();
                    if (row < 0) {
                        return;
                    }
                    BoardTableEntry en = BoardsChooser.this.boardList.get(row);
                    if (en == null) {
                        return;
                    }
                    en.isSelected = en.isSelected == false;
                    BoardsChooser.this.boardsTableModel.fireTableCellUpdated(row, 0);
                }
            }
        });
        TableColumn column = this.boardsTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(30);
        column.setMaxWidth(30);
        JScrollPane listScroller = new JScrollPane();
        listScroller.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5))));
        listScroller.setWheelScrollingEnabled(true);
        listScroller.setViewportView(this.boardsTable);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)listScroller, "Center");
        this.getContentPane().add((Component)buttonsPanel, "South");
        this.setSize(300, 400);
    }

    public List<Board> runDialog() {
        this.setVisible(true);
        if (!this.okPressed) {
            return null;
        }
        ArrayList<Board> chosed = new ArrayList<Board>();
        for (BoardTableEntry boardTableEntry : this.boardList) {
            if (!boardTableEntry.isSelected.booleanValue()) continue;
            chosed.add(boardTableEntry.board);
        }
        return chosed;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BoardsTableModel
    extends AbstractTableModel {
        List<BoardTableEntry> boardsList = new ArrayList<BoardTableEntry>();

        public BoardsTableModel(List<BoardTableEntry> l) {
            this.boardsList = l;
        }

        @Override
        public String getColumnName(int col) {
            return "";
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public int getRowCount() {
            if (this.boardsList == null) {
                return 0;
            }
            return this.boardsList.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int col) {
            BoardTableEntry e = this.boardsList.get(row);
            if (col == 0) {
                return e.isSelected;
            }
            return e.board.getName();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            BoardTableEntry e = this.boardsList.get(row);
            e.isSelected = (Boolean)value;
            this.fireTableCellUpdated(row, col);
        }
    }

    class BoardTableEntry {
        public Boolean isSelected;
        public Board board;

        BoardTableEntry() {
        }
    }
}

