/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.Core;
import frost.MainFrame;
import frost.boards.Board;
import frost.fileTransfer.common.TableBackgroundColors;
import frost.gui.SortedTable;
import frost.gui.model.SortedTableModel;
import frost.gui.model.TableMember;
import frost.identities.Identity;
import frost.storage.IdentitiesXmlDAO;
import frost.storage.perst.identities.IdentitiesStorage;
import frost.util.CopyToClipboard;
import frost.util.DateFun;
import frost.util.Mixed;
import frost.util.gui.FrostSwingWorker;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.joda.time.DateMidnight;
import org.joda.time.DateTimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentitiesBrowser
extends JDialog {
    private Language language = null;
    private JPanel jContentPane = null;
    private JScrollPane jScrollPane = null;
    private SortedTable identitiesTable = null;
    private JPanel buttonPanel = null;
    private JPanel mainPanel = null;
    private JButton Bclose = null;
    private JButton BmarkGOOD = null;
    private JButton BmarkOBSERVE = null;
    private JButton BmarkCHECK = null;
    private JButton BmarkBAD = null;
    private JButton Bdelete = null;
    private InnerTableModel tableModel = null;
    private JButton Bcleanup = null;
    private final JFrame parent;
    private List<InnerTableMember> allTableMembers;
    private final boolean showColoredLines;
    private PopupMenu popupMenu = null;
    private final Listener listener = new Listener();
    private final long minCleanupTime;
    private ProgressMonitor progressMonitor;
    private JLabel Llookup = null;
    private JTextField TFlookup = null;
    private JLabel Lfilter = null;
    private JTextField TFfilter = null;
    private JButton Bimport = null;
    private JButton Bexport = null;

    public IdentitiesBrowser(JFrame parent) {
        super(parent);
        this.parent = parent;
        this.language = Language.getInstance();
        this.setModal(true);
        this.showColoredLines = Core.frostSettings.getBoolValue("showColoredRows");
        this.initialize();
        this.minCleanupTime = this.getMinCleanupTime();
        this.setLocationRelativeTo(parent);
    }

    private void initialize() {
        this.setTitle("IdentitiesBrowser.title");
        this.setBounds(new Rectangle(0, 0, 630, 420));
        this.setContentPane(this.getJContentPane());
        this.getBmarkGOOD().setText("");
        this.getBmarkBAD().setText("");
        this.getBmarkCHECK().setText("");
        this.getBmarkOBSERVE().setText("");
        this.getBmarkGOOD().setIcon(MiscToolkit.loadImageIcon("/data/toolbar/weather-clear.png"));
        this.getBmarkOBSERVE().setIcon(MiscToolkit.loadImageIcon("/data/toolbar/weather-few-clouds.png"));
        this.getBmarkCHECK().setIcon(MiscToolkit.loadImageIcon("/data/toolbar/weather-overcast.png"));
        this.getBmarkBAD().setIcon(MiscToolkit.loadImageIcon("/data/toolbar/weather-storm.png"));
        MiscToolkit.configureButton(this.getBmarkGOOD(), "MessagePane.toolbar.tooltip.setToGood", this.language);
        MiscToolkit.configureButton(this.getBmarkBAD(), "MessagePane.toolbar.tooltip.setToBad", this.language);
        MiscToolkit.configureButton(this.getBmarkCHECK(), "MessagePane.toolbar.tooltip.setToCheck", this.language);
        MiscToolkit.configureButton(this.getBmarkOBSERVE(), "MessagePane.toolbar.tooltip.setToObserve", this.language);
        this.setTitle(this.language.getString("IdentitiesBrowser.title"));
        this.getBdelete().setText(this.language.getString("IdentitiesBrowser.button.delete"));
        this.getBcleanup().setText(this.language.getString("IdentitiesBrowser.button.cleanup"));
        this.getBcleanup().setToolTipText(this.language.getString("IdentitiesBrowser.button.cleanup.tooltip"));
        this.getBclose().setText(this.language.getString("IdentitiesBrowser.button.close"));
        this.getBimport().setText(this.language.getString("IdentitiesBrowser.button.import"));
        this.getBexport().setText(this.language.getString("IdentitiesBrowser.button.export"));
        this.Lfilter.setText(this.language.getString("IdentitiesBrowser.label.filter") + ":");
        this.Llookup.setText(this.language.getString("IdentitiesBrowser.label.lookup") + ":");
    }

    private void updateTitle() {
        int idCount = this.tableModel.getRowCount();
        this.setTitle(this.language.formatMessage("IdentitiesBrowser.title", Integer.toString(idCount)));
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
            this.jContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getIdentitiesTable());
            this.jScrollPane.setWheelScrollingEnabled(true);
        }
        return this.jScrollPane;
    }

    private long getMinCleanupTime() {
        int minDaysOld = Core.frostSettings.getIntValue("messageExpireDays") + 1;
        if (minDaysOld < Core.frostSettings.getIntValue("maxMessageDisplay")) {
            minDaysOld = Core.frostSettings.getIntValue("maxMessageDisplay") + 1;
        }
        if (minDaysOld < Core.frostSettings.getIntValue("maxMessageDownload")) {
            minDaysOld = Core.frostSettings.getIntValue("maxMessageDownload") + 1;
        }
        for (Board board : MainFrame.getInstance().getTofTreeModel().getAllBoards()) {
            if (!board.isConfigured()) continue;
            minDaysOld = Math.max(board.getMaxMessageDisplay(), minDaysOld);
            minDaysOld = Math.max(board.getMaxMessageDownload(), minDaysOld);
        }
        long time = System.currentTimeMillis() - (long)minDaysOld * 24L * 60L * 60L * 1000L;
        return time;
    }

    private SortedTable getIdentitiesTable() {
        if (this.identitiesTable == null) {
            this.tableModel = new InnerTableModel();
            this.identitiesTable = new SortedTable(this.tableModel);
            int[] widths = new int[]{130, 30, 30, 70, 20, 20};
            for (int i = 0; i < widths.length; ++i) {
                this.identitiesTable.getColumnModel().getColumn(i).setPreferredWidth(widths[i]);
            }
            ShowColoredLinesRenderer showColoredLinesRenderer = new ShowColoredLinesRenderer();
            this.identitiesTable.getColumnModel().getColumn(0).setCellRenderer(showColoredLinesRenderer);
            this.identitiesTable.getColumnModel().getColumn(1).setCellRenderer(new StringCellRenderer());
            this.identitiesTable.getColumnModel().getColumn(2).setCellRenderer(showColoredLinesRenderer);
            this.identitiesTable.getColumnModel().getColumn(3).setCellRenderer(showColoredLinesRenderer);
            this.identitiesTable.getColumnModel().getColumn(4).setCellRenderer(showColoredLinesRenderer);
            this.identitiesTable.getColumnModel().getColumn(5).setCellRenderer(showColoredLinesRenderer);
            this.jScrollPane.addMouseListener(this.listener);
            this.identitiesTable.addMouseListener(this.listener);
            this.identitiesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    int[] selRows = IdentitiesBrowser.this.identitiesTable.getSelectedRows();
                    if (selRows.length == 0) {
                        IdentitiesBrowser.this.getBdelete().setEnabled(false);
                        IdentitiesBrowser.this.getBdelete().setToolTipText(null);
                        IdentitiesBrowser.this.updateStateButtons(false, false, false, false);
                        return;
                    }
                    if (selRows.length == 1) {
                        Identity id = ((InnerTableMember)IdentitiesBrowser.this.tableModel.getRow(selRows[0])).getIdentity();
                        if (id.isBAD()) {
                            IdentitiesBrowser.this.updateStateButtons(false, true, true, true);
                        } else if (id.isCHECK()) {
                            IdentitiesBrowser.this.updateStateButtons(true, false, true, true);
                        } else if (id.isGOOD()) {
                            IdentitiesBrowser.this.updateStateButtons(true, true, false, true);
                        } else if (id.isOBSERVE()) {
                            IdentitiesBrowser.this.updateStateButtons(true, true, true, false);
                        }
                    } else {
                        IdentitiesBrowser.this.updateStateButtons(true, true, true, true);
                    }
                    boolean enableDelete = true;
                    for (int element : selRows) {
                        if (((InnerTableMember)IdentitiesBrowser.this.tableModel.getRow(element)).isDeleteable()) continue;
                        enableDelete = false;
                        break;
                    }
                    if (enableDelete) {
                        if (selRows.length > 1) {
                            IdentitiesBrowser.this.getBdelete().setToolTipText(IdentitiesBrowser.this.language.getString("IdentitiesBrowser.button.delete.tooltip.multiple"));
                        } else {
                            IdentitiesBrowser.this.getBdelete().setToolTipText(IdentitiesBrowser.this.language.getString("IdentitiesBrowser.button.delete.tooltip.single"));
                        }
                    } else {
                        IdentitiesBrowser.this.getBdelete().setToolTipText(null);
                    }
                    IdentitiesBrowser.this.getBdelete().setEnabled(enableDelete);
                }
            });
        }
        return this.identitiesTable;
    }

    private void updateStateButtons(boolean badState, boolean checkState, boolean goodState, boolean observeState) {
        this.getBmarkBAD().setEnabled(badState);
        this.getBmarkCHECK().setEnabled(checkState);
        this.getBmarkGOOD().setEnabled(goodState);
        this.getBmarkOBSERVE().setEnabled(observeState);
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.Lfilter = new JLabel();
            this.Lfilter.setText("IdentitiesBrowser.label.filter");
            this.Llookup = new JLabel();
            this.Llookup.setText("IdentitiesBrowser.label.lookup");
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new BoxLayout(this.getButtonPanel(), 0));
            this.buttonPanel.add(Box.createRigidArea(new Dimension(5, 3)));
            this.buttonPanel.add((Component)this.Llookup, null);
            this.buttonPanel.add(Box.createRigidArea(new Dimension(5, 3)));
            this.buttonPanel.add((Component)this.getTFlookup(), null);
            this.buttonPanel.add(Box.createRigidArea(new Dimension(5, 3)));
            this.buttonPanel.add((Component)this.Lfilter, null);
            this.buttonPanel.add(Box.createRigidArea(new Dimension(5, 3)));
            this.buttonPanel.add((Component)this.getTFfilter(), null);
            this.buttonPanel.add(Box.createHorizontalGlue());
            this.buttonPanel.add((Component)this.getBclose(), null);
            this.buttonPanel.add(Box.createRigidArea(new Dimension(5, 3)));
        }
        return this.buttonPanel;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 1;
            gridBagConstraints21.gridheight = 1;
            gridBagConstraints21.gridwidth = 4;
            gridBagConstraints21.anchor = 11;
            gridBagConstraints21.weighty = 1.0;
            gridBagConstraints21.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints21.gridy = 4;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.gridwidth = 4;
            gridBagConstraints11.insets = new Insets(15, 5, 5, 5);
            gridBagConstraints11.anchor = 11;
            gridBagConstraints11.gridy = 3;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.gridwidth = 4;
            gridBagConstraints6.insets = new Insets(15, 5, 0, 5);
            gridBagConstraints6.weighty = 0.0;
            gridBagConstraints6.anchor = 11;
            gridBagConstraints6.gridy = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridwidth = 4;
            gridBagConstraints5.weighty = 0.0;
            gridBagConstraints5.anchor = 11;
            gridBagConstraints5.insets = new Insets(15, 5, 5, 5);
            gridBagConstraints5.gridy = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 4;
            gridBagConstraints4.insets = new Insets(5, 0, 0, 5);
            gridBagConstraints4.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 3;
            gridBagConstraints3.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridheight = 5;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.add((Component)this.getJScrollPane(), gridBagConstraints);
            this.mainPanel.add((Component)this.getBmarkGOOD(), gridBagConstraints1);
            this.mainPanel.add((Component)this.getBmarkOBSERVE(), gridBagConstraints2);
            this.mainPanel.add((Component)this.getBmarkCHECK(), gridBagConstraints3);
            this.mainPanel.add((Component)this.getBmarkBAD(), gridBagConstraints4);
            this.mainPanel.add((Component)this.getBdelete(), gridBagConstraints5);
            this.mainPanel.add((Component)this.getBcleanup(), gridBagConstraints6);
            this.mainPanel.add((Component)this.getBimport(), gridBagConstraints11);
            this.mainPanel.add((Component)this.getBexport(), gridBagConstraints21);
        }
        return this.mainPanel;
    }

    private JButton getBclose() {
        if (this.Bclose == null) {
            this.Bclose = new JButton();
            this.Bclose.setText("IdentitiesBrowser.button.close");
            this.Bclose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    IdentitiesBrowser.this.setVisible(false);
                    MainFrame.getInstance().getMessagePanel().updateTableAfterChangeOfIdentityState();
                }
            });
        }
        return this.Bclose;
    }

    private JButton getBmarkGOOD() {
        if (this.BmarkGOOD == null) {
            this.BmarkGOOD = new JButton();
            this.BmarkGOOD.setText("G");
            this.BmarkGOOD.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int[] selRows;
                    for (int element : selRows = IdentitiesBrowser.this.getIdentitiesTable().getSelectedRows()) {
                        InnerTableMember itm = (InnerTableMember)IdentitiesBrowser.this.tableModel.getRow(element);
                        Identity id = itm.getIdentity();
                        if (!id.isGOOD()) {
                            id.setGOOD();
                        }
                        IdentitiesBrowser.this.tableModel.updateRow(itm);
                    }
                }
            });
        }
        return this.BmarkGOOD;
    }

    private JButton getBmarkOBSERVE() {
        if (this.BmarkOBSERVE == null) {
            this.BmarkOBSERVE = new JButton();
            this.BmarkOBSERVE.setText("O");
            this.BmarkOBSERVE.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int[] selRows;
                    for (int element : selRows = IdentitiesBrowser.this.getIdentitiesTable().getSelectedRows()) {
                        InnerTableMember itm = (InnerTableMember)IdentitiesBrowser.this.tableModel.getRow(element);
                        Identity id = itm.getIdentity();
                        if (!id.isOBSERVE()) {
                            id.setOBSERVE();
                        }
                        IdentitiesBrowser.this.tableModel.updateRow(itm);
                    }
                }
            });
        }
        return this.BmarkOBSERVE;
    }

    private JButton getBmarkCHECK() {
        if (this.BmarkCHECK == null) {
            this.BmarkCHECK = new JButton();
            this.BmarkCHECK.setText("C");
            this.BmarkCHECK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int[] selRows;
                    for (int element : selRows = IdentitiesBrowser.this.getIdentitiesTable().getSelectedRows()) {
                        InnerTableMember itm = (InnerTableMember)IdentitiesBrowser.this.tableModel.getRow(element);
                        Identity id = itm.getIdentity();
                        if (!id.isCHECK()) {
                            id.setCHECK();
                        }
                        IdentitiesBrowser.this.tableModel.updateRow(itm);
                    }
                }
            });
        }
        return this.BmarkCHECK;
    }

    private JButton getBmarkBAD() {
        if (this.BmarkBAD == null) {
            this.BmarkBAD = new JButton();
            this.BmarkBAD.setText("B");
            this.BmarkBAD.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int[] selRows;
                    for (int element : selRows = IdentitiesBrowser.this.getIdentitiesTable().getSelectedRows()) {
                        InnerTableMember itm = (InnerTableMember)IdentitiesBrowser.this.tableModel.getRow(element);
                        Identity id = itm.getIdentity();
                        if (!id.isBAD()) {
                            id.setBAD();
                        }
                        IdentitiesBrowser.this.tableModel.updateRow(itm);
                    }
                }
            });
        }
        return this.BmarkBAD;
    }

    private JButton getBdelete() {
        if (this.Bdelete == null) {
            this.Bdelete = new JButton();
            this.Bdelete.setText("IdentitiesBrowser.button.delete");
            this.Bdelete.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int[] selRows = IdentitiesBrowser.this.getIdentitiesTable().getSelectedRows();
                    int answer = JOptionPane.showConfirmDialog(IdentitiesBrowser.this, IdentitiesBrowser.this.language.formatMessage("IdentitiesBrowser.deleteDialog.body", Integer.toString(selRows.length)), IdentitiesBrowser.this.language.getString("IdentitiesBrowser.deleteDialog.title"), 0, 3);
                    if (answer == 1) {
                        return;
                    }
                    Arrays.sort(selRows);
                    if (!IdentitiesStorage.inst().beginExclusiveThreadTransaction()) {
                        return;
                    }
                    for (int x = selRows.length - 1; x >= 0; --x) {
                        InnerTableMember m = (InnerTableMember)IdentitiesBrowser.this.tableModel.getRow(selRows[x]);
                        Identity id = m.getIdentity();
                        Core.getIdentities().deleteIdentity(id);
                        IdentitiesBrowser.this.tableModel.removeRow(selRows[x]);
                    }
                    IdentitiesStorage.inst().endThreadTransaction();
                    IdentitiesBrowser.this.updateTitle();
                }
            });
        }
        return this.Bdelete;
    }

    private void startProgressMonitor(int max) {
        String title = this.language.getString("IdentitiesBrowser.progressDialog.title");
        String msg = this.language.getString("IdentitiesBrowser.progressDialog.body");
        UIManager.put("ProgressMonitor.progressText", title);
        this.progressMonitor = new ProgressMonitor(this.parent, msg, null, 0, max);
    }

    public void startDialog() {
        this.startProgressMonitor(3);
        FrostSwingWorker worker = new FrostSwingWorker(this.parent){

            protected void doNonUILogic() throws RuntimeException {
                IdentitiesBrowser.this.progressMonitor.setProgress(1);
                if (IdentitiesBrowser.this.progressMonitor.isCanceled()) {
                    return;
                }
                if (!IdentitiesStorage.inst().beginExclusiveThreadTransaction()) {
                    return;
                }
                Hashtable<String, IdentitiesStorage.IdentityMsgAndFileCount> idDatas = IdentitiesStorage.inst().retrieveMsgAndFileCountPerIdentity();
                IdentitiesStorage.inst().endThreadTransaction();
                IdentitiesBrowser.this.progressMonitor.setProgress(2);
                if (IdentitiesBrowser.this.progressMonitor.isCanceled()) {
                    return;
                }
                IdentitiesBrowser.this.allTableMembers = new LinkedList();
                List<Identity> allIdentities = Core.getIdentities().getIdentities();
                allIdentities.addAll(Core.getIdentities().getLocalIdentities());
                for (Identity identity : allIdentities) {
                    InnerTableMember memb = new InnerTableMember(identity, idDatas);
                    IdentitiesBrowser.this.tableModel.addRow(memb);
                    IdentitiesBrowser.this.allTableMembers.add(memb);
                }
                IdentitiesBrowser.this.progressMonitor.setProgress(3);
                idDatas.clear();
            }

            protected void doUIUpdateLogic() throws RuntimeException {
                IdentitiesBrowser.this.updateTitle();
                IdentitiesBrowser.this.showDialog();
            }
        };
        worker.start();
    }

    private void showDialog() {
        if (this.progressMonitor.isCanceled()) {
            this.progressMonitor.close();
        } else {
            this.progressMonitor.close();
            this.getIdentitiesTable().getSelectionModel().setSelectionInterval(0, 0);
            this.setVisible(true);
        }
    }

    private JButton getBcleanup() {
        if (this.Bcleanup == null) {
            this.Bcleanup = new JButton();
            this.Bcleanup.setText("IdentitiesBrowser.button.cleanup");
            this.Bcleanup.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LinkedList<Integer> li = new LinkedList<Integer>();
                    for (int i = IdentitiesBrowser.this.tableModel.getRowCount() - 1; i >= 0; --i) {
                        InnerTableMember m = (InnerTableMember)IdentitiesBrowser.this.tableModel.getRow(i);
                        if (!m.isCleanupable()) continue;
                        li.add(new Integer(i));
                    }
                    if (li.size() == 0) {
                        JOptionPane.showMessageDialog(IdentitiesBrowser.this, IdentitiesBrowser.this.language.getString("IdentitiesBrowser.cleanupDialog.nothingToDelete.body"), IdentitiesBrowser.this.language.getString("IdentitiesBrowser.cleanupDialog.nothingToDelete.title"), 1);
                        return;
                    }
                    int answer = JOptionPane.showConfirmDialog(IdentitiesBrowser.this, IdentitiesBrowser.this.language.formatMessage("IdentitiesBrowser.cleanupDialog.deleteIdentities.body", Integer.toString(li.size())), IdentitiesBrowser.this.language.getString("IdentitiesBrowser.cleanupDialog.deleteIdentities.title"), 0, 3);
                    if (answer == 1) {
                        return;
                    }
                    if (!IdentitiesStorage.inst().beginExclusiveThreadTransaction()) {
                        return;
                    }
                    for (Integer element : li) {
                        InnerTableMember m = (InnerTableMember)IdentitiesBrowser.this.tableModel.getRow(element);
                        Identity id = m.getIdentity();
                        Core.getIdentities().deleteIdentity(id);
                        IdentitiesBrowser.this.tableModel.removeRow(element);
                    }
                    IdentitiesStorage.inst().endThreadTransaction();
                    IdentitiesBrowser.this.updateTitle();
                }
            });
        }
        return this.Bcleanup;
    }

    private JTextField getTFlookup() {
        if (this.TFlookup == null) {
            this.TFlookup = new JTextField(10);
            this.TFlookup.setMaximumSize(this.TFlookup.getPreferredSize());
            this.TFlookup.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    IdentitiesBrowser.this.lookupContentChanged();
                }

                public void insertUpdate(DocumentEvent e) {
                    IdentitiesBrowser.this.lookupContentChanged();
                }

                public void removeUpdate(DocumentEvent e) {
                    IdentitiesBrowser.this.lookupContentChanged();
                }
            });
        }
        return this.TFlookup;
    }

    private JTextField getTFfilter() {
        if (this.TFfilter == null) {
            this.TFfilter = new JTextField(10);
            this.TFfilter.setMaximumSize(this.TFfilter.getPreferredSize());
            this.TFfilter.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    IdentitiesBrowser.this.filterContentChanged();
                }

                public void insertUpdate(DocumentEvent e) {
                    IdentitiesBrowser.this.filterContentChanged();
                }

                public void removeUpdate(DocumentEvent e) {
                    IdentitiesBrowser.this.filterContentChanged();
                }
            });
        }
        return this.TFfilter;
    }

    private void lookupContentChanged() {
        try {
            String txt = this.TFlookup.getDocument().getText(0, this.TFlookup.getDocument().getLength());
            for (int row = 0; row < this.tableModel.getRowCount(); ++row) {
                InnerTableMember memb = (InnerTableMember)this.tableModel.getRow(row);
                if (!memb.getIdentity().getUniqueName().toLowerCase().startsWith(txt.toLowerCase())) continue;
                this.getIdentitiesTable().getSelectionModel().setSelectionInterval(row, row);
                int visibleRows = (int)(this.getIdentitiesTable().getVisibleRect().getHeight() / this.getIdentitiesTable().getCellRect(row, 0, true).getHeight());
                int scrollToRow = row + visibleRows > this.tableModel.getRowCount() ? this.tableModel.getRowCount() - 1 : row + visibleRows - 1;
                if (scrollToRow > row) {
                    --scrollToRow;
                }
                this.getIdentitiesTable().scrollRectToVisible(this.getIdentitiesTable().getCellRect(row, 0, true));
                this.getIdentitiesTable().scrollRectToVisible(this.getIdentitiesTable().getCellRect(scrollToRow, 0, true));
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void filterContentChanged() {
        try {
            this.TFlookup.setText("");
            String txt = this.TFfilter.getDocument().getText(0, this.TFfilter.getDocument().getLength()).trim();
            txt = txt.toLowerCase();
            this.tableModel.clearDataModel();
            Iterator<InnerTableMember> i$ = this.allTableMembers.iterator();
            while (i$.hasNext()) {
                String bn;
                InnerTableMember element;
                InnerTableMember tm = element = i$.next();
                if (txt.length() > 0 && (bn = tm.getIdentity().getUniqueName().toLowerCase()).indexOf(txt) < 0) continue;
                this.tableModel.addRow(tm);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private File chooseXmlImportFile() {
        FileFilter myFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".xml");
            }

            public String getDescription() {
                return "identities_export.xml";
            }
        };
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(myFilter);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    private File chooseXmlExportFile() {
        FileFilter myFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".xml");
            }

            public String getDescription() {
                return "identities_export.xml";
            }
        };
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(myFilter);
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            int answer;
            File f = chooser.getSelectedFile();
            if (!f.getName().endsWith(".xml")) {
                f = new File(f.getPath() + ".xml");
            }
            if (f.exists() && (answer = JOptionPane.showConfirmDialog(this, this.language.formatMessage("IdentitiesBrowser.exportIdentitiesConfirmXmlFileOverwrite.body", f.getName()), this.language.getString("IdentitiesBrowser.exportIdentitiesConfirmXmlFileOverwrite.title"), 0, 2)) == 1) {
                return null;
            }
            return f;
        }
        return null;
    }

    private JButton getBimport() {
        if (this.Bimport == null) {
            this.Bimport = new JButton();
            this.Bimport.setText("IdentitiesBrowser.button.import");
            this.Bimport.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    File xmlFile = IdentitiesBrowser.this.chooseXmlImportFile();
                    if (xmlFile == null) {
                        return;
                    }
                    List<Identity> importedIdentities = IdentitiesXmlDAO.loadIdentities(xmlFile);
                    if (importedIdentities.size() == 0) {
                        JOptionPane.showMessageDialog(IdentitiesBrowser.this, IdentitiesBrowser.this.language.getString("IdentitiesBrowser.noIdentityToImport.body"), IdentitiesBrowser.this.language.getString("IdentitiesBrowser.noIdentityToImport.title"), 1);
                        return;
                    }
                    int importedCount = Core.getIdentities().importIdentities(importedIdentities);
                    int skippedCount = importedIdentities.size() - importedCount;
                    JOptionPane.showMessageDialog(IdentitiesBrowser.this, IdentitiesBrowser.this.language.formatMessage("IdentitiesBrowser.identitiesImported.body", Integer.toString(importedCount), Integer.toString(skippedCount)), IdentitiesBrowser.this.language.getString("IdentitiesBrowser.identitiesImported.title"), 1);
                    IdentitiesBrowser.this.updateTitle();
                }
            });
        }
        return this.Bimport;
    }

    private JButton getBexport() {
        if (this.Bexport == null) {
            this.Bexport = new JButton();
            this.Bexport.setText("IdentitiesBrowser.button.export");
            this.Bexport.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    List<Identity> allIdentities = Core.getIdentities().getIdentities();
                    IdentitiesBrowser.this.exportIdentities(allIdentities);
                }
            });
        }
        return this.Bexport;
    }

    private void exportIdentities(List<Identity> ids) {
        File xmlFile = this.chooseXmlExportFile();
        if (xmlFile == null) {
            return;
        }
        int count = IdentitiesXmlDAO.saveIdentities(xmlFile, ids);
        if (count > 0) {
            JOptionPane.showMessageDialog(this, this.language.formatMessage("IdentitiesBrowser.identitiesExported.body", Integer.toString(count)), this.language.getString("IdentitiesBrowser.identitiesExported.title"), 1);
        } else if (count < 0) {
            JOptionPane.showMessageDialog(this, this.language.getString("IdentitiesBrowser.identitiesExportFailed.body"), this.language.getString("IdentitiesBrowser.identitiesExportFailed.title"), 0);
        } else {
            JOptionPane.showMessageDialog(this, this.language.getString("IdentitiesBrowser.noIdentityToExport.body"), this.language.getString("IdentitiesBrowser.noIdentityToExport.title"), 1);
        }
    }

    private PopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new PopupMenu();
        }
        return this.popupMenu;
    }

    private void showUploadTablePopupMenu(MouseEvent e) {
        Point p = e.getPoint();
        int y = this.identitiesTable.rowAtPoint(p);
        if (y < 0) {
            return;
        }
        if (!this.identitiesTable.getSelectionModel().isSelectedIndex(y)) {
            this.identitiesTable.getSelectionModel().setSelectionInterval(y, y);
        }
        this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
    }

    private class Listener
    extends MouseAdapter
    implements MouseListener {
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger() && (e.getSource() == IdentitiesBrowser.this.identitiesTable || e.getSource() == IdentitiesBrowser.this.jScrollPane)) {
                IdentitiesBrowser.this.showUploadTablePopupMenu(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getClickCount() == 1 && e.isPopupTrigger() && (e.getSource() == IdentitiesBrowser.this.identitiesTable || e.getSource() == IdentitiesBrowser.this.jScrollPane)) {
                IdentitiesBrowser.this.showUploadTablePopupMenu(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PopupMenu
    extends JSkinnablePopupMenu
    implements ActionListener,
    LanguageListener {
        private final JMenu copyToClipboardMenu = new JMenu();
        private final JMenuItem copyUniqueName = new JMenuItem();
        private final JMenuItem copyUniqueNameAndPublicKey = new JMenuItem();
        private final JMenuItem exportSelectedIdentities = new JMenuItem();

        public PopupMenu() {
            this.initialize();
        }

        private void initialize() {
            this.refreshLanguage();
            this.copyToClipboardMenu.add(this.copyUniqueName);
            this.copyToClipboardMenu.add(this.copyUniqueNameAndPublicKey);
            this.copyUniqueName.addActionListener(this);
            this.copyUniqueNameAndPublicKey.addActionListener(this);
            this.exportSelectedIdentities.addActionListener(this);
        }

        private void refreshLanguage() {
            this.copyUniqueName.setText(IdentitiesBrowser.this.language.getString("IdentitiesBrowser.popupmenu.copyUniqueName"));
            this.copyUniqueNameAndPublicKey.setText(IdentitiesBrowser.this.language.getString("IdentitiesBrowser.popupmenu.copyUniqueNameAndPublicKey"));
            this.copyToClipboardMenu.setText(IdentitiesBrowser.this.language.getString("Common.copyToClipBoard") + "...");
            this.exportSelectedIdentities.setText(IdentitiesBrowser.this.language.getString("IdentitiesBrowser.popupmenu.exportSelectedIdentities"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selRows = IdentitiesBrowser.this.getIdentitiesTable().getSelectedRows();
            ArrayList<Identity> selectedIds = new ArrayList<Identity>();
            for (int x = selRows.length - 1; x >= 0; --x) {
                InnerTableMember m = (InnerTableMember)IdentitiesBrowser.this.tableModel.getRow(selRows[x]);
                Identity id = m.getIdentity();
                selectedIds.add(id);
            }
            if (e.getSource() == this.copyUniqueName) {
                this.copyUniqueName(selectedIds);
            } else if (e.getSource() == this.copyUniqueNameAndPublicKey) {
                this.copyUniqueNameAndPublicKey(selectedIds);
            } else if (e.getSource() == this.exportSelectedIdentities) {
                IdentitiesBrowser.this.exportIdentities(selectedIds);
            }
        }

        private void copyUniqueName(List<Identity> selectedIds) {
            StringBuilder sb = new StringBuilder();
            for (Identity id : selectedIds) {
                sb.append(id.getUniqueName());
                sb.append("\n");
            }
            sb.deleteCharAt(sb.length() - 1);
            CopyToClipboard.copyText(sb.toString());
        }

        private void copyUniqueNameAndPublicKey(List<Identity> selectedIds) {
            StringBuilder sb = new StringBuilder();
            for (Identity id : selectedIds) {
                sb.append(id.getUniqueName());
                sb.append("\n");
                sb.append(id.getPublicKey());
                sb.append("\n\n");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            CopyToClipboard.copyText(sb.toString());
        }

        @Override
        public void languageChanged(LanguageEvent event) {
            this.refreshLanguage();
        }

        @Override
        public void show(Component invoker, int x, int y) {
            this.removeAll();
            int selectedRowCount = IdentitiesBrowser.this.identitiesTable.getSelectedRowCount();
            if (selectedRowCount == 0) {
                return;
            }
            this.add(this.copyToClipboardMenu);
            this.addSeparator();
            this.add(this.exportSelectedIdentities);
            super.show(invoker, x, y);
        }
    }

    private class ShowColoredLinesRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                Color newBackground = TableBackgroundColors.getBackgroundColor(table, row, IdentitiesBrowser.this.showColoredLines);
                this.setBackground(newBackground);
            } else {
                this.setBackground(table.getSelectionBackground());
            }
            return this;
        }
    }

    private class StringCellRenderer
    extends ShowColoredLinesRenderer {
        private Font boldFont = null;
        private Font normalFont = null;
        private final Color col_good = new Color(0, 128, 0);
        private final Color col_check = new Color(255, 204, 0);
        private final Color col_observe = new Color(0, 208, 0);
        private final Color col_bad = new Color(255, 0, 0);

        public StringCellRenderer() {
            Font baseFont = IdentitiesBrowser.this.getIdentitiesTable().getFont();
            this.normalFont = baseFont.deriveFont(0);
            this.boldFont = baseFont.deriveFont(1);
            this.setVerticalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setAlignmentY(0.5f);
            InnerTableMember tableMember = (InnerTableMember)IdentitiesBrowser.this.tableModel.getRow(row);
            TableColumn tableColumn = IdentitiesBrowser.this.getIdentitiesTable().getColumnModel().getColumn(column);
            column = tableColumn.getModelIndex();
            this.setFont(this.normalFont);
            if (!isSelected) {
                this.setForeground(Color.BLACK);
            }
            this.setToolTipText(null);
            if (column == 0) {
                this.setToolTipText(tableMember.getIdentity().getUniqueName());
            } else if (column == 1) {
                Identity id = tableMember.getIdentity();
                if (Core.getIdentities().isMySelf(id.getUniqueName())) {
                    if (!Core.frostSettings.getBoolValue("showOwnMessagesAsMeDisabled")) {
                        this.setText("ME");
                    }
                    this.setFont(this.boldFont);
                    this.setForeground(this.col_good);
                } else if (id.isGOOD()) {
                    this.setFont(this.boldFont);
                    this.setForeground(this.col_good);
                } else if (id.isCHECK()) {
                    this.setFont(this.boldFont);
                    this.setForeground(this.col_check);
                } else if (id.isOBSERVE()) {
                    this.setFont(this.boldFont);
                    this.setForeground(this.col_observe);
                } else if (id.isBAD()) {
                    this.setFont(this.boldFont);
                    this.setForeground(this.col_bad);
                }
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InnerTableModel
    extends SortedTableModel {
        protected final String[] columnNames = new String[6];
        protected final Class[] columnClasses = new Class[]{String.class, String.class, Integer.class, String.class, Integer.class, Integer.class};

        public InnerTableModel() {
            this.setLanguage();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public String getColumnName(int column) {
            if (column >= 0 && column < this.columnNames.length) {
                return this.columnNames[column];
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (column >= 0 && column < this.columnClasses.length) {
                return this.columnClasses[column];
            }
            return null;
        }

        private void setLanguage() {
            this.columnNames[0] = IdentitiesBrowser.this.language.getString("IdentitiesBrowser.identitiesTable.name");
            this.columnNames[1] = IdentitiesBrowser.this.language.getString("IdentitiesBrowser.identitiesTable.state");
            this.columnNames[2] = IdentitiesBrowser.this.language.getString("IdentitiesBrowser.identitiesTable.receivedMessages");
            this.columnNames[3] = IdentitiesBrowser.this.language.getString("IdentitiesBrowser.identitiesTable.lastSeen");
            this.columnNames[4] = IdentitiesBrowser.this.language.getString("IdentitiesBrowser.identitiesTable.messages");
            this.columnNames[5] = IdentitiesBrowser.this.language.getString("IdentitiesBrowser.identitiesTable.files");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InnerTableMember
    implements TableMember {
        Identity identity;
        Integer msgCount;
        Integer fileCount;
        String lastSeenStr;
        String htmlName;
        Integer receivedMsgs;

        public InnerTableMember(Identity i, Hashtable<String, IdentitiesStorage.IdentityMsgAndFileCount> idDatas) {
            this.identity = i;
            IdentitiesStorage.IdentityMsgAndFileCount data = idDatas.get(this.identity.getUniqueName());
            if (data != null) {
                this.msgCount = new Integer(data.getMessageCount());
                this.fileCount = new Integer(data.getFileCount());
            } else {
                this.msgCount = new Integer(-1);
                this.fileCount = new Integer(-1);
            }
            this.lastSeenStr = this.buildLastSeenString(this.identity.getLastSeenTimestamp());
            this.receivedMsgs = new Integer(this.identity.getReceivedMessageCount());
            this.htmlName = this.buildHtmlName(i.getUniqueName());
        }

        public Identity getIdentity() {
            return this.identity;
        }

        public boolean isDeleteable() {
            return this.msgCount == 0 && this.fileCount == 0;
        }

        public boolean isCleanupable() {
            if (!this.isDeleteable()) {
                return false;
            }
            if (this.identity.isGOOD() || this.identity.isOBSERVE()) {
                return false;
            }
            return !this.identity.isBAD() || this.identity.getLastSeenTimestamp() <= IdentitiesBrowser.this.minCleanupTime;
        }

        private String buildHtmlName(String n) {
            return n;
        }

        private String buildLastSeenString(long lastSeen) {
            if (lastSeen < 0L) {
                return "";
            }
            String lsStr = DateFun.FORMAT_DATE_EXT.print(lastSeen);
            long days = new DateMidnight(DateTimeZone.UTC).getMillis() - new DateMidnight(lastSeen, DateTimeZone.UTC).getMillis();
            lsStr = lsStr + "  (" + (days /= 86400000L) + ")";
            return lsStr;
        }

        @Override
        public Object getValueAt(int column) {
            switch (column) {
                case 0: {
                    return this.htmlName;
                }
                case 1: {
                    return this.getIdentity().getStateString();
                }
                case 2: {
                    return this.receivedMsgs;
                }
                case 3: {
                    return this.lastSeenStr;
                }
                case 4: {
                    return this.msgCount;
                }
                case 5: {
                    return this.fileCount;
                }
            }
            return "*ERR*";
        }

        @Override
        public int compareTo(TableMember anOther, int tableColumnIndex) {
            if (tableColumnIndex == 0 || tableColumnIndex == 1) {
                String s1 = (String)this.getValueAt(tableColumnIndex);
                String s2 = (String)anOther.getValueAt(tableColumnIndex);
                return s1.compareToIgnoreCase(s2);
            }
            if (tableColumnIndex == 2) {
                int l1 = this.getIdentity().getReceivedMessageCount();
                int l2 = ((InnerTableMember)anOther).getIdentity().getReceivedMessageCount();
                return Mixed.compareLong(l1, l2);
            }
            if (tableColumnIndex == 3) {
                long l1 = this.getIdentity().getLastSeenTimestamp();
                long l2 = ((InnerTableMember)anOther).getIdentity().getLastSeenTimestamp();
                return Mixed.compareLong(l1, l2);
            }
            if (tableColumnIndex == 4) {
                Integer i2;
                Integer i1 = (Integer)this.getValueAt(tableColumnIndex);
                int res = i1.compareTo(i2 = (Integer)anOther.getValueAt(tableColumnIndex));
                if (res == 0) {
                    i1 = (Integer)this.getValueAt(5);
                    i2 = (Integer)anOther.getValueAt(5);
                    return i1.compareTo(i2);
                }
                return res;
            }
            if (tableColumnIndex == 5) {
                Integer i2;
                Integer i1 = (Integer)this.getValueAt(tableColumnIndex);
                int res = i1.compareTo(i2 = (Integer)anOther.getValueAt(tableColumnIndex));
                if (res == 0) {
                    i1 = (Integer)this.getValueAt(4);
                    i2 = (Integer)anOther.getValueAt(4);
                    return i1.compareTo(i2);
                }
                return res;
            }
            return 0;
        }
    }
}

