/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.Core;
import frost.MainFrame;
import frost.gui.ManageLocalIdentitiesSignatureDialog;
import frost.identities.Identity;
import frost.identities.LocalIdentity;
import frost.storage.LocalIdentitiesXmlDAO;
import frost.util.XMLTools;
import frost.util.gui.translation.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ManageLocalIdentitiesDialog
extends JDialog {
    private Language language = Language.getInstance();
    private JPanel jContentPane = null;
    private JPanel buttonPanel = null;
    private JPanel mainPanel = null;
    private JButton Bclose = null;
    private JLabel jLabel = null;
    private JScrollPane SPlist = null;
    private JPanel jPanel = null;
    private JList identitiesList = null;
    private JButton BaddNewIdentity = null;
    private JButton BdeleteIdentity = null;
    private JButton BimportIdentityXml = null;
    private JLabel Ldummy = null;
    private JButton BimportXml = null;
    private JButton BexportXml = null;
    private JButton BsetSignature = null;
    private boolean identitiesImported = false;

    public ManageLocalIdentitiesDialog() {
        super(MainFrame.getInstance());
        this.initialize();
        this.setModal(true);
        this.setLocationRelativeTo(MainFrame.getInstance());
    }

    private void initialize() {
        this.setSize(488, 311);
        this.setTitle(this.language.getString("ManageLocalIdentities.title"));
        this.setContentPane(this.getJContentPane());
        this.jLabel.setText(this.language.getString("ManageLocalidentities.listLabel") + ":");
        this.BimportIdentityXml.setText(this.language.getString("ManageLocalIdentities.button.importIdentity"));
        this.BdeleteIdentity.setText(this.language.getString("ManageLocalIdentities.button.deleteIdentity"));
        this.BaddNewIdentity.setText(this.language.getString("ManageLocalIdentities.button.createNewIdentity"));
        this.BimportXml.setText(this.language.getString("ManageLocalIdentities.button.importXml"));
        this.BexportXml.setText(this.language.getString("ManageLocalIdentities.button.exportXml"));
        this.Bclose.setText(this.language.getString("ManageLocalIdentities.button.close"));
        this.BsetSignature.setText(this.language.getString("ManageLocalIdentities.button.editSignature"));
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
            this.jContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.add((Component)this.getBclose(), null);
        }
        return this.buttonPanel;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridheight = 1;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.fill = 3;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.insets = new Insets(3, 0, 0, 0);
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.weightx = 0.3;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.anchor = 18;
            gridBagConstraints1.insets = new Insets(3, 5, 3, 5);
            gridBagConstraints1.gridx = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("Local Identities:");
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.add((Component)this.jLabel, gridBagConstraints);
            this.mainPanel.add((Component)this.getSPlist(), gridBagConstraints1);
            this.mainPanel.add((Component)this.getJPanel(), gridBagConstraints2);
        }
        return this.mainPanel;
    }

    private JButton getBclose() {
        if (this.Bclose == null) {
            this.Bclose = new JButton();
            this.Bclose.setText("ManageLocalIdentities.button.close");
            this.Bclose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ManageLocalIdentitiesDialog.this.setVisible(false);
                }
            });
        }
        return this.Bclose;
    }

    private JScrollPane getSPlist() {
        if (this.SPlist == null) {
            this.SPlist = new JScrollPane();
            this.SPlist.setViewportView(this.getIdentitiesList());
        }
        return this.SPlist;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.insets = new Insets(15, 3, 0, 5);
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.gridy = 2;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.insets = new Insets(5, 3, 0, 5);
            gridBagConstraints8.gridy = 5;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.insets = new Insets(15, 3, 0, 5);
            gridBagConstraints7.gridy = 4;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.fill = 3;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.gridy = 6;
            this.Ldummy = new JLabel();
            this.Ldummy.setText("");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.insets = new Insets(15, 3, 0, 5);
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.gridy = 3;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.insets = new Insets(5, 3, 0, 5);
            gridBagConstraints4.anchor = 18;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.insets = new Insets(0, 3, 0, 5);
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getBaddNewIdentity(), gridBagConstraints3);
            this.jPanel.add((Component)this.getBdeleteIdentity(), gridBagConstraints4);
            this.jPanel.add((Component)this.getBimportIdentityXml(), gridBagConstraints5);
            this.jPanel.add((Component)this.Ldummy, gridBagConstraints6);
            this.jPanel.add((Component)this.getBimportXml(), gridBagConstraints7);
            this.jPanel.add((Component)this.getBexportXml(), gridBagConstraints8);
            this.jPanel.add((Component)this.getBsetSignature(), gridBagConstraints9);
        }
        return this.jPanel;
    }

    private JList getIdentitiesList() {
        if (this.identitiesList == null) {
            this.identitiesList = new JList();
            this.identitiesList.setModel(new DefaultListModel());
            for (LocalIdentity element : Core.getIdentities().getLocalIdentities()) {
                ((DefaultListModel)this.identitiesList.getModel()).addElement(element);
            }
        }
        return this.identitiesList;
    }

    private JButton getBaddNewIdentity() {
        if (this.BaddNewIdentity == null) {
            this.BaddNewIdentity = new JButton();
            this.BaddNewIdentity.setText("ManageLocalIdentities.button.createNewIdentity");
            this.BaddNewIdentity.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    LocalIdentity newIdentity = Core.getIdentities().createIdentity();
                    if (newIdentity != null) {
                        DefaultListModel m = (DefaultListModel)ManageLocalIdentitiesDialog.this.getIdentitiesList().getModel();
                        m.addElement(newIdentity);
                    }
                }
            });
        }
        return this.BaddNewIdentity;
    }

    private JButton getBdeleteIdentity() {
        if (this.BdeleteIdentity == null) {
            this.BdeleteIdentity = new JButton();
            this.BdeleteIdentity.setText("ManageLocalIdentities.button.deleteIdentity");
            this.BdeleteIdentity.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int answer;
                    LocalIdentity li = (LocalIdentity)ManageLocalIdentitiesDialog.this.getIdentitiesList().getSelectedValue();
                    if (li == null) {
                        return;
                    }
                    if (Core.getIdentities().getLocalIdentities().size() <= 1) {
                        JOptionPane.showMessageDialog(ManageLocalIdentitiesDialog.this, ManageLocalIdentitiesDialog.this.language.getString("ManageLocalIdentities.cannotDeleteLastIdentity.body"), ManageLocalIdentitiesDialog.this.language.getString("ManageLocalIdentities.cannotDeleteLastIdentity.title"), 1);
                    }
                    if ((answer = JOptionPane.showConfirmDialog(ManageLocalIdentitiesDialog.this, ManageLocalIdentitiesDialog.this.language.formatMessage("ManageLocalIdentities.deleteIdentityConfirmation.body", li.getUniqueName()), ManageLocalIdentitiesDialog.this.language.getString("ManageLocalIdentities.deleteIdentityConfirmation.title"), 0, 2)) == 1) {
                        return;
                    }
                    int count = Core.getInstance().getFileTransferManager().countFilesSharedByLocalIdentity(li);
                    if (count > 0 && (answer = JOptionPane.showConfirmDialog(ManageLocalIdentitiesDialog.this, ManageLocalIdentitiesDialog.this.language.formatMessage("ManageLocalIdentities.deleteIdentitiesSharedFilesConfirmation.body", li.getUniqueName(), Integer.toString(count)), ManageLocalIdentitiesDialog.this.language.getString("ManageLocalIdentities.deleteIdentitiesSharedFilesConfirmation.title"), 0, 2)) == 1) {
                        return;
                    }
                    Core.getInstance().getFileTransferManager().removeFilesSharedByLocalIdentity(li);
                    Core.getIdentities().deleteLocalIdentity(li);
                    Identity myOld = new Identity(li);
                    myOld.setGOODWithoutUpdate();
                    Core.getIdentities().addIdentity(myOld);
                    ((DefaultListModel)ManageLocalIdentitiesDialog.this.getIdentitiesList().getModel()).removeElement(li);
                }
            });
        }
        return this.BdeleteIdentity;
    }

    protected LocalIdentity importLocalIdentityFromIdentityXml(File identitiesXmlFile) {
        Document d = XMLTools.parseXmlFile(identitiesXmlFile, false);
        Element rootEl = d.getDocumentElement();
        Element myself = XMLTools.getChildElementsByTagName(rootEl, "MyIdentity").get(0);
        LocalIdentity myId = null;
        if (myself != null) {
            myId = LocalIdentity.createLocalIdentityFromXmlElement(myself);
        }
        return myId;
    }

    private JButton getBimportIdentityXml() {
        if (this.BimportIdentityXml == null) {
            this.BimportIdentityXml = new JButton();
            this.BimportIdentityXml.setText("ManageLocalIdentities.button.importIdentity");
            this.BimportIdentityXml.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    File xmlFile = ManageLocalIdentitiesDialog.this.chooseIdentitiesFile();
                    if (xmlFile == null) {
                        return;
                    }
                    LocalIdentity importedIdentity = ManageLocalIdentitiesDialog.this.importLocalIdentityFromIdentityXml(xmlFile);
                    if (importedIdentity == null) {
                        JOptionPane.showMessageDialog(ManageLocalIdentitiesDialog.this, ManageLocalIdentitiesDialog.this.language.getString("ManageLocalIdentities.noIdentityToImport.body"), ManageLocalIdentitiesDialog.this.language.getString("ManageLocalIdentities.noIdentityToImport.title"), 2);
                        return;
                    }
                    if (!Core.getIdentities().addLocalIdentity(importedIdentity)) {
                        JOptionPane.showMessageDialog(ManageLocalIdentitiesDialog.this, ManageLocalIdentitiesDialog.this.language.formatMessage("ManageLocalIdentities.duplicateIdentity.body", importedIdentity.getUniqueName()), ManageLocalIdentitiesDialog.this.language.getString("ManageLocalIdentities.duplicateIdentity.title"), 2);
                        return;
                    }
                    JOptionPane.showMessageDialog(ManageLocalIdentitiesDialog.this, ManageLocalIdentitiesDialog.this.language.formatMessage("ManageLocalIdentities.identityImported.body", importedIdentity.getUniqueName()), ManageLocalIdentitiesDialog.this.language.getString("ManageLocalIdentities.identityImported.title"), 1);
                    ((DefaultListModel)ManageLocalIdentitiesDialog.this.getIdentitiesList().getModel()).addElement(importedIdentity);
                    ManageLocalIdentitiesDialog.this.identitiesImported = true;
                }
            });
        }
        return this.BimportIdentityXml;
    }

    private File chooseIdentitiesFile() {
        FileFilter myFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().equals("identities.xml");
            }

            public String getDescription() {
                return "identities.xml";
            }
        };
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(myFilter);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    private File chooseXmlImportFile() {
        FileFilter myFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".xml");
            }

            public String getDescription() {
                return "localidentities.xml";
            }
        };
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(myFilter);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    private File chooseXmlExportFile() {
        FileFilter myFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith(".xml");
            }

            public String getDescription() {
                return "localidentities.xml";
            }
        };
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(myFilter);
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            int answer;
            File f = chooser.getSelectedFile();
            if (!f.getName().endsWith(".xml")) {
                f = new File(f.getPath() + ".xml");
            }
            if (f.exists() && (answer = JOptionPane.showConfirmDialog(this, this.language.formatMessage("ManageLocalIdentities.exportIdentitiesConfirmXmlFileOverwrite.body", f.getName()), this.language.getString("ManageLocalIdentities.exportIdentitiesConfirmXmlFileOverwrite.title"), 0, 2)) == 1) {
                return null;
            }
            return f;
        }
        return null;
    }

    private JButton getBimportXml() {
        if (this.BimportXml == null) {
            this.BimportXml = new JButton();
            this.BimportXml.setText("ManageLocalIdentities.button.importXml");
            this.BimportXml.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    File xmlFile = ManageLocalIdentitiesDialog.this.chooseXmlImportFile();
                    if (xmlFile == null) {
                        return;
                    }
                    List<LocalIdentity> localIdentities = LocalIdentitiesXmlDAO.loadLocalidentities(xmlFile);
                    if (localIdentities.size() == 0) {
                        JOptionPane.showMessageDialog(ManageLocalIdentitiesDialog.this, ManageLocalIdentitiesDialog.this.language.getString("ManageLocalIdentities.noLocalIdentityToImport.body"), ManageLocalIdentitiesDialog.this.language.getString("ManageLocalIdentities.noLocalIdentityToImport.title"), 2);
                        return;
                    }
                    int count = 0;
                    Iterator<LocalIdentity> i$ = localIdentities.iterator();
                    while (i$.hasNext()) {
                        LocalIdentity localIdentity;
                        LocalIdentity lId = localIdentity = i$.next();
                        if (!Core.getIdentities().addLocalIdentity(lId)) {
                            JOptionPane.showMessageDialog(ManageLocalIdentitiesDialog.this, ManageLocalIdentitiesDialog.this.language.formatMessage("ManageLocalIdentities.duplicateLocalIdentity.body", lId.getUniqueName()), ManageLocalIdentitiesDialog.this.language.getString("ManageLocalIdentities.duplicateLocalIdentity.title"), 2);
                            continue;
                        }
                        ++count;
                        ((DefaultListModel)ManageLocalIdentitiesDialog.this.getIdentitiesList().getModel()).addElement(lId);
                    }
                    JOptionPane.showMessageDialog(ManageLocalIdentitiesDialog.this, ManageLocalIdentitiesDialog.this.language.formatMessage("ManageLocalIdentities.localIdentitiesImported.body", Integer.toString(count)), ManageLocalIdentitiesDialog.this.language.getString("ManageLocalIdentities.localIdentitiesImported.title"), 2);
                    if (count > 0) {
                        ManageLocalIdentitiesDialog.this.identitiesImported = true;
                    }
                }
            });
        }
        return this.BimportXml;
    }

    private JButton getBexportXml() {
        if (this.BexportXml == null) {
            this.BexportXml = new JButton();
            this.BexportXml.setText("ManageLocalIdentities.button.exportXml");
            this.BexportXml.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(ManageLocalIdentitiesDialog.this, ManageLocalIdentitiesDialog.this.language.getString("ManageLocalIdentities.privateKeyExportWarning.body"), ManageLocalIdentitiesDialog.this.language.getString("ManageLocalIdentities.privateKeyExportWarning.title"), 2);
                    File xmlFile = ManageLocalIdentitiesDialog.this.chooseXmlExportFile();
                    if (xmlFile == null) {
                        return;
                    }
                    List<LocalIdentity> lIds = Core.getIdentities().getLocalIdentities();
                    boolean wasOk = LocalIdentitiesXmlDAO.saveLocalIdentities(xmlFile, lIds);
                    if (wasOk) {
                        JOptionPane.showMessageDialog(ManageLocalIdentitiesDialog.this, ManageLocalIdentitiesDialog.this.language.formatMessage("ManageLocalIdentities.identitiesExported.body", Integer.toString(lIds.size())), ManageLocalIdentitiesDialog.this.language.getString("ManageLocalIdentities.identitiesExported.title"), 1);
                    } else {
                        JOptionPane.showMessageDialog(ManageLocalIdentitiesDialog.this, ManageLocalIdentitiesDialog.this.language.getString("ManageLocalIdentities.identitiesExportFailed.body"), ManageLocalIdentitiesDialog.this.language.getString("ManageLocalIdentities.identitiesExportFailed.title"), 0);
                    }
                }
            });
        }
        return this.BexportXml;
    }

    private JButton getBsetSignature() {
        if (this.BsetSignature == null) {
            this.BsetSignature = new JButton();
            this.BsetSignature.setText("ManageLocalIdentities.button.editSignature");
            this.BsetSignature.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String signature;
                    LocalIdentity li = (LocalIdentity)ManageLocalIdentitiesDialog.this.getIdentitiesList().getSelectedValue();
                    if (li == null) {
                        return;
                    }
                    ManageLocalIdentitiesSignatureDialog dlg = new ManageLocalIdentitiesSignatureDialog(ManageLocalIdentitiesDialog.this);
                    String idString = li.getUniqueName();
                    String newSig = dlg.startDialog(idString, signature = li.getSignature());
                    if (newSig != null) {
                        if ((newSig = newSig.trim()).length() == 0) {
                            newSig = null;
                        }
                        li.setSignature(newSig);
                    }
                }
            });
        }
        return this.BsetSignature;
    }

    public boolean isIdentitiesImported() {
        return this.identitiesImported;
    }
}

