/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.Core;
import frost.util.gui.textpane.AntialiasedTextArea;
import frost.util.gui.translation.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ManageLocalIdentitiesSignatureDialog
extends JDialog {
    private Language language = Language.getInstance();
    private JPanel jContentPane = null;
    private JPanel buttonPanel = null;
    private JButton Bok = null;
    private JButton Bcancel = null;
    private AntialiasedTextArea signatureTextArea;
    private String returnValue = null;

    public ManageLocalIdentitiesSignatureDialog(Dialog owner) {
        super(owner);
        this.initialize();
        this.setModal(true);
        this.setLocationRelativeTo(owner);
    }

    private void initialize() {
        this.setSize(400, 200);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            JScrollPane signatureScrollPane = new JScrollPane(this.getSignatureTextArea());
            this.jContentPane.add((Component)signatureScrollPane, "Center");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.add((Component)this.getBok(), null);
            this.buttonPanel.add((Component)this.getBcancel(), null);
        }
        return this.buttonPanel;
    }

    private JButton getBok() {
        if (this.Bok == null) {
            this.Bok = new JButton();
            this.Bok.setText("Ok");
            this.Bok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ManageLocalIdentitiesSignatureDialog.this.returnValue = ManageLocalIdentitiesSignatureDialog.this.getSignatureTextArea().getText();
                    ManageLocalIdentitiesSignatureDialog.this.setVisible(false);
                }
            });
        }
        return this.Bok;
    }

    private JButton getBcancel() {
        if (this.Bcancel == null) {
            this.Bcancel = new JButton();
            this.Bcancel.setText("Cancel");
            this.Bcancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ManageLocalIdentitiesSignatureDialog.this.returnValue = null;
                    ManageLocalIdentitiesSignatureDialog.this.setVisible(false);
                }
            });
        }
        return this.Bcancel;
    }

    private AntialiasedTextArea getSignatureTextArea() {
        if (this.signatureTextArea == null) {
            int fontSize;
            int fontStyle;
            this.signatureTextArea = new AntialiasedTextArea(6, 50);
            String fontName = Core.frostSettings.getValue("messageBodyFontName");
            Font tofFont = new Font(fontName, fontStyle = Core.frostSettings.getIntValue("messageBodyFontStyle"), fontSize = Core.frostSettings.getIntValue("messageBodyFontSize"));
            if (!tofFont.getFamily().equals(fontName)) {
                Core.frostSettings.setValue("messageBodyFontName", "Monospaced");
                tofFont = new Font("Monospaced", fontStyle, fontSize);
            }
            this.signatureTextArea.setFont(tofFont);
            this.signatureTextArea.setAntiAliasEnabled(Core.frostSettings.getBoolValue("messageBodyAA"));
        }
        return this.signatureTextArea;
    }

    public String startDialog(String idStr, String originalSig) {
        String title = this.language.formatMessage("ManageLocalIdentitiesSignatureDialog.title", idStr);
        this.setTitle(title);
        if (originalSig == null) {
            originalSig = "";
        }
        this.getSignatureTextArea().setText(originalSig);
        this.returnValue = null;
        this.setVisible(true);
        return this.returnValue;
    }
}

