/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.Core;
import frost.MainFrame;
import frost.SettingsClass;
import frost.boards.Board;
import frost.ext.AltEdit;
import frost.gui.BoardsChooser;
import frost.gui.ScrollableBar;
import frost.gui.SmileyChooserDialog;
import frost.gui.SortedTable;
import frost.gui.model.SortedTableModel;
import frost.gui.model.TableMember;
import frost.identities.Identity;
import frost.identities.LocalIdentity;
import frost.messages.BoardAttachment;
import frost.messages.FileAttachment;
import frost.messages.FrostMessageObject;
import frost.messages.FrostUnsentMessageObject;
import frost.messages.UnsentMessagesManager;
import frost.storage.perst.messages.MessageStorage;
import frost.util.DateFun;
import frost.util.FileAccess;
import frost.util.Mixed;
import frost.util.gui.ImmutableArea;
import frost.util.gui.ImmutableAreasDocument;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.MiscToolkit;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.textpane.AntialiasedTextArea;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class MessageFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(MessageFrame.class.getName());
    private final Language language;
    private final Listener listener = new Listener();
    private boolean initialized = false;
    private final Window parentWindow;
    private Board board;
    private String repliedMsgId;
    private final SettingsClass frostSettings;
    private MFAttachedBoardsTable boardsTable;
    private MFAttachedFilesTable filesTable;
    private MFAttachedBoardsTableModel boardsTableModel;
    private MFAttachedFilesTableModel filesTableModel;
    private JSplitPane messageSplitPane = null;
    private JSplitPane attachmentsSplitPane = null;
    private JScrollPane filesTableScrollPane;
    private JScrollPane boardsTableScrollPane;
    private JSkinnablePopupMenu attFilesPopupMenu;
    private JSkinnablePopupMenu attBoardsPopupMenu;
    private MessageBodyPopupMenu messageBodyPopupMenu;
    private final JButton Bsend = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/mail-forward.png"));
    private final JButton Bcancel = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/user-trash.png"));
    private final JButton BattachFile = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/mail-attachment.png"));
    private final JButton BattachBoard = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/internet-group-chat.png"));
    private final JCheckBox sign = new JCheckBox();
    private final JCheckBox encrypt = new JCheckBox();
    private JComboBox buddies;
    private final JLabel Lboard = new JLabel();
    private final JLabel Lfrom = new JLabel();
    private final JLabel Lsubject = new JLabel();
    private final JTextField TFboard = new JTextField();
    private final JTextField subjectTextField = new JTextField();
    private final JButton BchooseSmiley = new JButton(MiscToolkit.loadImageIcon("/data/toolbar/face-smile.png"));
    private final AntialiasedTextArea messageTextArea = new AntialiasedTextArea();
    private ImmutableArea headerArea = null;
    private String oldSender = null;
    private String currentSignature = null;
    private FrostMessageObject repliedMessage = null;
    private JComboBox ownIdentitiesComboBox = null;
    private static int openInstanceCount = 0;

    public MessageFrame(SettingsClass newSettings, Window tparentWindow) {
        this.parentWindow = tparentWindow;
        this.language = Language.getInstance();
        this.frostSettings = newSettings;
        MessageFrame.incOpenInstanceCount();
        String fontName = this.frostSettings.getValue("messageBodyFontName");
        int fontStyle = this.frostSettings.getIntValue("messageBodyFontStyle");
        int fontSize = this.frostSettings.getIntValue("messageBodyFontSize");
        Font tofFont = new Font(fontName, fontStyle, fontSize);
        if (!tofFont.getFamily().equals(fontName)) {
            logger.severe("The selected font was not found in your system\nThat selection will be changed to \"Monospaced\".");
            this.frostSettings.setValue("messageBodyFontName", "Monospaced");
            tofFont = new Font("Monospaced", fontStyle, fontSize);
        }
        this.messageTextArea.setFont(tofFont);
        this.messageTextArea.setAntiAliasEnabled(this.frostSettings.getBoolValue("messageBodyAA"));
        ImmutableAreasDocument messageDocument = new ImmutableAreasDocument();
        this.headerArea = new ImmutableArea(messageDocument);
        messageDocument.addImmutableArea(this.headerArea);
        this.messageTextArea.setDocument(messageDocument);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MessageFrame.this.windowIsClosing(e);
            }

            public void windowClosed(WindowEvent e) {
                MessageFrame.this.windowWasClosed(e);
            }
        });
        this.setDefaultCloseOperation(0);
    }

    private void windowIsClosing(WindowEvent e) {
        String title = this.language.getString("MessageFrame.discardMessage.title");
        String text = this.language.getString("MessageFrame.discardMessage.text");
        int answer = JOptionPane.showConfirmDialog(this, text, title, 0, 2);
        if (answer == 0) {
            this.dispose();
        }
    }

    private void windowWasClosed(WindowEvent e) {
        MessageFrame.decOpenInstanceCount();
    }

    private void attachBoards_actionPerformed(ActionEvent e) {
        LinkedList<Board> allBoards = MainFrame.getInstance().getTofTreeModel().getAllBoards();
        if (allBoards.size() == 0) {
            return;
        }
        Collections.sort(allBoards);
        BoardsChooser chooser = new BoardsChooser((Frame)this, allBoards);
        chooser.setLocationRelativeTo(this);
        List<Board> chosenBoards = chooser.runDialog();
        if (chosenBoards == null || chosenBoards.size() == 0) {
            return;
        }
        for (int i = 0; i < chosenBoards.size(); ++i) {
            int answer;
            Board chosedBoard = chosenBoards.get(i);
            String privKey = chosedBoard.getPrivateKey();
            if (privKey != null && (answer = JOptionPane.showConfirmDialog(this, this.language.formatMessage("MessageFrame.attachBoard.sendPrivateKeyConfirmationDialog.body", chosedBoard.getName()), this.language.getString("MessageFrame.attachBoard.sendPrivateKeyConfirmationDialog.title"), 0)) == 1) {
                privKey = null;
            }
            Board aNewBoard = new Board(chosedBoard.getName(), chosedBoard.getPublicKey(), privKey, chosedBoard.getDescription());
            MFAttachedBoard ab = new MFAttachedBoard(aNewBoard);
            this.boardsTableModel.addRow(ab);
        }
        this.positionDividers();
    }

    private void attachFile_actionPerformed(ActionEvent e) {
        String lastUsedDirectory = this.frostSettings.getValue("lastUsedDirectory");
        JFileChooser fc = new JFileChooser(lastUsedDirectory);
        fc.setDialogTitle(this.language.getString("MessageFrame.fileChooser.title"));
        fc.setFileHidingEnabled(false);
        fc.setFileSelectionMode(2);
        fc.setMultiSelectionEnabled(true);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File[] selectedFiles;
            for (File element : selectedFiles = fc.getSelectedFiles()) {
                this.frostSettings.setValue("lastUsedDirectory", element.getPath());
                ArrayList<File> allFiles = FileAccess.getAllEntries(element, "");
                for (int j = 0; j < allFiles.size(); ++j) {
                    File aFile = allFiles.get(j);
                    if (!aFile.isFile() || aFile.length() <= 0L) continue;
                    MFAttachedFile af = new MFAttachedFile(aFile);
                    this.filesTableModel.addRow(af);
                }
            }
        }
        this.positionDividers();
    }

    private void cancel_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void composeMessage(Board newBoard, String newSubject, String inReplyTo, String newText, boolean isReply, Identity recipient, LocalIdentity senderId, FrostMessageObject msg) {
        this.repliedMessage = msg;
        if (isReply) {
            newText = newText + "\n\n";
        }
        if (this.frostSettings.getBoolValue("useAltEdit")) {
            TransferObject to = new TransferObject();
            to.newBoard = newBoard;
            to.newSubject = newSubject;
            to.inReplyTo = inReplyTo;
            to.newText = newText;
            to.isReply = isReply;
            to.recipient = recipient;
            to.senderId = senderId;
            DateTime now = new DateTime(DateTimeZone.UTC);
            String date = DateFun.FORMAT_DATE_EXT.print(now) + " - " + DateFun.FORMAT_TIME_EXT.print(now);
            String fromLine = "----- (sender) ----- " + date + " -----";
            String editText = newText + fromLine + "\n\n";
            AltEdit ae = new AltEdit(newSubject, editText, MainFrame.getInstance(), to, this);
            ae.start();
        } else {
            this.composeMessageContinued(newBoard, newSubject, inReplyTo, newText, null, isReply, recipient, senderId);
        }
    }

    public void altEditCallback(Object toObj, String newAltSubject, String newAltText) {
        TransferObject to = (TransferObject)toObj;
        if (newAltSubject == null) {
            newAltSubject = to.newSubject;
        }
        this.composeMessageContinued(to.newBoard, newAltSubject, to.inReplyTo, to.newText, newAltText, to.isReply, to.recipient, to.senderId);
    }

    private void composeMessageContinued(Board newBoard, String newSubject, String inReplyTo, String newText, String altEditText, boolean isReply, Identity recipient, LocalIdentity senderId) {
        LocalIdentity li;
        LocalIdentity li2;
        Object obj;
        int x;
        boolean isInitializedSigned;
        String from;
        this.headerArea.setEnabled(false);
        this.board = newBoard;
        this.repliedMsgId = inReplyTo;
        if (senderId != null) {
            from = senderId.getUniqueName();
            isInitializedSigned = true;
        } else {
            String userName = Core.frostSettings.getValue("userName." + this.board.getBoardFilename());
            if (userName == null || userName.length() == 0) {
                userName = Core.frostSettings.getValue("userName");
            }
            if (Core.getIdentities().isMySelf(userName)) {
                from = userName;
                isInitializedSigned = true;
            } else if (userName.indexOf("@") > 0) {
                from = "Anonymous";
                isInitializedSigned = false;
            } else {
                from = userName;
                isInitializedSigned = false;
            }
        }
        this.oldSender = from;
        this.enableEvents(64L);
        try {
            this.initialize(newBoard, newSubject);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception thrown in composeMessage(...)", e);
        }
        this.sign.setEnabled(false);
        ImageIcon signedIcon = MiscToolkit.loadImageIcon("/data/signed.gif");
        ImageIcon unsignedIcon = MiscToolkit.loadImageIcon("/data/unsigned.gif");
        this.sign.setDisabledSelectedIcon(signedIcon);
        this.sign.setDisabledIcon(unsignedIcon);
        this.sign.setSelectedIcon(signedIcon);
        this.sign.setIcon(unsignedIcon);
        this.sign.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                MessageFrame.this.updateSignToolTip();
            }
        });
        if (recipient != null) {
            for (x = 0; x < this.getOwnIdentitiesComboBox().getItemCount(); ++x) {
                obj = this.getOwnIdentitiesComboBox().getItemAt(x);
                if (!(obj instanceof LocalIdentity)) continue;
                li2 = (LocalIdentity)obj;
                if (!senderId.getUniqueName().equals(li2.getUniqueName())) continue;
                this.getOwnIdentitiesComboBox().setSelectedIndex(x);
                break;
            }
            this.getOwnIdentitiesComboBox().setEnabled(false);
            this.sign.setSelected(true);
            this.encrypt.setSelected(true);
            this.buddies.removeAllItems();
            this.buddies.addItem(recipient);
            this.buddies.setSelectedItem(recipient);
            this.encrypt.setEnabled(false);
            this.buddies.setEnabled(false);
        } else {
            if (isInitializedSigned) {
                for (x = 0; x < this.getOwnIdentitiesComboBox().getItemCount(); ++x) {
                    obj = this.getOwnIdentitiesComboBox().getItemAt(x);
                    if (!(obj instanceof LocalIdentity) || !from.equals((li2 = (LocalIdentity)obj).getUniqueName())) continue;
                    this.getOwnIdentitiesComboBox().setSelectedIndex(x);
                    this.sign.setSelected(true);
                    this.getOwnIdentitiesComboBox().setEditable(false);
                    break;
                }
            } else {
                this.getOwnIdentitiesComboBox().setSelectedIndex(0);
                this.getOwnIdentitiesComboBox().getEditor().setItem(from);
                this.sign.setSelected(false);
                this.getOwnIdentitiesComboBox().setEditable(true);
            }
            if (this.sign.isSelected() && this.buddies.getItemCount() > 0) {
                this.encrypt.setEnabled(true);
            } else {
                this.encrypt.setEnabled(false);
            }
            this.encrypt.setSelected(false);
            this.buddies.setEnabled(false);
        }
        this.updateSignToolTip();
        DateTime now = new DateTime(DateTimeZone.UTC);
        String date = DateFun.FORMAT_DATE_EXT.print(now) + " - " + DateFun.FORMAT_TIME_EXT.print(now);
        String fromLine = "----- " + from + " ----- " + date + " -----";
        int headerAreaStart = newText.length();
        newText = newText + fromLine + "\n\n";
        int headerAreaEnd = newText.length() - 2;
        if (altEditText != null) {
            newText = newText + altEditText;
        }
        int caretPos = newText.length();
        this.currentSignature = null;
        if (this.sign.isSelected() && (li = (LocalIdentity)this.getOwnIdentitiesComboBox().getSelectedItem()).getSignature() != null) {
            this.currentSignature = "\n-- \n" + li.getSignature();
            newText = newText + this.currentSignature;
        }
        this.messageTextArea.setText(newText);
        this.headerArea.setStartPos(headerAreaStart);
        this.headerArea.setEndPos(headerAreaEnd);
        this.headerArea.setEnabled(true);
        this.setVisible(true);
        this.positionDividers();
        this.messageTextArea.requestFocusInWindow();
        this.messageTextArea.getCaret().setDot(caretPos);
        this.messageTextArea.getCaret().setVisible(true);
    }

    public void composeNewMessage(Board newBoard, String newSubject, String newText) {
        this.composeMessage(newBoard, newSubject, null, newText, false, null, null, null);
    }

    public void composeReply(Board newBoard, String newSubject, String inReplyTo, String newText, FrostMessageObject msg) {
        this.composeMessage(newBoard, newSubject, inReplyTo, newText, true, null, null, msg);
    }

    public void composeEncryptedReply(Board newBoard, String newSubject, String inReplyTo, String newText, Identity recipient, LocalIdentity senderId, FrostMessageObject msg) {
        this.composeMessage(newBoard, newSubject, inReplyTo, newText, true, recipient, senderId, msg);
    }

    public void dispose() {
        if (this.initialized) {
            this.language.removeLanguageListener(this.listener);
            this.initialized = false;
        }
        super.dispose();
    }

    private MessageBodyPopupMenu getMessageBodyPopupMenu() {
        if (this.messageBodyPopupMenu == null) {
            this.messageBodyPopupMenu = new MessageBodyPopupMenu(this.messageTextArea);
        }
        return this.messageBodyPopupMenu;
    }

    private void initialize(Board targetBoard, String subject) throws Exception {
        if (!this.initialized) {
            this.refreshLanguage();
            this.language.addLanguageListener(this.listener);
            ImageIcon frameIcon = MiscToolkit.loadImageIcon("/data/toolbar/mail-message-new.png");
            this.setIconImage(frameIcon.getImage());
            this.setResizable(true);
            this.boardsTableModel = new MFAttachedBoardsTableModel();
            this.boardsTable = new MFAttachedBoardsTable(this.boardsTableModel);
            this.boardsTableScrollPane = new JScrollPane(this.boardsTable);
            this.boardsTableScrollPane.setWheelScrollingEnabled(true);
            this.boardsTable.addMouseListener(this.listener);
            this.filesTableModel = new MFAttachedFilesTableModel();
            this.filesTable = new MFAttachedFilesTable(this.filesTableModel);
            this.filesTableScrollPane = new JScrollPane(this.filesTable);
            this.filesTableScrollPane.setWheelScrollingEnabled(true);
            this.filesTable.addMouseListener(this.listener);
            List<Identity> budList = Core.getIdentities().getAllGOODIdentities();
            Identity id = null;
            if (this.repliedMessage != null) {
                id = this.repliedMessage.getFromIdentity();
            }
            if (budList.size() > 0 || id != null) {
                Collections.sort(budList, new BuddyComparator());
                if (id != null) {
                    if (id.isGOOD()) {
                        budList.remove(id);
                    }
                    budList.add(0, id);
                }
                this.buddies = new JComboBox<Identity>(new Vector<Identity>(budList));
                this.buddies.setSelectedItem(budList.get(0));
            } else {
                this.buddies = new JComboBox();
            }
            this.buddies.setMaximumSize(new Dimension(300, 25));
            MiscToolkit.configureButton(this.Bsend, "MessageFrame.toolbar.tooltip.sendMessage", this.language);
            MiscToolkit.configureButton(this.Bcancel, "Common.cancel", this.language);
            MiscToolkit.configureButton(this.BattachFile, "MessageFrame.toolbar.tooltip.addFileAttachments", this.language);
            MiscToolkit.configureButton(this.BattachBoard, "MessageFrame.toolbar.tooltip.addBoardAttachments", this.language);
            MiscToolkit.configureButton(this.BchooseSmiley, "MessageFrame.toolbar.tooltip.chooseSmiley", this.language);
            this.BchooseSmiley.setFocusable(false);
            this.TFboard.setEditable(false);
            this.TFboard.setText(targetBoard.getName());
            new TextComponentClipboardMenu(this.TFboard, this.language);
            new TextComponentClipboardMenu((TextComboBoxEditor)this.getOwnIdentitiesComboBox().getEditor(), this.language);
            new TextComponentClipboardMenu(this.subjectTextField, this.language);
            this.subjectTextField.setText(subject);
            this.messageTextArea.setLineWrap(true);
            this.messageTextArea.setWrapStyleWord(true);
            this.messageTextArea.addMouseListener(this.listener);
            this.sign.setOpaque(false);
            this.encrypt.setOpaque(false);
            this.Bsend.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MessageFrame.this.send_actionPerformed(e);
                }
            });
            this.Bcancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MessageFrame.this.cancel_actionPerformed(e);
                }
            });
            this.BattachFile.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MessageFrame.this.attachFile_actionPerformed(e);
                }
            });
            this.BattachBoard.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MessageFrame.this.attachBoards_actionPerformed(e);
                }
            });
            this.encrypt.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MessageFrame.this.encrypt_actionPerformed(e);
                }
            });
            this.BchooseSmiley.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MessageFrame.this.chooseSmiley_actionPerformed(e);
                }
            });
            JPanel panelMain = new JPanel(new BorderLayout());
            JPanel panelHeader = new JPanel(new BorderLayout());
            JPanel panelTextfields = new JPanel(new GridBagLayout());
            JToolBar panelToolbar = new JToolBar();
            panelToolbar.setRollover(true);
            panelToolbar.setFloatable(false);
            JScrollPane bodyScrollPane = new JScrollPane(this.messageTextArea);
            bodyScrollPane.setWheelScrollingEnabled(true);
            bodyScrollPane.setMinimumSize(new Dimension(100, 50));
            GridBagConstraints constraints = new GridBagConstraints();
            Insets insets = new Insets(0, 3, 0, 3);
            Insets insets0 = new Insets(0, 0, 0, 0);
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.weighty = 0.0;
            constraints.weightx = 0.0;
            constraints.insets = insets;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.fill = 0;
            constraints.gridwidth = 1;
            constraints.insets = insets;
            constraints.weightx = 0.0;
            panelTextfields.add((Component)this.Lboard, constraints);
            constraints.gridx = 1;
            constraints.fill = 2;
            constraints.gridwidth = 2;
            constraints.insets = insets0;
            constraints.weightx = 1.0;
            panelTextfields.add((Component)this.TFboard, constraints);
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.fill = 0;
            constraints.gridwidth = 1;
            constraints.insets = insets;
            constraints.weightx = 0.0;
            panelTextfields.add((Component)this.Lfrom, constraints);
            constraints.gridx = 1;
            constraints.fill = 2;
            constraints.gridwidth = 2;
            constraints.insets = insets0;
            constraints.weightx = 1.0;
            panelTextfields.add((Component)this.getOwnIdentitiesComboBox(), constraints);
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.fill = 0;
            constraints.gridwidth = 1;
            constraints.insets = insets;
            constraints.weightx = 0.0;
            panelTextfields.add((Component)this.Lsubject, constraints);
            constraints.gridx = 1;
            constraints.fill = 2;
            constraints.gridwidth = 1;
            constraints.insets = insets0;
            constraints.weightx = 1.0;
            panelTextfields.add((Component)this.subjectTextField, constraints);
            constraints.gridx = 2;
            constraints.fill = 0;
            constraints.gridwidth = 1;
            constraints.insets = insets;
            constraints.weightx = 0.0;
            panelTextfields.add((Component)this.BchooseSmiley, constraints);
            panelToolbar.add(this.Bsend);
            panelToolbar.add(this.Bcancel);
            panelToolbar.addSeparator();
            panelToolbar.add(this.BattachFile);
            panelToolbar.add(this.BattachBoard);
            panelToolbar.addSeparator();
            panelToolbar.add(this.sign);
            panelToolbar.addSeparator();
            panelToolbar.add(this.encrypt);
            panelToolbar.add(this.buddies);
            ScrollableBar panelButtonsScrollable = new ScrollableBar(panelToolbar);
            panelHeader.add((Component)panelButtonsScrollable, "First");
            panelHeader.add((Component)panelTextfields, "Center");
            this.attachmentsSplitPane = new JSplitPane(0, this.filesTableScrollPane, this.boardsTableScrollPane);
            this.attachmentsSplitPane.setResizeWeight(0.5);
            this.attachmentsSplitPane.setDividerSize(3);
            this.attachmentsSplitPane.setDividerLocation(0.5);
            this.messageSplitPane = new JSplitPane(0, bodyScrollPane, this.attachmentsSplitPane);
            this.messageSplitPane.setDividerSize(0);
            this.messageSplitPane.setDividerLocation(1.0);
            this.messageSplitPane.setResizeWeight(1.0);
            panelMain.add((Component)panelHeader, "North");
            panelMain.add((Component)this.messageSplitPane, "Center");
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)panelMain, "Center");
            this.initPopupMenu();
            this.pack();
            int width = this.getWidth();
            if (width < (int)((double)this.parentWindow.getWidth() * 0.75)) {
                width = (int)((double)this.parentWindow.getWidth() * 0.75);
            }
            this.setSize(width, (int)((double)this.parentWindow.getHeight() * 0.75));
            this.setLocationRelativeTo(this.parentWindow);
            this.initialized = true;
        }
    }

    protected void initPopupMenu() {
        this.attFilesPopupMenu = new JSkinnablePopupMenu();
        this.attBoardsPopupMenu = new JSkinnablePopupMenu();
        JMenuItem removeFiles = new JMenuItem(this.language.getString("MessageFrame.attachmentTables.popupmenu.remove"));
        JMenuItem removeBoards = new JMenuItem(this.language.getString("MessageFrame.attachmentTables.popupmenu.remove"));
        removeFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessageFrame.this.removeSelectedItemsFromTable(MessageFrame.this.filesTable);
            }
        });
        removeBoards.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MessageFrame.this.removeSelectedItemsFromTable(MessageFrame.this.boardsTable);
            }
        });
        this.attFilesPopupMenu.add(removeFiles);
        this.attBoardsPopupMenu.add(removeBoards);
    }

    private void positionDividers() {
        int attachedFiles = this.filesTableModel.getRowCount();
        int attachedBoards = this.boardsTableModel.getRowCount();
        if (attachedFiles == 0 && attachedBoards == 0) {
            this.messageSplitPane.setBottomComponent(null);
            this.messageSplitPane.setDividerSize(0);
            return;
        }
        this.messageSplitPane.setDividerSize(3);
        this.messageSplitPane.setDividerLocation(0.75);
        if (attachedFiles != 0 && attachedBoards == 0) {
            this.messageSplitPane.setBottomComponent(this.filesTableScrollPane);
            return;
        }
        if (attachedFiles == 0 && attachedBoards != 0) {
            this.messageSplitPane.setBottomComponent(this.boardsTableScrollPane);
            return;
        }
        if (attachedFiles != 0 && attachedBoards != 0) {
            this.messageSplitPane.setBottomComponent(this.attachmentsSplitPane);
            this.attachmentsSplitPane.setTopComponent(this.filesTableScrollPane);
            this.attachmentsSplitPane.setBottomComponent(this.boardsTableScrollPane);
        }
    }

    private void refreshLanguage() {
        this.setTitle(this.language.getString("MessageFrame.createMessage.title"));
        this.Bsend.setToolTipText(this.language.getString("MessageFrame.toolbar.tooltip.sendMessage"));
        this.Bcancel.setToolTipText(this.language.getString("Common.cancel"));
        this.BattachFile.setToolTipText(this.language.getString("MessageFrame.toolbar.tooltip.addFileAttachments"));
        this.BattachBoard.setToolTipText(this.language.getString("MessageFrame.toolbar.tooltip.addBoardAttachments"));
        this.encrypt.setText(this.language.getString("MessageFrame.toolbar.encryptFor"));
        this.Lboard.setText(this.language.getString("MessageFrame.board") + ": ");
        this.Lfrom.setText(this.language.getString("MessageFrame.from") + ": ");
        this.Lsubject.setText(this.language.getString("MessageFrame.subject") + ": ");
        this.updateSignToolTip();
    }

    private void updateSignToolTip() {
        boolean isSelected = this.sign.isSelected();
        if (isSelected) {
            this.sign.setToolTipText(this.language.getString("MessagePane.toolbar.tooltip.isSigned"));
        } else {
            this.sign.setToolTipText(this.language.getString("MessagePane.toolbar.tooltip.isUnsigned"));
        }
    }

    protected void removeSelectedItemsFromTable(JTable tbl) {
        SortedTableModel m = (SortedTableModel)tbl.getModel();
        int[] sel = tbl.getSelectedRows();
        for (int x = sel.length - 1; x >= 0; --x) {
            m.removeRow(sel[x]);
        }
        this.positionDividers();
    }

    private void chooseSmiley_actionPerformed(ActionEvent e) {
        int y;
        SmileyChooserDialog dlg = new SmileyChooserDialog(this);
        int x = this.getX() + this.BchooseSmiley.getX();
        String chosedSmileyText = dlg.startDialog(x, y = this.getY() + this.BchooseSmiley.getY());
        if (chosedSmileyText != null && chosedSmileyText.length() > 0) {
            chosedSmileyText = chosedSmileyText + " ";
            try {
                Caret caret = this.messageTextArea.getCaret();
                int p0 = Math.min(caret.getDot(), caret.getMark());
                int p1 = Math.max(caret.getDot(), caret.getMark());
                Document document = this.messageTextArea.getDocument();
                if (document instanceof PlainDocument) {
                    ((PlainDocument)document).replace(p0, p1 - p0, chosedSmileyText, null);
                } else {
                    if (p0 != p1) {
                        document.remove(p0, p1 - p0);
                    }
                    document.insertString(p0, chosedSmileyText, null);
                }
            }
            catch (Throwable ble) {
                logger.log(Level.SEVERE, "Problem while pasting text.", ble);
            }
        }
        this.messageTextArea.requestFocusInWindow();
    }

    private void send_actionPerformed(ActionEvent e) {
        int x;
        int n;
        String from;
        LocalIdentity senderId = null;
        if (this.getOwnIdentitiesComboBox().getSelectedItem() instanceof LocalIdentity) {
            senderId = (LocalIdentity)this.getOwnIdentitiesComboBox().getSelectedItem();
            from = senderId.getUniqueName();
        } else {
            from = this.getOwnIdentitiesComboBox().getEditor().getItem().toString();
        }
        String subject = this.subjectTextField.getText().trim();
        this.subjectTextField.setText(subject);
        String text = this.messageTextArea.getText().trim();
        if (subject.equals("No subject") && (n = JOptionPane.showConfirmDialog(this, this.language.getString("MessageFrame.defaultSubjectWarning.text"), this.language.getString("MessageFrame.defaultSubjectWarning.title"), 0, 3)) == 0) {
            return;
        }
        if (subject.length() == 0) {
            JOptionPane.showMessageDialog(this, this.language.getString("MessageFrame.noSubjectError.text"), this.language.getString("MessageFrame.noSubjectError.title"), 64);
            return;
        }
        if (from.length() == 0) {
            JOptionPane.showMessageDialog(this, this.language.getString("MessageFrame.noSenderError.text"), this.language.getString("MessageFrame.noSenderError.title"), 64);
            return;
        }
        int maxTextLength = 61440;
        int msgSize = text.length() + subject.length() + from.length() + (this.repliedMsgId != null ? this.repliedMsgId.length() : 0);
        if (msgSize > 61440) {
            JOptionPane.showMessageDialog(this, this.language.formatMessage("MessageFrame.textTooLargeError.text", Integer.toString(text.length()), Integer.toString(61440)), this.language.getString("MessageFrame.textTooLargeError.title"), 0);
            return;
        }
        int idLinePos = this.headerArea.getStartPos();
        int idLineLen = this.headerArea.getEndPos() - this.headerArea.getStartPos();
        if (text.length() == this.headerArea.getEndPos()) {
            JOptionPane.showMessageDialog(this, this.language.getString("MessageFrame.noContentError.text"), this.language.getString("MessageFrame.noContentError.title"), 0);
            return;
        }
        if (from.indexOf("@") < 0) {
            this.frostSettings.setValue("userName", from);
        }
        this.frostSettings.setValue("userName." + this.board.getBoardFilename(), from);
        FrostUnsentMessageObject newMessage = new FrostUnsentMessageObject();
        newMessage.setMessageId(Mixed.createUniqueId());
        newMessage.setInReplyTo(this.repliedMsgId);
        newMessage.setBoard(this.board);
        newMessage.setFromName(from);
        newMessage.setSubject(subject);
        newMessage.setContent(text);
        newMessage.setIdLinePos(idLinePos);
        newMessage.setIdLineLen(idLineLen);
        if (this.filesTableModel.getRowCount() > 0) {
            for (x = 0; x < this.filesTableModel.getRowCount(); ++x) {
                MFAttachedFile af = (MFAttachedFile)this.filesTableModel.getRow(x);
                File aChosedFile = af.getFile();
                FileAttachment fa = new FileAttachment(aChosedFile);
                newMessage.addAttachment(fa);
            }
            newMessage.setHasFileAttachments(true);
        }
        if (this.boardsTableModel.getRowCount() > 0) {
            for (x = 0; x < this.boardsTableModel.getRowCount(); ++x) {
                MFAttachedBoard ab = (MFAttachedBoard)this.boardsTableModel.getRow(x);
                Board aChosedBoard = ab.getBoardObject();
                BoardAttachment ba = new BoardAttachment(aChosedBoard);
                newMessage.addAttachment(ba);
            }
            newMessage.setHasBoardAttachments(true);
        }
        Identity recipient = null;
        if (this.encrypt.isSelected()) {
            recipient = (Identity)this.buddies.getSelectedItem();
            if (recipient == null) {
                JOptionPane.showMessageDialog(this, this.language.getString("MessageFrame.encryptErrorNoRecipient.body"), this.language.getString("MessageFrame.encryptErrorNoRecipient.title"), 64);
                return;
            }
            newMessage.setRecipientName(recipient.getUniqueName());
        }
        UnsentMessagesManager.addNewUnsentMessage(newMessage);
        if (this.repliedMessage != null && !this.repliedMessage.isReplied()) {
            this.repliedMessage.setReplied(true);
            final FrostMessageObject saveMsg = this.repliedMessage;
            Thread saver = new Thread(){

                public void run() {
                    MessageStorage.inst().updateMessage(saveMsg);
                }
            };
            saver.start();
        }
        this.setVisible(false);
        this.dispose();
    }

    private void senderChanged(LocalIdentity selectedId) {
        boolean isSigned = selectedId != null;
        this.sign.setSelected(isSigned);
        if (isSigned) {
            if (this.buddies.getItemCount() > 0) {
                this.encrypt.setEnabled(true);
                if (this.encrypt.isSelected()) {
                    this.buddies.setEnabled(true);
                } else {
                    this.buddies.setEnabled(false);
                }
            }
            this.removeSignatureFromText(this.currentSignature);
            this.currentSignature = this.addSignatureToText(selectedId.getSignature());
        } else {
            this.encrypt.setSelected(false);
            this.encrypt.setEnabled(false);
            this.buddies.setEnabled(false);
            this.removeSignatureFromText(this.currentSignature);
            this.currentSignature = null;
        }
    }

    private String addSignatureToText(String sig) {
        if (sig == null) {
            return null;
        }
        String newSig = "\n-- \n" + sig;
        if (!this.messageTextArea.getText().endsWith(newSig)) {
            try {
                this.messageTextArea.getDocument().insertString(this.messageTextArea.getText().length(), newSig, null);
            }
            catch (BadLocationException e1) {
                logger.log(Level.SEVERE, "Error while updating the signature ", e1);
            }
        }
        return newSig;
    }

    private void removeSignatureFromText(String sig) {
        if (sig == null) {
            return;
        }
        if (this.messageTextArea.getText().endsWith(sig)) {
            try {
                this.messageTextArea.getDocument().remove(this.messageTextArea.getText().length() - sig.length(), sig.length());
            }
            catch (BadLocationException e1) {
                logger.log(Level.SEVERE, "Error while updating the signature ", e1);
            }
        }
    }

    private void encrypt_actionPerformed(ActionEvent e) {
        if (this.encrypt.isSelected()) {
            this.buddies.setEnabled(true);
        } else {
            this.buddies.setEnabled(false);
        }
    }

    protected void updateHeaderArea(String sender) {
        if (!this.headerArea.isEnabled()) {
            return;
        }
        if (sender == null || this.oldSender == null || this.oldSender.equals(sender)) {
            return;
        }
        try {
            this.headerArea.setEnabled(false);
            this.messageTextArea.getDocument().remove(this.headerArea.getStartPos() + 6, this.oldSender.length());
            this.messageTextArea.getDocument().insertString(this.headerArea.getStartPos() + 6, sender, null);
            this.oldSender = sender;
            this.headerArea.setEnabled(true);
        }
        catch (BadLocationException exception) {
            logger.log(Level.SEVERE, "Error while updating the message header", exception);
        }
    }

    private JComboBox getOwnIdentitiesComboBox() {
        if (this.ownIdentitiesComboBox == null) {
            this.ownIdentitiesComboBox = new JComboBox();
            this.ownIdentitiesComboBox.addItem("Anonymous");
            TreeMap<String, LocalIdentity> sortedIds = new TreeMap<String, LocalIdentity>();
            Iterator<LocalIdentity> i$ = Core.getIdentities().getLocalIdentities().iterator();
            while (i$.hasNext()) {
                LocalIdentity element;
                LocalIdentity li = element = i$.next();
                sortedIds.put(li.getUniqueName(), li);
            }
            for (LocalIdentity element : sortedIds.values()) {
                this.ownIdentitiesComboBox.addItem(element);
            }
            TextComboBoxEditor editor = new TextComboBoxEditor();
            editor.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    this.updateHeaderArea2();
                }

                public void insertUpdate(DocumentEvent e) {
                    this.updateHeaderArea2();
                }

                public void removeUpdate(DocumentEvent e) {
                    this.updateHeaderArea2();
                }

                private void updateHeaderArea2() {
                    String sender = MessageFrame.this.getOwnIdentitiesComboBox().getEditor().getItem().toString();
                    MessageFrame.this.updateHeaderArea(sender);
                }
            });
            AbstractDocument doc = (AbstractDocument)editor.getDocument();
            doc.setDocumentFilter(new DocumentFilter(){

                public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                    if (!((TextComboBoxEditor)MessageFrame.this.getOwnIdentitiesComboBox().getEditor()).isSigned()) {
                        string = string.replaceAll("@", "");
                    }
                    super.insertString(fb, offset, string, attr);
                }

                public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String string, AttributeSet attrs) throws BadLocationException {
                    if (!((TextComboBoxEditor)MessageFrame.this.getOwnIdentitiesComboBox().getEditor()).isSigned()) {
                        string = string.replaceAll("@", "");
                    }
                    super.replace(fb, offset, length, string, attrs);
                }
            });
            this.ownIdentitiesComboBox.setEditor(editor);
            this.ownIdentitiesComboBox.setEditable(true);
            this.ownIdentitiesComboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        return;
                    }
                    LocalIdentity selectedId = null;
                    if (MessageFrame.this.ownIdentitiesComboBox.getSelectedIndex() == 0) {
                        MessageFrame.this.ownIdentitiesComboBox.setEditable(true);
                    } else if (MessageFrame.this.ownIdentitiesComboBox.getSelectedIndex() < 0) {
                        MessageFrame.this.ownIdentitiesComboBox.setEditable(true);
                    } else {
                        MessageFrame.this.ownIdentitiesComboBox.setEditable(false);
                        selectedId = (LocalIdentity)MessageFrame.this.ownIdentitiesComboBox.getSelectedItem();
                    }
                    String sender = MessageFrame.this.getOwnIdentitiesComboBox().getSelectedItem().toString();
                    MessageFrame.this.updateHeaderArea(sender);
                    MessageFrame.this.senderChanged(selectedId);
                }
            });
        }
        return this.ownIdentitiesComboBox;
    }

    public static synchronized int getOpenInstanceCount() {
        return openInstanceCount;
    }

    private static synchronized void incOpenInstanceCount() {
        ++openInstanceCount;
    }

    private static synchronized void decOpenInstanceCount() {
        if (openInstanceCount > 0) {
            --openInstanceCount;
        }
    }

    private class TransferObject {
        public Board newBoard;
        public String newSubject;
        public String inReplyTo;
        public String newText;
        public boolean isReply;
        public Identity recipient = null;
        public LocalIdentity senderId = null;

        private TransferObject() {
        }
    }

    private class MFAttachedFilesTableModel
    extends SortedTableModel {
        protected final Class[] columnClasses = new Class[]{String.class, String.class};
        protected final String[] columnNames = new String[]{MessageFrame.access$2200(MessageFrame.this).getString("MessageFrame.fileAttachmentTable.filename"), MessageFrame.access$2200(MessageFrame.this).getString("MessageFrame.fileAttachmentTable.size")};

        public Class getColumnClass(int column) {
            if (column >= 0 && column < this.columnClasses.length) {
                return this.columnClasses[column];
            }
            return null;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int column) {
            if (column >= 0 && column < this.columnNames.length) {
                return this.columnNames[column];
            }
            return null;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void setValueAt(Object aValue, int row, int column) {
        }
    }

    private class MFAttachedFilesTable
    extends SortedTable {
        public MFAttachedFilesTable(MFAttachedFilesTableModel m) {
            super(m);
            int[] widths = new int[]{250, 80};
            for (int i = 0; i < widths.length; ++i) {
                this.getColumnModel().getColumn(i).setPreferredWidth(widths[i]);
            }
            this.sortedColumnIndex = 0;
            this.sortedColumnAscending = true;
            this.resortTable();
        }
    }

    private class MFAttachedFile
    implements TableMember {
        File aFile;

        public MFAttachedFile(File af) {
            this.aFile = af;
        }

        public int compareTo(TableMember anOther, int tableColumIndex) {
            Comparable c1 = (Comparable)this.getValueAt(tableColumIndex);
            Comparable c2 = (Comparable)anOther.getValueAt(tableColumIndex);
            return c1.compareTo(c2);
        }

        public File getFile() {
            return this.aFile;
        }

        public Object getValueAt(int column) {
            switch (column) {
                case 0: {
                    return this.aFile.getName();
                }
                case 1: {
                    return Long.toString(this.aFile.length());
                }
            }
            return "*ERR*";
        }
    }

    private class MFAttachedBoardsTableModel
    extends SortedTableModel {
        protected final Class[] columnClasses = new Class[]{String.class, String.class, String.class, String.class};
        protected final String[] columnNames = new String[]{MessageFrame.access$2200(MessageFrame.this).getString("MessageFrame.boardAttachmentTable.boardname"), MessageFrame.access$2200(MessageFrame.this).getString("MessageFrame.boardAttachmentTable.publicKey"), MessageFrame.access$2200(MessageFrame.this).getString("MessageFrame.boardAttachmentTable.privateKey"), MessageFrame.access$2200(MessageFrame.this).getString("MessageFrame.boardAttachmentTable.description")};

        public Class getColumnClass(int column) {
            if (column >= 0 && column < this.columnClasses.length) {
                return this.columnClasses[column];
            }
            return null;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int column) {
            if (column >= 0 && column < this.columnNames.length) {
                return this.columnNames[column];
            }
            return null;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void setValueAt(Object aValue, int row, int column) {
        }
    }

    private class MFAttachedBoardsTable
    extends SortedTable {
        public MFAttachedBoardsTable(MFAttachedBoardsTableModel m) {
            super(m);
            int[] widths = new int[]{250, 80, 80};
            for (int i = 0; i < widths.length; ++i) {
                this.getColumnModel().getColumn(i).setPreferredWidth(widths[i]);
            }
            this.sortedColumnIndex = 0;
            this.sortedColumnAscending = true;
            this.resortTable();
        }
    }

    private class MFAttachedBoard
    implements TableMember {
        Board aBoard;

        public MFAttachedBoard(Board ab) {
            this.aBoard = ab;
        }

        public int compareTo(TableMember anOther, int tableColumIndex) {
            Comparable c1 = (Comparable)this.getValueAt(tableColumIndex);
            Comparable c2 = (Comparable)anOther.getValueAt(tableColumIndex);
            return c1.compareTo(c2);
        }

        public Board getBoardObject() {
            return this.aBoard;
        }

        public Object getValueAt(int column) {
            switch (column) {
                case 0: {
                    return this.aBoard.getName();
                }
                case 1: {
                    return this.aBoard.getPublicKey() == null ? "N/A" : this.aBoard.getPublicKey();
                }
                case 2: {
                    return this.aBoard.getPrivateKey() == null ? "N/A" : this.aBoard.getPrivateKey();
                }
                case 3: {
                    return this.aBoard.getDescription() == null ? "N/A" : this.aBoard.getDescription();
                }
            }
            return "*ERR*";
        }
    }

    private class MessageBodyPopupMenu
    extends JSkinnablePopupMenu
    implements ActionListener,
    ClipboardOwner {
        private Clipboard clipboard;
        private final JTextComponent sourceTextComponent;
        private final JMenuItem cutItem = new JMenuItem();
        private final JMenuItem copyItem = new JMenuItem();
        private final JMenuItem pasteItem = new JMenuItem();
        private final JMenuItem cancelItem = new JMenuItem();

        public MessageBodyPopupMenu(JTextComponent sourceTextComponent) {
            this.sourceTextComponent = sourceTextComponent;
            this.initialize();
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.cutItem) {
                this.cutSelectedText();
            }
            if (e.getSource() == this.copyItem) {
                this.copySelectedText();
            }
            if (e.getSource() == this.pasteItem) {
                this.pasteText();
            }
        }

        private void copySelectedText() {
            StringSelection selection = new StringSelection(this.sourceTextComponent.getSelectedText());
            this.clipboard.setContents(selection, this);
        }

        private void cutSelectedText() {
            StringSelection selection = new StringSelection(this.sourceTextComponent.getSelectedText());
            this.clipboard.setContents(selection, this);
            int start = this.sourceTextComponent.getSelectionStart();
            int end = this.sourceTextComponent.getSelectionEnd();
            try {
                this.sourceTextComponent.getDocument().remove(start, end - start);
            }
            catch (BadLocationException ble) {
                logger.log(Level.SEVERE, "Problem while cutting text.", ble);
            }
        }

        private void pasteText() {
            Transferable clipboardContent = this.clipboard.getContents(this);
            try {
                String text = (String)clipboardContent.getTransferData(DataFlavor.stringFlavor);
                Caret caret = this.sourceTextComponent.getCaret();
                int p0 = Math.min(caret.getDot(), caret.getMark());
                int p1 = Math.max(caret.getDot(), caret.getMark());
                Document document = this.sourceTextComponent.getDocument();
                if (document instanceof PlainDocument) {
                    ((PlainDocument)document).replace(p0, p1 - p0, text, null);
                } else {
                    if (p0 != p1) {
                        document.remove(p0, p1 - p0);
                    }
                    document.insertString(p0, text, null);
                }
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, "Problem while pasting text.", ioe);
            }
            catch (UnsupportedFlavorException ufe) {
                logger.log(Level.SEVERE, "Problem while pasting text.", ufe);
            }
            catch (BadLocationException ble) {
                logger.log(Level.SEVERE, "Problem while pasting text.", ble);
            }
        }

        private void initialize() {
            this.refreshLanguage();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.clipboard = toolkit.getSystemClipboard();
            this.cutItem.addActionListener(this);
            this.copyItem.addActionListener(this);
            this.pasteItem.addActionListener(this);
            this.add(this.cutItem);
            this.add(this.copyItem);
            this.add(this.pasteItem);
            this.addSeparator();
            this.add(this.cancelItem);
        }

        private void refreshLanguage() {
            this.cutItem.setText(MessageFrame.this.language.getString("Common.cut"));
            this.copyItem.setText(MessageFrame.this.language.getString("Common.copy"));
            this.pasteItem.setText(MessageFrame.this.language.getString("Common.paste"));
            this.cancelItem.setText(MessageFrame.this.language.getString("Common.cancel"));
        }

        public void lostOwnership(Clipboard nclipboard, Transferable contents) {
        }

        public void show(Component invoker, int x, int y) {
            if (this.sourceTextComponent.getSelectedText() != null) {
                this.cutItem.setEnabled(true);
                this.copyItem.setEnabled(true);
            } else {
                this.cutItem.setEnabled(false);
                this.copyItem.setEnabled(false);
            }
            Transferable clipboardContent = this.clipboard.getContents(this);
            if (clipboardContent != null && clipboardContent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                this.pasteItem.setEnabled(true);
            } else {
                this.pasteItem.setEnabled(false);
            }
            super.show(invoker, x, y);
        }
    }

    private class Listener
    implements MouseListener,
    LanguageListener {
        private Listener() {
        }

        protected void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (e.getSource() == MessageFrame.this.boardsTable) {
                    MessageFrame.this.attBoardsPopupMenu.show(MessageFrame.this.boardsTable, e.getX(), e.getY());
                }
                if (e.getSource() == MessageFrame.this.filesTable) {
                    MessageFrame.this.attFilesPopupMenu.show(MessageFrame.this.filesTable, e.getX(), e.getY());
                }
                if (e.getSource() == MessageFrame.this.messageTextArea) {
                    MessageFrame.this.getMessageBodyPopupMenu().show(MessageFrame.this.messageTextArea, e.getX(), e.getY());
                }
            }
        }

        public void mouseClicked(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }

        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        public void languageChanged(LanguageEvent event) {
            MessageFrame.this.refreshLanguage();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BuddyComparator
    implements Comparator<Identity> {
        BuddyComparator() {
        }

        @Override
        public int compare(Identity id1, Identity id2) {
            String s1 = id1.getUniqueName();
            String s2 = id2.getUniqueName();
            return s1.toLowerCase().compareTo(s2.toLowerCase());
        }
    }

    class TextComboBoxEditor
    extends JTextField
    implements ComboBoxEditor {
        boolean isSigned;

        public Component getEditorComponent() {
            return this;
        }

        public void setItem(Object arg0) {
            this.isSigned = arg0 instanceof LocalIdentity;
            this.setText(arg0.toString());
        }

        public Object getItem() {
            return this.getText();
        }

        public boolean isSigned() {
            return this.isSigned;
        }
    }
}

