/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class ScrollableBar
extends JComponent
implements SwingConstants {
    private Component comp;
    private boolean horizontal;
    private boolean small;
    private int inc;

    public ScrollableBar(Component comp) {
        this(comp, 0);
    }

    public ScrollableBar(Component comp, int orientation) {
        this.comp = comp;
        this.horizontal = orientation == 0;
        this.small = true;
        this.inc = 10;
        this.updateUI();
    }

    public String getUIClassID() {
        return "ScrollableBarUI";
    }

    public void updateUI() {
        this.setUI(UIManager.getUI(this));
        this.invalidate();
    }

    public Component getComponent() {
        return this.comp;
    }

    public void setComponent(Component comp) {
        if (this.comp != comp) {
            Component old = this.comp;
            this.comp = comp;
            this.firePropertyChange("component", old, comp);
        }
    }

    public int getIncrement() {
        return this.inc;
    }

    public void setIncrement(int inc) {
        if (inc > 0 && inc != this.inc) {
            int old = this.inc;
            this.inc = inc;
            this.firePropertyChange("increment", old, inc);
        }
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public boolean isSmallArrows() {
        return this.small;
    }

    public void setSmallArrows(boolean small) {
        if (small != this.small) {
            boolean old = this.small;
            this.small = small;
            this.firePropertyChange("smallArrows", old, small);
        }
    }

    static {
        UIManager.put("ScrollableBarUI", "frost.gui.ScrollableBarUI");
    }
}

