/*
 * Decompiled with CFR 0.152.
 */
package frost.gui;

import frost.util.gui.SmileyCache;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SmileyChooserDialog
extends JDialog {
    Language language = Language.getInstance();
    String returnValue = null;

    public SmileyChooserDialog(JDialog parent) {
        super((Dialog)parent, true);
        this.initialize();
    }

    public SmileyChooserDialog(JFrame parent) {
        super((Frame)parent, true);
        this.initialize();
    }

    public void initialize() {
        this.setDefaultCloseOperation(2);
        this.setTitle(this.language.getString("SmileyChooserDialog.title"));
        JPanel p = new JPanel();
        int count = SmileyCache.getSmileyCount();
        int maxCols = 5;
        int numRows = count / 5 + 1;
        p.setLayout(new GridLayout(numRows, 5, 6, 6));
        Listener l = new Listener();
        for (int i = 1; i < count; ++i) {
            SmileyImage si = new SmileyImage(SmileyCache.getCachedSmiley(i), SmileyCache.getSmileyText(i));
            si.addMouseListener(l);
            p.add(si);
        }
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.getContentPane().add((Component)p, "Center");
        this.pack();
    }

    private void iconChoosed(String iconText) {
        this.returnValue = iconText;
        this.dispose();
    }

    public String startDialog(int x, int y) {
        this.setLocation(x - this.getWidth(), y);
        this.setVisible(true);
        return this.returnValue;
    }

    protected class Listener
    implements MouseListener {
        protected Listener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getSource() instanceof SmileyImage) {
                SmileyImage si = (SmileyImage)e.getSource();
                SmileyChooserDialog.this.iconChoosed(si.getSmileyText());
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    protected class SmileyImage
    extends JLabel {
        String smileyText;

        public SmileyImage(ImageIcon i, String s) {
            super(i);
            this.smileyText = s;
        }

        public String getSmileyText() {
            return this.smileyText;
        }
    }
}

