/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.help;

import frost.Core;
import frost.MainFrame;
import frost.gui.help.HelpBrowser;
import frost.util.gui.MiscToolkit;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;

public class HelpBrowserFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(HelpBrowserFrame.class.getName());
    boolean plugin;
    HelpBrowser browser;

    private void Init() throws Exception {
        this.setTitle("Frost - Help Browser");
        this.setResizable(true);
        this.browser.setPreferredSize(new Dimension(780, 550));
        this.getContentPane().add(this.browser);
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            if (!this.plugin) {
                this.dispose();
                System.exit(0);
            } else {
                this.saveWindowState();
                this.setVisible(false);
            }
        } else {
            super.processWindowEvent(e);
        }
    }

    public HelpBrowserFrame(String langlocale, String zipfile) {
        this(langlocale, "jar:file:" + zipfile + "!/", "index.html", true);
    }

    public HelpBrowserFrame(String langlocale, String zipfile, String startpage, boolean plugin) {
        this.plugin = plugin;
        this.browser = new HelpBrowser(this, langlocale, zipfile, startpage);
        this.setIconImage(MiscToolkit.loadImageIcon("/data/toolbar/help-browser.png").getImage());
        this.enableEvents(64L);
        try {
            this.Init();
            if (!plugin) {
                this.setSize(new Dimension(780, 550));
            } else {
                this.loadWindowState();
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Exception thrown in constructor", e);
        }
    }

    public void showHelpPage(String page) {
        this.browser.setHelpPage(page);
    }

    public void showHelpPage_htmlLink(String page) {
        this.browser.setHelpPage(page);
    }

    public void showHelpPage_alias(String page) {
        this.browser.setHelpPage(page);
    }

    private void saveWindowState() {
        Rectangle bounds = this.getBounds();
        boolean isMaximized = (this.getExtendedState() & 6) != 0;
        Core.frostSettings.setValue("helpBrowser.lastFrameMaximized", isMaximized);
        if (!isMaximized) {
            Core.frostSettings.setValue("helpBrowser.lastFrameHeight", bounds.height);
            Core.frostSettings.setValue("helpBrowser.lastFrameWidth", bounds.width);
            Core.frostSettings.setValue("helpBrowser.lastFramePosX", bounds.x);
            Core.frostSettings.setValue("helpBrowser.lastFramePosY", bounds.y);
        }
    }

    private void loadWindowState() {
        int lastHeight = Core.frostSettings.getIntValue("helpBrowser.lastFrameHeight");
        int lastWidth = Core.frostSettings.getIntValue("helpBrowser.lastFrameWidth");
        int lastPosX = Core.frostSettings.getIntValue("helpBrowser.lastFramePosX");
        int lastPosY = Core.frostSettings.getIntValue("helpBrowser.lastFramePosY");
        boolean lastMaximized = Core.frostSettings.getBoolValue("helpBrowser.lastFrameMaximized");
        if (lastHeight <= 0 || lastWidth <= 0) {
            this.setSize(780, 550);
            this.setLocationRelativeTo(MainFrame.getInstance());
            return;
        }
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (lastWidth < 100) {
            lastWidth = 780;
        }
        if (lastHeight < 100) {
            lastHeight = 550;
        }
        if (lastPosX + lastWidth > scrSize.width) {
            this.setSize(780, 550);
            this.setLocationRelativeTo(MainFrame.getInstance());
            return;
        }
        if (lastPosY + lastHeight > scrSize.height) {
            this.setSize(780, 550);
            this.setLocationRelativeTo(MainFrame.getInstance());
            return;
        }
        this.setBounds(lastPosX, lastPosY, lastWidth, lastHeight);
        if (lastMaximized) {
            this.setExtendedState(this.getExtendedState() | 6);
        }
    }
}

