/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.model;

import frost.gui.SortedTable;
import frost.gui.model.TableMember;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Logger;
import javax.swing.table.DefaultTableModel;

public class SortedTableModel
extends DefaultTableModel {
    private static final Logger logger = Logger.getLogger(SortedTableModel.class.getName());
    private boolean bWasResized = false;
    private ArrayList rows = null;
    private SortedTable parentTable = null;
    private ColumnComparator colComparator = new ColumnComparator(0, true);

    public SortedTableModel() {
        this.rows = new ArrayList();
    }

    public void setParentTable(SortedTable t) {
        this.parentTable = t;
    }

    public boolean isSortable(int col) {
        return true;
    }

    public int getRowCount() {
        if (this.rows == null) {
            return 0;
        }
        return this.rows.size();
    }

    public void sortModelColumn(int col, boolean ascending) {
        this.sortColumn(col, ascending);
    }

    private void sortColumn(int col, boolean ascending) {
        this.colComparator = new ColumnComparator(col, ascending);
        if (this.rows.size() > 1) {
            Collections.sort(this.rows, this.colComparator);
        }
    }

    public void addRow(TableMember member) {
        int insertPos = Collections.binarySearch(this.rows, member, this.colComparator);
        if (insertPos < 0) {
            insertPos = (insertPos + 1) * -1;
        } else {
            insertPos = Collections.lastIndexOfSubList(this.rows, Collections.singletonList(this.rows.get(insertPos)));
            ++insertPos;
        }
        this.insertRowAt(member, insertPos);
    }

    public void insertRowAt(TableMember member, int index) {
        if (index <= this.rows.size()) {
            this.rows.add(index, member);
            this.fireTableRowsInserted(index, index);
        }
    }

    public void deleteRow(TableMember obj) {
        if (obj != null) {
            int i = this.rows.indexOf(obj);
            this.rows.remove(obj);
            if (i != -1) {
                this.fireTableRowsDeleted(i, i);
            }
        }
    }

    public void updateRow(TableMember obj) {
        int i;
        if (obj != null && (i = this.rows.indexOf(obj)) != -1) {
            this.fireTableRowsUpdated(i, i);
            this.resortTable();
        }
    }

    private void resortTable() {
        if (this.parentTable != null) {
            this.parentTable.resortTable();
        }
    }

    public TableMember getRow(int row) {
        Object obj;
        if (row < this.getRowCount() && (obj = this.rows.get(row)) instanceof TableMember) {
            return (TableMember)obj;
        }
        return null;
    }

    public void removeRow(int row) {
        Object obj;
        if (row < this.getRowCount() && (obj = this.rows.get(row)) instanceof TableMember) {
            this.deleteRow((TableMember)obj);
        }
    }

    public Object getValueAt(int row, int column) {
        if (row >= this.getRowCount() || row < 0) {
            return null;
        }
        TableMember obj = (TableMember)this.rows.get(row);
        if (obj == null) {
            return null;
        }
        return obj.getValueAt(column);
    }

    public void clearDataModel() {
        int size = this.rows.size();
        if (size > 0) {
            this.rows = new ArrayList();
            this.fireTableRowsDeleted(0, size);
        }
    }

    public void tableEntriesChanged() {
        this.fireTableRowsUpdated(0, this.getRowCount());
    }

    public void tableEntriesChanged(int from, int to) {
        this.fireTableRowsUpdated(from, to);
    }

    public void setValueAt(Object aValue, int row, int column) {
        logger.severe("setValueAt() - ERROR: NOT IMPLEMENTED");
    }

    public boolean wasResized() {
        return this.bWasResized;
    }

    public void setResized(boolean newValue) {
        this.bWasResized = newValue;
    }

    public class ColumnComparator
    implements Comparator {
        protected int index;
        protected boolean ascending;

        public ColumnComparator(int index, boolean ascending) {
            this.index = index;
            this.ascending = ascending;
        }

        public int compare(Object one, Object two) {
            try {
                TableMember oOne = (TableMember)one;
                TableMember oTwo = (TableMember)two;
                if (this.ascending) {
                    return oOne.compareTo(oTwo, this.index);
                }
                return oTwo.compareTo(oOne, this.index);
            }
            catch (Exception exception) {
                return 1;
            }
        }
    }
}

