/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.SettingsClass;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class SearchPanel
extends JPanel {
    private SettingsClass settings = null;
    private Language language = null;
    private JLabel archiveExtensionLabel = new JLabel();
    private JTextField archiveExtensionTextField = new JTextField();
    private JLabel audioExtensionLabel = new JLabel();
    private JTextField audioExtensionTextField = new JTextField();
    private JLabel documentExtensionLabel = new JLabel();
    private JTextField documentExtensionTextField = new JTextField();
    private JLabel executableExtensionLabel = new JLabel();
    private JTextField executableExtensionTextField = new JTextField();
    private JLabel imageExtensionLabel = new JLabel();
    private JTextField imageExtensionTextField = new JTextField();
    private JLabel maxSearchResultsLabel = new JLabel();
    private JTextField maxSearchResultsTextField = new JTextField(8);
    private JLabel videoExtensionLabel = new JLabel();
    private JTextField videoExtensionTextField = new JTextField();
    private JCheckBox disableFilesharingCheckBox = new JCheckBox();
    private JCheckBox rememberSharedFileDownloadedCheckBox = new JCheckBox();

    protected SearchPanel(SettingsClass settings) {
        this.language = Language.getInstance();
        this.settings = settings;
        this.initialize();
        this.loadSettings();
    }

    private void initialize() {
        this.setName("SearchPanel");
        this.setLayout(new GridBagLayout());
        this.refreshLanguage();
        new TextComponentClipboardMenu(this.archiveExtensionTextField, this.language);
        new TextComponentClipboardMenu(this.audioExtensionTextField, this.language);
        new TextComponentClipboardMenu(this.documentExtensionTextField, this.language);
        new TextComponentClipboardMenu(this.executableExtensionTextField, this.language);
        new TextComponentClipboardMenu(this.imageExtensionTextField, this.language);
        new TextComponentClipboardMenu(this.maxSearchResultsTextField, this.language);
        new TextComponentClipboardMenu(this.videoExtensionTextField, this.language);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 5, 5, 5);
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        this.add((Component)this.imageExtensionLabel, constraints);
        constraints.weightx = 1.0;
        constraints.gridx = 1;
        this.add((Component)this.imageExtensionTextField, constraints);
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        this.add((Component)this.videoExtensionLabel, constraints);
        constraints.weightx = 1.0;
        constraints.gridx = 1;
        this.add((Component)this.videoExtensionTextField, constraints);
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        this.add((Component)this.archiveExtensionLabel, constraints);
        constraints.weightx = 1.0;
        constraints.gridx = 1;
        this.add((Component)this.archiveExtensionTextField, constraints);
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        this.add((Component)this.documentExtensionLabel, constraints);
        constraints.weightx = 1.0;
        constraints.gridx = 1;
        this.add((Component)this.documentExtensionTextField, constraints);
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        this.add((Component)this.audioExtensionLabel, constraints);
        constraints.weightx = 1.0;
        constraints.gridx = 1;
        this.add((Component)this.audioExtensionTextField, constraints);
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        this.add((Component)this.executableExtensionLabel, constraints);
        constraints.weightx = 1.0;
        constraints.gridx = 1;
        this.add((Component)this.executableExtensionTextField, constraints);
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        this.add((Component)this.maxSearchResultsLabel, constraints);
        constraints.fill = 0;
        constraints.gridx = 1;
        this.add((Component)this.maxSearchResultsTextField, constraints);
        ++constraints.gridy;
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        this.add((Component)this.disableFilesharingCheckBox, constraints);
        ++constraints.gridy;
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        this.add((Component)this.rememberSharedFileDownloadedCheckBox, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 2;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.add((Component)new JLabel(""), constraints);
    }

    private void loadSettings() {
        this.audioExtensionTextField.setText(this.settings.getValue("audioExtension"));
        this.imageExtensionTextField.setText(this.settings.getValue("imageExtension"));
        this.videoExtensionTextField.setText(this.settings.getValue("videoExtension"));
        this.documentExtensionTextField.setText(this.settings.getValue("documentExtension"));
        this.executableExtensionTextField.setText(this.settings.getValue("executableExtension"));
        this.archiveExtensionTextField.setText(this.settings.getValue("archiveExtension"));
        this.maxSearchResultsTextField.setText(Integer.toString(this.settings.getIntValue("maxSearchResults")));
        this.disableFilesharingCheckBox.setSelected(this.settings.getBoolValue("disableFilesharing"));
        this.rememberSharedFileDownloadedCheckBox.setSelected(this.settings.getBoolValue("rememberSharedFileDownloaded"));
    }

    public void ok() {
        this.saveSettings();
    }

    private void refreshLanguage() {
        this.imageExtensionLabel.setText(this.language.getString("Options.search.imageExtension"));
        this.videoExtensionLabel.setText(this.language.getString("Options.search.videoExtension"));
        this.archiveExtensionLabel.setText(this.language.getString("Options.search.archiveExtension"));
        this.documentExtensionLabel.setText(this.language.getString("Options.search.documentExtension"));
        this.audioExtensionLabel.setText(this.language.getString("Options.search.audioExtension"));
        this.executableExtensionLabel.setText(this.language.getString("Options.search.executableExtension"));
        this.maxSearchResultsLabel.setText(this.language.getString("Options.search.maximumSearchResults"));
        this.disableFilesharingCheckBox.setText(this.language.getString("Options.search.disableFilesharing"));
        this.rememberSharedFileDownloadedCheckBox.setText(this.language.getString("Options.search.rememberSharedFileDownloaded"));
    }

    private void saveSettings() {
        this.settings.setValue("audioExtension", this.audioExtensionTextField.getText().toLowerCase());
        this.settings.setValue("imageExtension", this.imageExtensionTextField.getText().toLowerCase());
        this.settings.setValue("videoExtension", this.videoExtensionTextField.getText().toLowerCase());
        this.settings.setValue("documentExtension", this.documentExtensionTextField.getText().toLowerCase());
        this.settings.setValue("executableExtension", this.executableExtensionTextField.getText().toLowerCase());
        this.settings.setValue("archiveExtension", this.archiveExtensionTextField.getText().toLowerCase());
        this.settings.setValue("maxSearchResults", this.maxSearchResultsTextField.getText());
        this.settings.setValue("disableFilesharing", this.disableFilesharingCheckBox.isSelected());
        this.settings.setValue("rememberSharedFileDownloaded", this.rememberSharedFileDownloadedCheckBox.isSelected());
    }
}

