/*
 * Decompiled with CFR 0.152.
 */
package frost.storage;

import frost.Frost;
import frost.SettingsClass;
import frost.events.FrostEventDispatcher;
import frost.events.StorageErrorEvent;
import frost.storage.AutoSavable;
import frost.storage.ExitSavable;
import frost.storage.StorageException;
import frost.util.Logging;
import frost.util.gui.translation.Language;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StorageManager
extends Timer {
    private static final Logger logger = Logger.getLogger(StorageManager.class.getName());
    private final Language language;
    private final FrostEventDispatcher listener;
    private final ShutdownThread shutdownThread = new ShutdownThread();
    private final AutoTask autoTask = new AutoTask();
    private final Vector<AutoSavable> autoSavables = new Vector();
    private final Vector<ExitSavable> exitSavables = new Vector();

    public StorageManager(SettingsClass frostSettings, FrostEventDispatcher listener) {
        this.language = Language.getInstance();
        this.listener = listener;
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        int autoSaveIntervalMinutes = frostSettings.getIntValue("autoSaveInterval");
        this.schedule((TimerTask)this.autoTask, (long)autoSaveIntervalMinutes * 60L * 1000L, (long)autoSaveIntervalMinutes * 60L * 1000L);
    }

    public synchronized void addAutoSavable(AutoSavable autoSavable) {
        if (autoSavable == null) {
            return;
        }
        this.autoSavables.addElement(autoSavable);
    }

    public synchronized void addExitSavable(ExitSavable exitSavable) {
        if (exitSavable == null) {
            return;
        }
        this.exitSavables.addElement(exitSavable);
    }

    private class ShutdownThread
    extends Thread {
        public void run() {
            logger.info("Saving ...");
            if (StorageManager.this.exitSavables != null) {
                for (ExitSavable savable : StorageManager.this.exitSavables) {
                    try {
                        savable.exitSave();
                    }
                    catch (Throwable se) {
                        logger.log(Level.SEVERE, "Error while saving a resource inside the shutdown hook.", se);
                    }
                }
            }
            String goodbyeMsg = "Frost shutdown completed.";
            logger.severe("Frost shutdown completed.");
            System.out.println("Frost shutdown completed.");
            Logging.inst().shutdownLogging();
            Frost.releaseLockFile();
        }
    }

    private class AutoTask
    extends TimerTask {
        public void run() {
            if (StorageManager.this.autoSavables != null) {
                for (AutoSavable savable : StorageManager.this.autoSavables) {
                    try {
                        savable.autoSave();
                    }
                    catch (StorageException se) {
                        logger.log(Level.SEVERE, "Error while saving a resource inside the timer.", se);
                        StorageErrorEvent errorEvent = new StorageErrorEvent(StorageManager.this.language.getString("Saver.AutoTask.message"));
                        errorEvent.setException(se);
                        StorageManager.this.listener.dispatchEvent(errorEvent);
                    }
                }
                System.gc();
            }
        }
    }
}

