/*
 * Decompiled with CFR 0.152.
 */
package frost.storage.perst;

import frost.boards.Board;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.fileTransfer.sharing.FrostSharedFileItem;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.gui.KnownBoard;
import frost.storage.ExitSavable;
import frost.storage.StorageException;
import frost.storage.perst.AbstractFrostStorage;
import frost.storage.perst.FrostFilesStorageRoot;
import frost.storage.perst.NewUploadFile;
import frost.storage.perst.PerstFrostDownloadItem;
import frost.storage.perst.PerstFrostSharedFileItem;
import frost.storage.perst.PerstFrostUploadItem;
import frost.storage.perst.PerstHiddenBoardName;
import frost.storage.perst.PerstKnownBoard;
import frost.util.gui.translation.Language;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.garret.perst.IPersistentList;
import org.garret.perst.Persistent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrostFilesStorage
extends AbstractFrostStorage
implements ExitSavable {
    private static final Logger logger = Logger.getLogger(FrostFilesStorage.class.getName());
    private static final String STORAGE_FILENAME = "filesStore.dbs";
    private FrostFilesStorageRoot storageRoot = null;
    private static FrostFilesStorage instance = new FrostFilesStorage();

    protected FrostFilesStorage() {
    }

    public static FrostFilesStorage inst() {
        return instance;
    }

    @Override
    public String getStorageFilename() {
        return STORAGE_FILENAME;
    }

    @Override
    public boolean initStorage() {
        String databaseFilePath = this.buildStoragePath(this.getStorageFilename());
        int pagePoolSize = this.getPagePoolSize("perst.pagepoolsizeKiB.files");
        this.open(databaseFilePath, pagePoolSize, true, true, false);
        this.storageRoot = (FrostFilesStorageRoot)this.getStorage().getRoot();
        if (this.storageRoot == null) {
            this.storageRoot = new FrostFilesStorageRoot();
            this.storageRoot.downloadFiles = this.getStorage().createScalableList();
            this.storageRoot.uploadFiles = this.getStorage().createScalableList();
            this.storageRoot.sharedFiles = this.getStorage().createScalableList();
            this.storageRoot.newUploadFiles = this.getStorage().createScalableList();
            this.storageRoot.hiddenBoardNames = this.getStorage().createScalableList();
            this.storageRoot.knownBoards = this.getStorage().createIndex(String.class, true);
            this.getStorage().setRoot(this.storageRoot);
            this.commit();
        } else if (this.storageRoot.hiddenBoardNames == null) {
            this.storageRoot.hiddenBoardNames = this.getStorage().createScalableList();
            this.storageRoot.knownBoards = this.getStorage().createIndex(String.class, true);
            this.storageRoot.modify();
            this.commit();
        }
        return true;
    }

    @Override
    public void exitSave() throws StorageException {
        this.close();
        this.storageRoot = null;
        System.out.println("INFO: FrostFilesStorage closed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePerstFrostDownloadFiles(List<PerstFrostDownloadItem> downloadFiles) {
        this.beginExclusiveThreadTransaction();
        try {
            for (PerstFrostDownloadItem pi : downloadFiles) {
                pi.makePersistent(this.getStorage());
                this.storageRoot.downloadFiles.add(pi);
            }
            this.storageRoot.downloadFiles.modify();
        }
        finally {
            this.endThreadTransaction();
        }
    }

    private void removeAllFromStorage(IPersistentList<? extends Persistent> plst) {
        Iterator i = plst.iterator();
        while (i.hasNext()) {
            Persistent pi = (Persistent)i.next();
            i.remove();
            pi.deallocate();
        }
        plst.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDownloadFiles(List<FrostDownloadItem> downloadFiles) {
        this.beginExclusiveThreadTransaction();
        try {
            this.removeAllFromStorage(this.storageRoot.downloadFiles);
            for (FrostDownloadItem dlItem : downloadFiles) {
                if (dlItem.isExternal()) continue;
                PerstFrostDownloadItem pi = new PerstFrostDownloadItem(dlItem);
                this.storageRoot.downloadFiles.add(pi);
            }
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FrostDownloadItem> loadDownloadFiles() {
        LinkedList<FrostDownloadItem> downloadItems = new LinkedList<FrostDownloadItem>();
        this.beginCooperativeThreadTransaction();
        try {
            for (PerstFrostDownloadItem pi : this.storageRoot.downloadFiles) {
                FrostDownloadItem dlItem = pi.toFrostDownloadItem(logger);
                if (dlItem == null) continue;
                downloadItems.add(dlItem);
            }
        }
        finally {
            this.endThreadTransaction();
        }
        return downloadItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePerstFrostUploadFiles(List<PerstFrostUploadItem> uploadFiles) {
        this.beginExclusiveThreadTransaction();
        try {
            for (PerstFrostUploadItem pi : uploadFiles) {
                this.storageRoot.uploadFiles.add(pi);
            }
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUploadFiles(List<FrostUploadItem> uploadFiles) {
        this.beginExclusiveThreadTransaction();
        try {
            this.removeAllFromStorage(this.storageRoot.uploadFiles);
            for (FrostUploadItem ulItem : uploadFiles) {
                if (ulItem.isExternal()) continue;
                PerstFrostUploadItem pi = new PerstFrostUploadItem(ulItem);
                this.storageRoot.uploadFiles.add(pi);
            }
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FrostUploadItem> loadUploadFiles(List<FrostSharedFileItem> sharedFiles) {
        LinkedList<FrostUploadItem> uploadItems = new LinkedList<FrostUploadItem>();
        Language language = Language.getInstance();
        this.beginCooperativeThreadTransaction();
        try {
            for (PerstFrostUploadItem pi : this.storageRoot.uploadFiles) {
                FrostUploadItem ulItem = pi.toFrostUploadItem(sharedFiles, logger, language);
                if (ulItem == null) continue;
                uploadItems.add(ulItem);
            }
        }
        finally {
            this.endThreadTransaction();
        }
        return uploadItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePerstFrostSharedFiles(List<PerstFrostSharedFileItem> sfFiles) {
        this.beginExclusiveThreadTransaction();
        try {
            for (PerstFrostSharedFileItem pi : sfFiles) {
                pi.makePersistent(this.getStorage());
                this.storageRoot.sharedFiles.add(pi);
            }
            this.storageRoot.sharedFiles.modify();
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSharedFiles(List<FrostSharedFileItem> sfFiles) {
        this.beginExclusiveThreadTransaction();
        try {
            this.removeAllFromStorage(this.storageRoot.sharedFiles);
            for (FrostSharedFileItem sfItem : sfFiles) {
                PerstFrostSharedFileItem pi = new PerstFrostSharedFileItem(sfItem);
                this.storageRoot.sharedFiles.add(pi);
            }
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FrostSharedFileItem> loadSharedFiles() {
        LinkedList<FrostSharedFileItem> sfItems = new LinkedList<FrostSharedFileItem>();
        Language language = Language.getInstance();
        this.beginCooperativeThreadTransaction();
        try {
            for (PerstFrostSharedFileItem pi : this.storageRoot.sharedFiles) {
                FrostSharedFileItem sfItem = pi.toFrostSharedFileItem(logger, language);
                if (sfItem == null) continue;
                sfItems.add(sfItem);
            }
        }
        finally {
            this.endThreadTransaction();
        }
        return sfItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveNewUploadFiles(List<NewUploadFile> newUploadFiles) {
        this.beginExclusiveThreadTransaction();
        try {
            this.removeAllFromStorage(this.storageRoot.newUploadFiles);
            for (NewUploadFile nuf : newUploadFiles) {
                nuf.makePersistent(this.getStorage());
                nuf.modify();
                this.storageRoot.newUploadFiles.add(nuf);
            }
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<NewUploadFile> loadNewUploadFiles() {
        LinkedList<NewUploadFile> newUploadFiles = new LinkedList<NewUploadFile>();
        this.beginCooperativeThreadTransaction();
        try {
            for (NewUploadFile nuf : this.storageRoot.newUploadFiles) {
                File f = new File(nuf.getFilePath());
                if (!f.isFile()) {
                    logger.warning("File (" + nuf.getFilePath() + ") is missing. File removed.");
                    continue;
                }
                newUploadFiles.add(nuf);
            }
        }
        finally {
            this.endThreadTransaction();
        }
        return newUploadFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<String> loadHiddenBoardNames() {
        HashSet<String> result = new HashSet<String>();
        this.beginCooperativeThreadTransaction();
        try {
            for (PerstHiddenBoardName hbn : this.storageRoot.hiddenBoardNames) {
                result.add(hbn.getHiddenBoardName());
            }
        }
        finally {
            this.endThreadTransaction();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveHiddenBoardNames(HashSet<String> names) {
        this.beginExclusiveThreadTransaction();
        try {
            this.removeAllFromStorage(this.storageRoot.hiddenBoardNames);
            for (String s : names) {
                PerstHiddenBoardName h = new PerstHiddenBoardName(s);
                this.storageRoot.hiddenBoardNames.add(h);
            }
        }
        finally {
            this.endThreadTransaction();
        }
    }

    private String buildBoardIndex(Board b) {
        StringBuilder sb = new StringBuilder();
        sb.append(b.getNameLowerCase());
        if (b.getPublicKey() != null) {
            sb.append(b.getPublicKey());
        }
        if (b.getPrivateKey() != null) {
            sb.append(b.getPrivateKey());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KnownBoard> getKnownBoards() {
        ArrayList<KnownBoard> lst;
        this.beginCooperativeThreadTransaction();
        try {
            lst = new ArrayList<KnownBoard>();
            for (PerstKnownBoard pkb : this.storageRoot.knownBoards) {
                KnownBoard kb = new KnownBoard(pkb.getBoardName(), pkb.getPublicKey(), pkb.getPrivateKey(), pkb.getDescription());
                lst.add(kb);
            }
        }
        finally {
            this.endThreadTransaction();
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean deleteKnownBoard(Board b) {
        boolean retval;
        String newIx = this.buildBoardIndex(b);
        this.beginExclusiveThreadTransaction();
        try {
            PerstKnownBoard pkb = (PerstKnownBoard)this.storageRoot.knownBoards.get(newIx);
            if (pkb != null) {
                this.storageRoot.knownBoards.remove(newIx, pkb);
                pkb.deallocate();
                retval = true;
            } else {
                retval = false;
            }
        }
        finally {
            this.endThreadTransaction();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int addNewKnownBoards(List<? extends Board> lst) {
        if (lst == null || lst.size() == 0) {
            return 0;
        }
        this.beginExclusiveThreadTransaction();
        int added = 0;
        try {
            for (Board board : lst) {
                PerstKnownBoard pkb;
                String newIx = this.buildBoardIndex(board);
                if (!this.storageRoot.knownBoards.put(newIx, pkb = new PerstKnownBoard(board.getName(), board.getPublicKey(), board.getPrivateKey(), board.getDescription()))) continue;
                ++added;
            }
        }
        finally {
            this.endThreadTransaction();
        }
        return added;
    }
}

