/*
 * Decompiled with CFR 0.152.
 */
package frost.storage.perst;

import frost.Core;
import frost.MainFrame;
import frost.fcp.FcpHandler;
import frost.fcp.FreenetKeys;
import frost.fileTransfer.sharing.FrostSharedFileItem;
import frost.util.gui.StartupMessage;
import frost.util.gui.translation.Language;
import java.io.File;
import java.util.logging.Logger;
import org.garret.perst.Persistent;

public class PerstFrostSharedFileItem
extends Persistent {
    public String sha;
    public String filePath;
    public long fileSize;
    public String key;
    public String owner;
    public String comment;
    public int rating;
    public String keywords;
    public long lastUploaded;
    public int uploadCount;
    public long refLastSent;
    public long requestLastReceived;
    public int requestsReceived;
    public long lastModified;

    public PerstFrostSharedFileItem() {
    }

    public PerstFrostSharedFileItem(FrostSharedFileItem sfItem) {
        this.filePath = sfItem.getFile().getPath();
        this.fileSize = sfItem.getFileSize();
        this.key = sfItem.getKey();
        this.sha = sfItem.getSha();
        this.owner = sfItem.getOwner();
        this.comment = sfItem.getComment();
        this.rating = sfItem.getRating();
        this.keywords = sfItem.getKeywords();
        this.lastUploaded = sfItem.getLastUploaded();
        this.uploadCount = sfItem.getUploadCount();
        this.refLastSent = sfItem.getRefLastSent();
        this.requestLastReceived = sfItem.getRequestLastReceived();
        this.requestsReceived = sfItem.getRequestsReceived();
        this.lastModified = sfItem.getLastModified();
    }

    public FrostSharedFileItem toFrostSharedFileItem(Logger logger, Language language) {
        boolean fileIsOk = true;
        File file = new File(this.filePath);
        if (!Core.frostSettings.getBoolValue("disableFilesharing")) {
            String title;
            if (!file.isFile()) {
                title = language.getString("StartupMessage.sharedFile.sharedFileNotFound.title");
                String text = language.formatMessage("StartupMessage.sharedFile.sharedFileNotFound.text", this.filePath);
                StartupMessage sm = new StartupMessage(StartupMessage.MessageType.SharedFileNotFound, title, text, 2, true);
                MainFrame.enqueueStartupMessage(sm);
                logger.severe("Shared file does not exist: " + this.filePath);
                fileIsOk = false;
            } else if (file.length() != this.fileSize) {
                title = language.getString("StartupMessage.sharedFile.sharedFileSizeChanged.title");
                String text = language.formatMessage("StartupMessage.sharedFile.sharedFileSizeChanged.text", this.filePath);
                StartupMessage sm = new StartupMessage(StartupMessage.MessageType.SharedFileSizeChanged, title, text, 2, true);
                MainFrame.enqueueStartupMessage(sm);
                logger.severe("Size of shared file changed: " + this.filePath);
                fileIsOk = false;
            } else if (file.lastModified() != this.lastModified) {
                title = language.getString("StartupMessage.sharedFile.sharedFileLastModifiedChanged.title");
                String text = language.formatMessage("StartupMessage.sharedFile.sharedFileLastModifiedChanged.text", this.filePath);
                StartupMessage sm = new StartupMessage(StartupMessage.MessageType.SharedFileLastModifiedChanged, title, text, 2, true);
                MainFrame.enqueueStartupMessage(sm);
                logger.severe("Last modified date of shared file changed: " + this.filePath);
                fileIsOk = false;
            }
        }
        if (FcpHandler.isFreenet07() && FreenetKeys.isOld07ChkKey(this.key)) {
            this.key = null;
            this.lastUploaded = 0L;
            this.uploadCount = 0;
        }
        FrostSharedFileItem sfItem = new FrostSharedFileItem(file, this.fileSize, this.key, this.sha, this.owner, this.comment, this.rating, this.keywords, this.lastUploaded, this.uploadCount, this.refLastSent, this.requestLastReceived, this.requestsReceived, this.lastModified, fileIsOk);
        return sfItem;
    }
}

