/*
 * Decompiled with CFR 0.152.
 */
package frost.storage.perst;

import frost.MainFrame;
import frost.fileTransfer.sharing.FrostSharedFileItem;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.util.gui.StartupMessage;
import frost.util.gui.translation.Language;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import org.garret.perst.Persistent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerstFrostUploadItem
extends Persistent {
    public String filePath;
    public long fileSize;
    public String chkKey;
    public boolean enabled;
    public int state;
    public long uploadAddedMillis;
    public long uploadStartedMillis;
    public long uploadFinishedMillis;
    public int retries;
    public long lastUploadStopTimeMillis;
    public String gqIdentifier;
    public String sharedFilesSha;
    public boolean isLoggedToFile;

    public PerstFrostUploadItem() {
    }

    public PerstFrostUploadItem(FrostUploadItem ulItem) {
        this.filePath = ulItem.getFile().getPath();
        this.fileSize = ulItem.getFileSize();
        this.chkKey = ulItem.getKey();
        this.enabled = ulItem.isEnabled() == null ? true : ulItem.isEnabled();
        this.state = ulItem.getState();
        this.uploadAddedMillis = ulItem.getUploadAddedMillis();
        this.uploadStartedMillis = ulItem.getUploadStartedMillis();
        this.uploadFinishedMillis = ulItem.getUploadFinishedMillis();
        this.retries = ulItem.getRetries();
        this.lastUploadStopTimeMillis = ulItem.getLastUploadStopTimeMillis();
        this.gqIdentifier = ulItem.getGqIdentifier();
        this.isLoggedToFile = ulItem.isLoggedToFile();
        this.sharedFilesSha = ulItem.getSharedFileItem() == null ? null : ulItem.getSharedFileItem().getSha();
    }

    public FrostUploadItem toFrostUploadItem(List<FrostSharedFileItem> sharedFiles, Logger logger, Language language) {
        File file = new File(this.filePath);
        if (!file.isFile()) {
            String title = language.getString("StartupMessage.uploadFile.uploadFileNotFound.title");
            String text = language.formatMessage("StartupMessage.uploadFile.uploadFileNotFound.text", this.filePath);
            StartupMessage sm = new StartupMessage(StartupMessage.MessageType.UploadFileNotFound, title, text, 0, true);
            MainFrame.enqueueStartupMessage(sm);
            logger.severe("Upload items file does not exist, removed from upload files: " + this.filePath);
            return null;
        }
        if (file.length() != this.fileSize) {
            String title = language.getString("StartupMessage.uploadFile.uploadFileSizeChanged.title");
            String text = language.formatMessage("StartupMessage.uploadFile.uploadFileSizeChanged.text", this.filePath);
            StartupMessage sm = new StartupMessage(StartupMessage.MessageType.UploadFileSizeChanged, title, text, 0, true);
            MainFrame.enqueueStartupMessage(sm);
            logger.severe("Upload items file size changed, removed from upload files: " + this.filePath);
            return null;
        }
        FrostSharedFileItem sharedFileItem = null;
        if (this.sharedFilesSha != null && this.sharedFilesSha.length() > 0) {
            for (FrostSharedFileItem s : sharedFiles) {
                if (!s.getSha().equals(this.sharedFilesSha)) continue;
                sharedFileItem = s;
                break;
            }
            if (sharedFileItem == null) {
                logger.severe("Upload items shared file object does not exist, removed from upload files: " + this.filePath);
                return null;
            }
            if (!sharedFileItem.isValid()) {
                logger.severe("Upload items shared file is invalid, removed from upload files: " + this.filePath);
                return null;
            }
        }
        FrostUploadItem ulItem = new FrostUploadItem(file, this.fileSize, this.chkKey, this.enabled, this.state, this.uploadAddedMillis, this.uploadStartedMillis, this.uploadFinishedMillis, this.retries, this.lastUploadStopTimeMillis, this.gqIdentifier, this.isLoggedToFile);
        ulItem.setSharedFileItem(sharedFileItem);
        return ulItem;
    }
}

