/*
 * Decompiled with CFR 0.152.
 */
package frost.storage.perst.messages;

import frost.messages.Attachment;
import frost.messages.AttachmentList;
import frost.messages.BoardAttachment;
import frost.messages.FileAttachment;
import frost.storage.perst.messages.PerstBoardAttachment;
import frost.storage.perst.messages.PerstFileAttachment;
import org.garret.perst.IPersistentList;
import org.garret.perst.Persistent;
import org.garret.perst.Storage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerstAttachments
extends Persistent {
    private IPersistentList<PerstBoardAttachment> boardAttachments;
    private IPersistentList<PerstFileAttachment> fileAttachments;

    public PerstAttachments() {
    }

    public PerstAttachments(Storage store, AttachmentList boards, AttachmentList files) {
        Persistent pba;
        if (boards != null && boards.size() > 0) {
            this.boardAttachments = store.createScalableList(boards.size());
            for (Attachment ba : boards) {
                pba = new PerstBoardAttachment((BoardAttachment)ba);
                this.boardAttachments.add((PerstBoardAttachment)pba);
            }
        } else {
            this.boardAttachments = null;
        }
        if (files != null && files.size() > 0) {
            this.fileAttachments = store.createScalableList(files.size());
            for (Attachment ba : files) {
                pba = new PerstFileAttachment((FileAttachment)ba);
                this.fileAttachments.add((PerstFileAttachment)pba);
            }
        } else {
            this.fileAttachments = null;
        }
    }

    public IPersistentList<PerstBoardAttachment> getBoardAttachments() {
        return this.boardAttachments;
    }

    public IPersistentList<PerstFileAttachment> getFileAttachments() {
        return this.fileAttachments;
    }

    @Override
    public void deallocate() {
        if (this.getBoardAttachments() != null) {
            for (PerstBoardAttachment ba : this.getBoardAttachments()) {
                ba.deallocate();
            }
            this.getBoardAttachments().clear();
            this.getBoardAttachments().deallocate();
        }
        if (this.getFileAttachments() != null) {
            for (PerstFileAttachment fa : this.getFileAttachments()) {
                fa.deallocate();
            }
            this.getFileAttachments().clear();
            this.getFileAttachments().deallocate();
        }
        super.deallocate();
    }
}

