/*
 * Decompiled with CFR 0.152.
 */
package frost.storage.perst.messages;

import frost.boards.Board;
import frost.messages.AttachmentList;
import frost.messages.BoardAttachment;
import frost.messages.FileAttachment;
import frost.messages.FrostMessageObject;
import frost.storage.perst.messages.MessageContentStorage;
import frost.storage.perst.messages.PerstAttachments;
import frost.storage.perst.messages.PerstBoardAttachment;
import frost.storage.perst.messages.PerstFileAttachment;
import org.garret.perst.Persistent;
import org.garret.perst.Storage;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class PerstFrostMessageObject
extends Persistent {
    String messageId;
    String inReplyTo;
    long dateAndTime;
    int msgIndex;
    String invalidReason;
    String fromName;
    String subject;
    String recipientName;
    int signatureStatus;
    boolean isDeleted;
    boolean isNew;
    boolean isReplied;
    boolean isJunk;
    boolean isFlagged;
    boolean isStarred;
    boolean hasBoardAttachments;
    boolean hasFileAttachments;
    int idLinePos;
    int idLineLen;

    public void deallocate() {
        MessageContentStorage.inst().deallocateForOid(this.getOid());
        super.deallocate();
    }

    public boolean recursiveLoading() {
        return false;
    }

    public PerstFrostMessageObject() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerstFrostMessageObject(FrostMessageObject mo, Storage store, boolean useTransaction) {
        if (useTransaction) {
            MessageContentStorage.inst().beginExclusiveThreadTransaction();
        }
        try {
            this.makePersistent(store);
            this.messageId = mo.getMessageId();
            this.inReplyTo = mo.getInReplyTo();
            if (!mo.isValid()) {
                this.invalidReason = mo.getInvalidReason();
                if (this.invalidReason == null || this.invalidReason.length() == 0) {
                    this.invalidReason = "AutoSet";
                }
            } else {
                this.invalidReason = null;
            }
            this.dateAndTime = mo.getDateAndTime().getMillis();
            this.msgIndex = mo.getIndex();
            this.fromName = mo.getFromName();
            this.subject = mo.getSubject();
            String string = this.recipientName = mo.getRecipientName() != null && mo.getRecipientName().length() == 0 ? null : mo.getRecipientName();
            if (mo.getSignatureV2() == null || mo.getSignatureV2().length() == 0) {
                if (mo.getSignatureV1() != null && mo.getSignatureV1().length() > 0) {
                    MessageContentStorage.inst().addSignatureForOid(this.getOid(), mo.getSignatureV1());
                }
            } else if (mo.getSignatureV2().length() > 0) {
                MessageContentStorage.inst().addSignatureForOid(this.getOid(), mo.getSignatureV2());
            }
            this.signatureStatus = mo.getSignatureStatus();
            if (mo.getPublicKey() != null && mo.getPublicKey().length() > 0) {
                MessageContentStorage.inst().addPublickeyForOid(this.getOid(), mo.getPublicKey());
            }
            this.isDeleted = mo.isDeleted();
            this.isNew = mo.isNew();
            this.isReplied = mo.isReplied();
            this.isJunk = mo.isJunk();
            this.isFlagged = mo.isFlagged();
            this.isStarred = mo.isStarred();
            this.idLinePos = mo.getIdLinePos();
            this.idLineLen = mo.getIdLineLen();
            AttachmentList files = mo.getAttachmentsOfType(0);
            AttachmentList boards = mo.getAttachmentsOfType(1);
            MessageContentStorage.inst().addAttachmentsForOid(this.getOid(), boards, files);
            this.hasBoardAttachments = boards != null && boards.size() > 0;
            this.hasFileAttachments = files != null && files.size() > 0;
            MessageContentStorage.inst().addContentForOid(this.getOid(), mo.getContent());
            this.modify();
        }
        finally {
            if (useTransaction) {
                MessageContentStorage.inst().endThreadTransaction();
            }
        }
    }

    public void retrieveMessageContent(FrostMessageObject mo) {
        mo.setContent(MessageContentStorage.inst().getContentForOid(this.getOid()));
    }

    public void retrievePublicKey(FrostMessageObject mo) {
        mo.setPublicKey(MessageContentStorage.inst().getPublickeyForOid(this.getOid()));
    }

    public void retrieveSignature(FrostMessageObject mo) {
        mo.setSignatureV2(MessageContentStorage.inst().getSignatureForOid(this.getOid()));
    }

    public void retrieveAttachments(FrostMessageObject mo) {
        PerstAttachments pa = MessageContentStorage.inst().getAttachmentsForOid(this.getOid());
        if (pa != null) {
            if (pa.getBoardAttachments() != null) {
                for (PerstBoardAttachment perstBoardAttachment : pa.getBoardAttachments()) {
                    Board b = new Board(perstBoardAttachment.name, perstBoardAttachment.pubKey, perstBoardAttachment.privKey, perstBoardAttachment.description);
                    BoardAttachment ba = new BoardAttachment(b);
                    mo.addAttachment(ba);
                }
            }
            if (pa.getFileAttachments() != null) {
                for (PerstFileAttachment perstFileAttachment : pa.getFileAttachments()) {
                    FileAttachment fa = new FileAttachment(perstFileAttachment.name, perstFileAttachment.chkKey, perstFileAttachment.size);
                    mo.addAttachment(fa);
                }
            }
        }
    }

    public FrostMessageObject toFrostMessageObject(Board board, boolean withContent, boolean withAttachments) {
        FrostMessageObject mo = new FrostMessageObject();
        mo.setPerstFrostMessageObject(this);
        mo.setBoard(board);
        if (this.invalidReason != null && this.invalidReason.length() > 0) {
            mo.setValid(false);
            mo.setInvalidReason(this.invalidReason);
        } else {
            mo.setValid(true);
        }
        mo.setMessageId(this.messageId);
        mo.setInReplyTo(this.inReplyTo);
        mo.setDateAndTime(new DateTime(this.dateAndTime, DateTimeZone.UTC));
        mo.setIndex(this.msgIndex);
        mo.setFromName(this.fromName);
        mo.setSubject(this.subject);
        if (this.recipientName != null && this.recipientName.length() == 0) {
            this.recipientName = null;
        }
        mo.setRecipientName(this.recipientName);
        mo.setSignatureStatus(this.signatureStatus);
        mo.setDeleted(this.isDeleted);
        mo.setNew(this.isNew);
        mo.setReplied(this.isReplied);
        mo.setJunk(this.isJunk);
        mo.setFlagged(this.isFlagged);
        mo.setStarred(this.isStarred);
        mo.setHasFileAttachments(this.hasFileAttachments);
        mo.setHasBoardAttachments(this.hasBoardAttachments);
        mo.setIdLinePos(this.idLinePos);
        mo.setIdLineLen(this.idLineLen);
        if (withContent) {
            this.retrieveMessageContent(mo);
        }
        if (withAttachments) {
            this.retrieveAttachments(mo);
        }
        return mo;
    }
}

