/*
 * Decompiled with CFR 0.152.
 */
package frost.threads;

import frost.Core;
import frost.fileTransfer.FileRequestFile;
import frost.fileTransfer.FileRequestFileContent;
import frost.fileTransfer.FileRequestsManager;
import frost.storage.perst.IndexSlot;
import frost.storage.perst.IndexSlotsStorage;
import frost.threads.FilePointersThread;
import frost.transferlayer.GlobalFileDownloader;
import frost.transferlayer.GlobalFileDownloaderResult;
import frost.transferlayer.GlobalFileUploader;
import frost.util.DateFun;
import frost.util.FileAccess;
import frost.util.Logging;
import frost.util.Mixed;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

public class FileRequestsThread
extends Thread {
    private static final Logger logger = Logger.getLogger(FilePointersThread.class.getName());
    private static final int sleepTime = 600000;
    private final String keyPrefix;
    private static FileRequestsThread instance = new FileRequestsThread();

    private FileRequestsThread() {
        String fileBase = Core.frostSettings.getValue("fileBase");
        this.keyPrefix = "KSK@frost/filerequests/" + fileBase + "-";
    }

    public static FileRequestsThread getInstance() {
        return instance;
    }

    public boolean cancelThread() {
        return false;
    }

    private boolean uploadRequestFile(String dateStr, IndexSlot gis) throws Throwable {
        File tmpRequestFile;
        FileRequestFileContent content;
        List<String> fileRequests = FileRequestsManager.getRequestsToSend();
        if (fileRequests == null || fileRequests.size() == 0) {
            logger.info("No requests to send.");
            return true;
        }
        if (Logging.inst().doLogFilebaseMessages()) {
            System.out.println("uploadRequestFile: fileRequests to send: " + fileRequests.size());
        }
        if (!FileRequestFile.writeRequestFile(content = new FileRequestFileContent(System.currentTimeMillis(), fileRequests), tmpRequestFile = FileAccess.createTempFile("filereq_", ".xml"))) {
            logger.severe("Error writing the file requests file.");
            return false;
        }
        Mixed.waitRandom(2000);
        logger.info("Starting upload of request file containing " + fileRequests.size() + " SHAs");
        if (Logging.inst().doLogFilebaseMessages()) {
            System.out.println("uploadRequestFile: Starting upload of request file containing " + fileRequests.size() + " SHAs");
        }
        String insertKey = this.keyPrefix + dateStr + "-";
        boolean wasOk = GlobalFileUploader.uploadFile(gis, tmpRequestFile, insertKey, ".xml", true);
        tmpRequestFile.delete();
        if (Logging.inst().doLogFilebaseMessages()) {
            System.out.println("uploadRequestFile: upload finished, wasOk=" + wasOk);
        }
        if (wasOk) {
            FileRequestsManager.updateRequestsWereSuccessfullySent(fileRequests);
        }
        IndexSlotsStorage.inst().storeSlot(gis);
        return wasOk;
    }

    private void downloadDate(String dateStr, IndexSlot gis, boolean isForToday) throws Throwable {
        String requestKey = this.keyPrefix + dateStr + "-";
        int maxFailures = isForToday ? 3 : 2;
        int index = gis.findFirstDownloadSlot();
        int failures = 0;
        while (failures < maxFailures && index >= 0) {
            int maxRetries;
            boolean quicklyFailOnAdnf;
            Mixed.waitRandom(2500);
            logger.info("Requesting index " + index + " for date " + dateStr);
            if (Core.frostSettings.getBoolValue("fcp2.quicklyFailOnAdnf")) {
                quicklyFailOnAdnf = true;
                maxRetries = 2;
            } else {
                quicklyFailOnAdnf = false;
                maxRetries = -1;
            }
            String downKey = requestKey + index + ".xml";
            GlobalFileDownloaderResult result = GlobalFileDownloader.downloadFile(downKey, 81920, maxRetries);
            if (result == null) {
                if (gis.isDownloadIndexBehindLastSetIndex(index)) {
                    ++failures;
                }
                index = gis.findNextDownloadSlot(index);
                continue;
            }
            failures = 0;
            if (result.getErrorCode() == 1) {
                if (Logging.inst().doLogFilebaseMessages()) {
                    if (quicklyFailOnAdnf) {
                        System.out.println("FileRequestsThread.downloadDate: Index " + index + " got ADNF, will never try index again.");
                    } else {
                        System.out.println("FileRequestsThread.downloadDate: Skipping index " + index + " for now, will try again later.");
                    }
                }
                if (quicklyFailOnAdnf) {
                    gis.setDownloadSlotUsed(index);
                    IndexSlotsStorage.inst().storeSlot(gis);
                }
                index = gis.findNextDownloadSlot(index);
                continue;
            }
            gis.setDownloadSlotUsed(index);
            index = gis.findNextDownloadSlot(index);
            if (result.getErrorCode() == 2) {
                logger.severe("FileRequestsThread.downloadDate: Dropping index " + index + ", FILE_TOO_BIG.");
            } else {
                File downloadedFile = result.getResultFile();
                FileRequestFileContent content = FileRequestFile.readRequestFile(downloadedFile);
                downloadedFile.delete();
                FileRequestsManager.processReceivedRequests(content);
            }
            IndexSlotsStorage.inst().storeSlot(gis);
        }
    }

    public void run() {
        int maxAllowedExceptions = 5;
        int occuredExceptions = 0;
        int downloadFullBackloadCount = 2;
        while (true) {
            int downloadBack;
            if (downloadFullBackloadCount > 0) {
                downloadBack = 1 + Core.frostSettings.getIntValue("fileListDownloadDays");
                --downloadFullBackloadCount;
            } else {
                downloadBack = 2;
            }
            try {
                LocalDate nowDate = new LocalDate(DateTimeZone.UTC);
                for (int i = 0; i < downloadBack; ++i) {
                    boolean isForToday = i == 0;
                    LocalDate localDate = nowDate.minusDays(i);
                    String dateStr = DateFun.FORMAT_DATE.print(localDate);
                    long date = localDate.toDateMidnight(DateTimeZone.UTC).getMillis();
                    IndexSlot gis = IndexSlotsStorage.inst().getSlotForDate(-2, date);
                    if (Logging.inst().doLogFilebaseMessages()) {
                        System.out.println("FileRequestsThread: starting download for " + dateStr);
                    }
                    if (!this.isInterrupted()) {
                        this.downloadDate(dateStr, gis, isForToday);
                    }
                    if (!this.isInterrupted() && isForToday) {
                        try {
                            if (Logging.inst().doLogFilebaseMessages()) {
                                System.out.println("FileRequestsThread: starting upload for " + dateStr);
                            }
                            this.uploadRequestFile(dateStr, gis);
                        }
                        catch (Throwable t) {
                            logger.log(Level.SEVERE, "Exception catched during uploadRequestFile()", t);
                        }
                    }
                    if (!this.isInterrupted()) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Exception catched", e);
                ++occuredExceptions;
            }
            if (occuredExceptions > 5) {
                logger.log(Level.SEVERE, "Stopping FileRequestsThread because of too much exceptions");
                break;
            }
            if (this.isInterrupted()) break;
            if (Logging.inst().doLogFilebaseMessages()) {
                System.out.println("FileRequestsThread: sleeping 10 minutes");
            }
            Mixed.wait(600000);
        }
    }
}

