/*
 * Decompiled with CFR 0.152.
 */
package frost.threads;

import frost.SettingsClass;
import frost.boards.Board;
import frost.boards.BoardUpdateInformation;
import frost.messages.UnsentMessagesManager;
import frost.threads.BoardUpdateThread;
import frost.threads.BoardUpdateThreadListener;
import frost.threads.FileAttachmentUploadThread;
import frost.threads.MessageThread;
import frost.threads.RunningMessageThreadsInformation;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunningBoardUpdateThreads
implements BoardUpdateThreadListener {
    Hashtable<String, Vector> threadListenersForBoard = new Hashtable();
    Vector<BoardUpdateThreadListener> threadListenersForAllBoards = new Vector();
    Hashtable<String, Vector> runningDownloadThreads = new Hashtable();

    public boolean startMessageDownloadToday(Board board, SettingsClass config, BoardUpdateThreadListener listener) {
        MessageThread tofd = new MessageThread(true, board, board.getMaxMessageDownload());
        tofd.addBoardUpdateThreadListener(this);
        if (listener != null) {
            tofd.addBoardUpdateThreadListener(listener);
        }
        this.getVectorFromHashtable(this.runningDownloadThreads, board).add(tofd);
        tofd.start();
        return true;
    }

    public boolean startMessageDownloadBack(Board board, SettingsClass config, BoardUpdateThreadListener listener, boolean downloadCompleteBackload) {
        int daysBackward = downloadCompleteBackload ? board.getMaxMessageDownload() : 1;
        MessageThread backload = new MessageThread(false, board, daysBackward);
        backload.addBoardUpdateThreadListener(this);
        if (listener != null) {
            backload.addBoardUpdateThreadListener(listener);
        }
        this.getVectorFromHashtable(this.runningDownloadThreads, board).add(backload);
        backload.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getVectorFromHashtable(Hashtable<String, Vector> t, Board key) {
        Vector retval = null;
        Hashtable<String, Vector> hashtable = t;
        synchronized (hashtable) {
            retval = t.get(key.getName());
            if (retval == null) {
                retval = new Vector();
                t.put(key.getName(), retval);
            }
        }
        return retval;
    }

    public Vector getDownloadThreadsForBoard(Board board) {
        return this.getVectorFromHashtable(this.runningDownloadThreads, board);
    }

    public void addBoardUpdateThreadListener(Board board, BoardUpdateThreadListener listener) {
        this.getVectorFromHashtable(this.threadListenersForBoard, board).remove(listener);
        this.getVectorFromHashtable(this.threadListenersForBoard, board).add(listener);
    }

    public void addBoardUpdateThreadListener(BoardUpdateThreadListener listener) {
        this.threadListenersForAllBoards.remove(listener);
        this.threadListenersForAllBoards.add(listener);
    }

    public void removeBoardUpdateThreadListener(Board board, BoardUpdateThreadListener listener) {
        this.getVectorFromHashtable(this.threadListenersForBoard, board).remove(listener);
    }

    public void removeBoardUpdateThreadListener(BoardUpdateThreadListener listener) {
        this.threadListenersForAllBoards.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void boardUpdateThreadFinished(BoardUpdateThread thread) {
        Vector threads = this.getVectorFromHashtable(this.runningDownloadThreads, thread.getTargetBoard());
        if (threads != null) {
            threads.remove(thread);
        }
        Vector<BoardUpdateThreadListener> vector = this.threadListenersForAllBoards;
        synchronized (vector) {
            Iterator<BoardUpdateThreadListener> i = this.threadListenersForAllBoards.iterator();
            while (i.hasNext()) {
                i.next().boardUpdateThreadFinished(thread);
            }
            i = this.getVectorFromHashtable(this.threadListenersForBoard, thread.getTargetBoard()).iterator();
            while (i.hasNext()) {
                i.next().boardUpdateThreadFinished(thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void boardUpdateThreadStarted(BoardUpdateThread thread) {
        Vector<BoardUpdateThreadListener> vector = this.threadListenersForAllBoards;
        synchronized (vector) {
            Iterator<BoardUpdateThreadListener> i = this.threadListenersForAllBoards.iterator();
            while (i.hasNext()) {
                i.next().boardUpdateThreadStarted(thread);
            }
            i = this.getVectorFromHashtable(this.threadListenersForBoard, thread.getTargetBoard()).iterator();
            while (i.hasNext()) {
                i.next().boardUpdateThreadStarted(thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void boardUpdateInformationChanged(BoardUpdateThread thread, BoardUpdateInformation bui) {
        Vector<BoardUpdateThreadListener> vector = this.threadListenersForAllBoards;
        synchronized (vector) {
            Iterator<BoardUpdateThreadListener> i = this.threadListenersForAllBoards.iterator();
            while (i.hasNext()) {
                i.next().boardUpdateInformationChanged(thread, bui);
            }
            i = this.getVectorFromHashtable(this.threadListenersForBoard, thread.getTargetBoard()).iterator();
            while (i.hasNext()) {
                i.next().boardUpdateInformationChanged(thread, bui);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRunningDownloadThreadCount() {
        int downloadingThreads = 0;
        Hashtable<String, Vector> hashtable = this.runningDownloadThreads;
        synchronized (hashtable) {
            for (Vector o : this.runningDownloadThreads.values()) {
                Vector v;
                if (!(o instanceof Vector) || (v = o).size() <= 0) continue;
                downloadingThreads += v.size();
            }
        }
        return downloadingThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDownloadingBoardCount() {
        int downloadingBoards = 0;
        Hashtable<String, Vector> hashtable = this.runningDownloadThreads;
        synchronized (hashtable) {
            for (Vector o : this.runningDownloadThreads.values()) {
                Vector v;
                if (!(o instanceof Vector) || (v = o).size() <= 0) continue;
                ++downloadingBoards;
            }
        }
        return downloadingBoards;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunningMessageThreadsInformation getRunningMessageThreadsInformation() {
        RunningMessageThreadsInformation info = new RunningMessageThreadsInformation();
        int uploadingMessages = UnsentMessagesManager.getRunningMessageUploads();
        info.setUploadingMessageCount(uploadingMessages);
        info.setUnsentMessageCount(UnsentMessagesManager.getUnsentMessageCount() - uploadingMessages);
        info.addToAttachmentsToUploadRemainingCount(FileAttachmentUploadThread.getInstance().getQueueSize());
        Hashtable<String, Vector> hashtable = this.runningDownloadThreads;
        synchronized (hashtable) {
            for (Vector o : this.runningDownloadThreads.values()) {
                Vector v;
                int vsize;
                if (!(o instanceof Vector) || (vsize = (v = o).size()) <= 0) continue;
                info.addToDownloadingBoardCount(1);
                info.addToRunningDownloadThreadCount(vsize);
            }
        }
        return info;
    }

    public boolean isUpdating(Board board) {
        return this.getVectorFromHashtable(this.runningDownloadThreads, board).size() > 0;
    }

    public boolean isThreadOfTypeRunning(Board board, int type) {
        Vector threads = this.getDownloadThreadsForBoard(board);
        for (int x = 0; x < threads.size(); ++x) {
            BoardUpdateThread thread = (BoardUpdateThread)threads.get(x);
            if (thread.getThreadType() != type) continue;
            return true;
        }
        return false;
    }
}

