/*
 * Decompiled with CFR 0.152.
 */
package frost.transferlayer;

import frost.fcp.FcpHandler;
import frost.fcp.FcpResultGet;
import frost.transferlayer.GlobalFileDownloaderResult;
import frost.util.FileAccess;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GlobalFileDownloader {
    private static final Logger logger = Logger.getLogger(GlobalFileDownloader.class.getName());

    public static GlobalFileDownloaderResult downloadFile(String downKey, int maxSize, int maxRetries) {
        try {
            File tmpFile = FileAccess.createTempFile("frost_", ".tmp");
            tmpFile.deleteOnExit();
            FcpResultGet fcpresults = FcpHandler.inst().getFile(1, downKey, null, tmpFile, false, false, maxSize, maxRetries);
            if (fcpresults == null || !fcpresults.isSuccess()) {
                tmpFile.delete();
                if (fcpresults != null && fcpresults.getReturnCode() == 28 && downKey.startsWith("KSK@")) {
                    return new GlobalFileDownloaderResult(1);
                }
                if (fcpresults != null && fcpresults.getReturnCode() == 21) {
                    return new GlobalFileDownloaderResult(2);
                }
                return null;
            }
            return new GlobalFileDownloaderResult(tmpFile);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error in downloadFile", t);
            return null;
        }
    }
}

