/*
 * Decompiled with CFR 0.152.
 */
package frost.transferlayer;

import frost.Core;
import frost.crypt.EncryptMetaData;
import frost.crypt.SignMetaData;
import frost.fcp.FcpHandler;
import frost.fcp.FcpResultGet;
import frost.fcp.FcpResultPut;
import frost.gui.MessageUploadFailedDialog;
import frost.identities.Identity;
import frost.identities.LocalIdentity;
import frost.messages.MessageXmlFile;
import frost.storage.perst.IndexSlot;
import frost.transferlayer.MessageUploaderCallback;
import frost.transferlayer.MessageUploaderResult;
import frost.util.FileAccess;
import frost.util.Mixed;
import frost.util.XMLTools;
import frost.util.gui.translation.Language;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class MessageUploader {
    private static final Logger logger = Logger.getLogger(MessageUploader.class.getName());

    protected static boolean prepareMessage(MessageUploaderWorkArea wa) {
        if (FcpHandler.isFreenet05()) {
            return MessageUploader.prepareMessage05(wa);
        }
        if (FcpHandler.isFreenet07()) {
            return MessageUploader.prepareMessage07(wa);
        }
        logger.severe("Unsupported freenet version, not 0.5 or 0.7");
        return false;
    }

    public static MessageUploaderResult uploadMessage(MessageXmlFile message, Identity encryptForRecipient, LocalIdentity senderId, MessageUploaderCallback callback, IndexSlot indexSlot, JFrame parentFrame, String logBoardName) {
        MessageUploaderWorkArea wa = new MessageUploaderWorkArea();
        wa.message = message;
        wa.unsentMessageFile = message.getFile();
        wa.parentFrame = parentFrame;
        wa.callback = callback;
        wa.indexSlot = indexSlot;
        wa.encryptForRecipient = encryptForRecipient;
        wa.senderId = senderId;
        wa.logBoardName = logBoardName;
        wa.uploadFile = new File(wa.unsentMessageFile.getPath() + ".upltmp");
        wa.uploadFile.delete();
        wa.uploadFile.deleteOnExit();
        if (!MessageUploader.prepareMessage(wa)) {
            return new MessageUploaderResult(true);
        }
        try {
            return MessageUploader.uploadMessage(wa);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "ERROR: Unexpected IOException, upload stopped.", ex);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Oo. EXCEPTION in MessageUploadThread", t);
        }
        return new MessageUploaderResult(true);
    }

    protected static MessageUploaderResult uploadMessage(MessageUploaderWorkArea wa) throws IOException {
        boolean tryAgain;
        logger.info("TOFUP: Uploading message to board '" + wa.logBoardName + "' with HTL " + Core.frostSettings.getIntValue("tofUploadHtl"));
        do {
            boolean success = false;
            int index = -1;
            int tries = 0;
            int maxTries = 10;
            boolean error = false;
            boolean retrySameIndex = false;
            String logInfo = null;
            while (!success && !error) {
                if (!retrySameIndex) {
                    index = index < 0 ? wa.indexSlot.findFirstUploadSlot() : wa.indexSlot.findNextUploadSlot(index);
                } else {
                    retrySameIndex = false;
                }
                FcpResultPut result = null;
                try {
                    String upKey = wa.callback.composeUploadKey(wa.message, index);
                    logInfo = " board=" + wa.logBoardName + ", key=" + upKey;
                    result = FcpHandler.inst().putFile(1, upKey, wa.uploadFile, wa.signMetadata, false, false, true);
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "TOFUP: Error in FcpInsert.putFile." + logInfo, t);
                }
                int waitTime = 15000;
                if (result.isRetry()) {
                    logger.severe("TOFUP: Message upload failed (RouteNotFound)!\n" + logInfo + "\n(try no. " + tries + " of " + 10 + "), retrying index " + index);
                    ++tries;
                    retrySameIndex = true;
                    Mixed.wait(15000);
                    continue;
                }
                if (result.isSuccess()) {
                    File tmpFile = new File(wa.unsentMessageFile.getPath() + ".down");
                    for (int dlTries = 0; dlTries < 10; ++dlTries) {
                        Mixed.wait(15000);
                        tmpFile.delete();
                        if (MessageUploader.downloadMessage(index, tmpFile, wa)) break;
                        logger.severe("TOFUP: Uploaded message could NOT be retrieved! Download try " + dlTries + " of " + 10 + "\n" + logInfo);
                    }
                    if (tmpFile.length() > 0L) {
                        logger.warning("TOFUP: Uploaded message was successfully retrieved." + logInfo);
                        success = true;
                    } else {
                        logger.severe("TOFUP: Uploaded message could NOT be retrieved!\n" + logInfo + "\n(try no. " + tries + " of " + 10 + "), retrying index " + index);
                        ++tries;
                        retrySameIndex = true;
                    }
                    tmpFile.delete();
                    continue;
                }
                if (result.isKeyCollision()) {
                    logger.warning("TOFUP: Upload collided, trying next free index." + logInfo);
                    Mixed.wait(15000);
                    continue;
                }
                if (result.isNoConnection()) {
                    logger.severe("TOFUP: Upload failed, no node connection." + logInfo);
                    error = true;
                    continue;
                }
                if (tries > 10) {
                    error = true;
                    continue;
                }
                logger.warning("TOFUP: Upload failed, " + logInfo + "\n(try no. " + tries + " of " + 10 + "), retrying index " + index);
                ++tries;
                retrySameIndex = true;
                Mixed.wait(15000);
            }
            if (success) {
                wa.indexSlot.setUploadSlotUsed(index);
                logger.info("Message successfully uploaded." + logInfo + "\n");
                wa.uploadFile.delete();
                return new MessageUploaderResult(index);
            }
            logger.warning("TOFUP: Error while uploading message.");
            boolean retrySilently = Core.frostSettings.getBoolValue("silentlyRetryMessages");
            if (!retrySilently) {
                MessageUploadFailedDialog faildialog = new MessageUploadFailedDialog((Frame)wa.parentFrame, wa.message, null);
                int answer = faildialog.startDialog();
                if (answer == 1) {
                    logger.info("TOFUP: Will try to upload again immediately.");
                    tryAgain = true;
                    continue;
                }
                if (answer == 2) {
                    wa.uploadFile.delete();
                    logger.info("TOFUP: Will try to upload again on next startup.");
                    return new MessageUploaderResult(true);
                }
                if (answer == 3) {
                    wa.uploadFile.delete();
                    logger.warning("TOFUP: Will NOT try to upload message again.");
                    return new MessageUploaderResult(false);
                }
                logger.warning("TOFUP: Paranoia - will try to upload message again.");
                tryAgain = true;
                continue;
            }
            tryAgain = true;
        } while (tryAgain);
        return new MessageUploaderResult(true);
    }

    private static boolean downloadMessage(int index, File targetFile, MessageUploaderWorkArea wa) {
        try {
            String downKey = wa.callback.composeDownloadKey(wa.message, index);
            FcpResultGet res = FcpHandler.inst().getFile(1, downKey, null, targetFile, false, false, 81920, -1);
            if (res != null && res.isSuccess() && targetFile.length() > 0L) {
                return true;
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Handled exception in downloadMessage", t);
        }
        return false;
    }

    protected static boolean prepareMessage05(MessageUploaderWorkArea wa) {
        if (wa.senderId != null) {
            wa.message.setFromName(wa.senderId.getUniqueName());
            wa.message.signMessageV1(wa.senderId.getPrivateKey());
            wa.message.signMessageV2(wa.senderId.getPrivateKey());
            if (!wa.message.save()) {
                logger.severe("Save of signed msg failed. This was a HARD error, please report to a dev!");
                return false;
            }
        }
        FileAccess.writeZipFile(FileAccess.readByteArray(wa.unsentMessageFile), "entry", wa.uploadFile);
        if (!wa.uploadFile.isFile() || wa.uploadFile.length() == 0L) {
            logger.severe("Error: zip of message xml file failed, result file not existing or empty. Please report to a dev!");
            return false;
        }
        if (wa.senderId != null) {
            byte[] zipped = FileAccess.readByteArray(wa.uploadFile);
            if (wa.encryptForRecipient != null) {
                byte[] encData = Core.getCrypto().encrypt(zipped, wa.encryptForRecipient.getPublicKey());
                if (encData == null) {
                    logger.severe("Error: could not encrypt the message, please report to a dev!");
                    return false;
                }
                wa.uploadFile.delete();
                FileAccess.writeFile(encData, wa.uploadFile);
                EncryptMetaData ed = new EncryptMetaData(encData, wa.senderId, wa.encryptForRecipient.getUniqueName());
                wa.signMetadata = XMLTools.getRawXMLDocument(ed);
            } else {
                SignMetaData md = new SignMetaData(zipped, wa.senderId);
                wa.signMetadata = XMLTools.getRawXMLDocument(md);
            }
        } else if (wa.encryptForRecipient != null) {
            logger.log(Level.SEVERE, "TOFUP: ALERT - can't encrypt message if sender is Anonymous! Will not send message!");
            return false;
        }
        long allLength = wa.uploadFile.length();
        if (wa.signMetadata != null) {
            allLength += (long)wa.signMetadata.length;
        }
        if (allLength > 32767L) {
            Language language = Language.getInstance();
            String title = language.getString("MessageUploader.messageToLargeError.title");
            String txt = language.formatMessage("MessageUploader.messageToLargeError.text", Long.toString(allLength), Integer.toString(Short.MAX_VALUE));
            JOptionPane.showMessageDialog(wa.parentFrame, txt, title, 0);
            return false;
        }
        return true;
    }

    protected static boolean prepareMessage07(MessageUploaderWorkArea wa) {
        if (wa.senderId != null) {
            wa.message.setFromName(wa.senderId.getUniqueName());
            wa.message.signMessageV1(wa.senderId.getPrivateKey());
            wa.message.signMessageV2(wa.senderId.getPrivateKey());
        }
        if (!wa.message.saveToFile(wa.uploadFile)) {
            logger.severe("Save to file '" + wa.uploadFile.getPath() + "' failed. This was a HARD error, file was NOT uploaded, please report to a dev!");
            return false;
        }
        if (wa.message.getSignatureV2() != null && wa.message.getSignatureV2().length() > 0 && wa.encryptForRecipient != null) {
            if (!MessageXmlFile.encryptForRecipientAndSaveCopy(wa.uploadFile, wa.encryptForRecipient, wa.uploadFile)) {
                logger.severe("This was a HARD error, file was NOT uploaded, please report to a dev!");
                return false;
            }
        } else if (wa.encryptForRecipient != null) {
            logger.log(Level.SEVERE, "TOFUP: ALERT - can't encrypt message if sender is Anonymous! Will not send message!");
            return false;
        }
        return true;
    }

    static class MessageUploaderWorkArea {
        MessageXmlFile message;
        File uploadFile;
        File unsentMessageFile;
        MessageUploaderCallback callback;
        byte[] signMetadata;
        Identity encryptForRecipient;
        LocalIdentity senderId;
        JFrame parentFrame;
        IndexSlot indexSlot;
        String logBoardName;

        MessageUploaderWorkArea() {
        }
    }
}

