/*
 * Decompiled with CFR 0.152.
 */
package frost.util;

import frost.Core;
import frost.MainFrame;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAccess {
    private static final Logger logger = Logger.getLogger(FileAccess.class.getName());

    public static File createTempFile(String prefix, String suffix) {
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile(prefix, suffix, new File(Core.frostSettings.getValue("temp.dir")));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (tmpFile == null) {
            while ((tmpFile = new File(Core.frostSettings.getValue("temp.dir") + prefix + System.currentTimeMillis() + suffix)).isFile()) {
            }
        }
        return tmpFile;
    }

    public static void saveDialog(Component parent, String content, String lastUsedDirectory, String title) {
        File file;
        JFileChooser fc = new JFileChooser(lastUsedDirectory);
        fc.setDialogTitle(title);
        fc.setFileHidingEnabled(true);
        fc.setFileSelectionMode(2);
        fc.setMultiSelectionEnabled(false);
        int returnVal = fc.showSaveDialog(parent);
        if (returnVal == 0 && (file = fc.getSelectedFile()) != null) {
            Core.frostSettings.setValue("lastUsedDirectory", file.getParent());
            if (!file.isDirectory()) {
                FileAccess.writeFile(content, file, "UTF-8");
            }
        }
    }

    public static byte[] readByteArray(String filename) {
        return FileAccess.readByteArray(new File(filename));
    }

    public static byte[] readByteArray(File file) {
        try {
            byte[] data = new byte[(int)file.length()];
            FileInputStream fileIn = new FileInputStream(file);
            DataInputStream din = new DataInputStream(fileIn);
            din.readFully(data);
            fileIn.close();
            return data;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception thrown in readByteArray(File file)", e);
            return null;
        }
    }

    public static ArrayList<File> getAllEntries(File file, String extension) {
        ArrayList<File> files = new ArrayList<File>();
        FileAccess.getAllFiles(file, extension, files);
        return files;
    }

    private static void getAllFiles(File file, String extension, ArrayList<File> filesLst) {
        if (file != null) {
            File[] dirfiles;
            if (file.isDirectory() && (dirfiles = file.listFiles()) != null) {
                for (int i = 0; i < dirfiles.length; ++i) {
                    FileAccess.getAllFiles(dirfiles[i], extension, filesLst);
                }
            }
            if (extension.length() == 0 || file.getName().endsWith(extension)) {
                filesLst.add(file);
            }
        }
    }

    public static boolean compressFileGZip(File inputFile, File outputFile) {
        int bufferSize = 4096;
        GZIPOutputStream out = null;
        FileInputStream in = null;
        try {
            int len;
            in = new FileInputStream(inputFile);
            out = new GZIPOutputStream(new FileOutputStream(outputFile));
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
            return true;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception catched", t);
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Throwable tt) {
                // empty catch block
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Throwable tt) {
                // empty catch block
            }
            return false;
        }
    }

    public static boolean decompressFileGZip(File inputFile, File outputFile) {
        int bufferSize = 4096;
        GZIPInputStream in = null;
        FileOutputStream out = null;
        try {
            int len;
            in = new GZIPInputStream(new FileInputStream(inputFile));
            out = new FileOutputStream(outputFile);
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
            return true;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception catched", t);
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Throwable tt) {
                // empty catch block
            }
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (Throwable tt) {
                // empty catch block
            }
            return false;
        }
    }

    public static boolean writeZipFile(byte[] content, String entry, File file) {
        if (content == null || content.length == 0) {
            Exception e = new Exception();
            e.fillInStackTrace();
            logger.log(Level.SEVERE, "Tried to zip an empty file!  Send this output to a dev and describe what you were doing.", e);
            return false;
        }
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(file));
            zos.setLevel(9);
            ZipEntry ze = new ZipEntry(entry);
            ze.setSize(content.length);
            zos.putNextEntry(ze);
            zos.write(content);
            zos.flush();
            zos.closeEntry();
            zos.close();
            return true;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Exception thrown in writeZipFile(byte[] content, String entry, File file)", e);
            return false;
        }
    }

    public static byte[] readZipFileBinary(File file) {
        if (!file.isFile() || file.length() == 0L) {
            return null;
        }
        int bufferSize = 4096;
        ZipInputStream zis = null;
        ByteArrayOutputStream out = null;
        try {
            int len;
            zis = new ZipInputStream(new FileInputStream(file));
            out = new ByteArrayOutputStream();
            zis.getNextEntry();
            byte[] zipData = new byte[4096];
            while ((len = zis.read(zipData)) >= 0) {
                out.write(zipData, 0, len);
            }
            zis.close();
            return out.toByteArray();
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Exception catched", e);
        }
        catch (IOException e) {
            try {
                if (zis != null) {
                    zis.close();
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            logger.log(Level.SEVERE, "Exception thrown in readZipFile(String path) \nOffending file saved as badfile.zip, send to a dev for analysis", e);
            FileAccess.copyFile(file.getPath(), "badfile.zip");
        }
        return null;
    }

    public static List<String> readLines(File file) {
        return FileAccess.readLines(file, "ISO-8859-1");
    }

    public static List<String> readLines(File file, String encoding) {
        ArrayList<String> result = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            result = FileAccess.readLines(fis, encoding);
            fis.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception thrown in readLines(File file, String encoding)", e);
        }
        return result;
    }

    public static ArrayList<String> readLines(InputStream is, String encoding) {
        ArrayList<String> data = new ArrayList<String>();
        try {
            String line;
            InputStreamReader iSReader = new InputStreamReader(is, encoding);
            BufferedReader reader = new BufferedReader(iSReader);
            while ((line = reader.readLine()) != null) {
                data.add(line.trim());
            }
            reader.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception thrown in readLines(InputStream is, String encoding)", e);
        }
        return data;
    }

    public static String readFile(File file) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader f = new BufferedReader(new FileReader(file));
            while ((line = f.readLine()) != null) {
                sb.append(line).append("\n");
            }
            f.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception thrown in readFile(String path)", e);
        }
        return sb.toString();
    }

    public static String readFile(File file, String encoding) {
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            InputStreamReader iSReader = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
            BufferedReader reader = new BufferedReader(iSReader);
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            reader.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception thrown in readFile(String path, String encoding)", e);
        }
        return sb.toString();
    }

    public static boolean writeFile(String content, String filename) {
        return FileAccess.writeFile(content, new File(filename));
    }

    public static boolean writeFile(String content, String filename, String encoding) {
        return FileAccess.writeFile(content, new File(filename), encoding);
    }

    public static boolean writeFile(String content, File file) {
        OutputStreamWriter out = null;
        try {
            try {
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                out = new FileWriter(file);
            }
            out.write(content);
            out.close();
            return true;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Exception thrown in writeFile(String content, File file)", e);
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Throwable tt) {
                // empty catch block
            }
            return false;
        }
    }

    public static boolean writeFile(byte[] content, File file) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(content);
            out.close();
            return true;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Exception thrown in writeFile(byte[] content, File file)", e);
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Throwable tt) {
                // empty catch block
            }
            return false;
        }
    }

    public static boolean writeFile(String content, File file, String encoding) {
        BufferedReader inputReader = null;
        OutputStreamWriter outputWriter = null;
        try {
            outputWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
            inputReader = new BufferedReader(new StringReader(content));
            String lineSeparator = System.getProperty("line.separator");
            String line = inputReader.readLine();
            while (line != null) {
                outputWriter.write(line + lineSeparator);
                line = inputReader.readLine();
            }
            outputWriter.close();
            inputReader.close();
            return true;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Exception thrown in writeFile(String content, File file, String encoding)", e);
            try {
                if (inputReader != null) {
                    inputReader.close();
                }
            }
            catch (Throwable tt) {
                // empty catch block
            }
            try {
                if (outputWriter != null) {
                    outputWriter.close();
                }
            }
            catch (Throwable tt) {
                // empty catch block
            }
            return false;
        }
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileAccess.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String sourceName, String destName) {
        FileChannel sourceChannel = null;
        AbstractInterruptibleChannel destChannel = null;
        boolean wasOk = false;
        try {
            sourceChannel = new FileInputStream(sourceName).getChannel();
            destChannel = new FileOutputStream(destName).getChannel();
            ((FileChannel)destChannel).transferFrom(sourceChannel, 0L, sourceChannel.size());
            wasOk = true;
        }
        catch (Throwable exception) {
            logger.log(Level.SEVERE, "Exception in copyFile", exception);
        }
        finally {
            try {
                if (sourceChannel != null) {
                    sourceChannel.close();
                }
            }
            catch (Throwable tt) {}
            try {
                if (destChannel != null) {
                    destChannel.close();
                }
            }
            catch (Throwable tt) {}
        }
        return wasOk;
    }

    public static boolean compareFiles(File f1, File f2) {
        BufferedInputStream s1 = null;
        BufferedInputStream s2 = null;
        try {
            boolean equals;
            block9: {
                int i2;
                int i1;
                s1 = new BufferedInputStream(new FileInputStream(f1));
                s2 = new BufferedInputStream(new FileInputStream(f2));
                equals = false;
                do {
                    if ((i1 = s1.read()) == (i2 = s2.read())) continue;
                    equals = false;
                    break block9;
                } while (i1 >= 0 || i2 >= 0);
                equals = true;
            }
            s1.close();
            s2.close();
            return equals;
        }
        catch (Throwable e) {
            try {
                if (s1 != null) {
                    s1.close();
                }
            }
            catch (Throwable tt) {
                // empty catch block
            }
            try {
                if (s2 != null) {
                    s2.close();
                }
            }
            catch (Throwable tt) {
                // empty catch block
            }
            return false;
        }
    }

    public static void copyFromResource(String resource, File file) throws IOException {
        if (!file.isFile()) {
            int bytesRead;
            InputStream input = MainFrame.class.getResourceAsStream(resource);
            FileOutputStream output = new FileOutputStream(file);
            byte[] data = new byte[4096];
            while ((bytesRead = input.read(data)) != -1) {
                output.write(data, 0, bytesRead);
            }
            input.close();
            output.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean appendLineToTextfile(File file, String line) {
        BufferedWriter out = null;
        boolean wasOk = false;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8"));
            out.write(line);
            out.write("\n");
            wasOk = true;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Exception catched", e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Throwable tt) {}
        }
        return wasOk;
    }
}

