/*
 * Decompiled with CFR 0.152.
 */
package frost.util;

import frost.SettingsClass;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class Logging {
    private static final Logger logger = Logger.getLogger(Logging.class.getName());
    public static final String VERY_LOW = "Options.miscellaneous.logLevel.veryLow";
    public static final String LOW = "Options.miscellaneous.logLevel.low";
    public static final String MEDIUM = "Options.miscellaneous.logLevel.medium";
    public static final String HIGH = "Options.miscellaneous.logLevel.high";
    public static final String VERY_HIGH = "Options.miscellaneous.logLevel.veryHigh";
    public static final String DEFAULT = "Options.miscellaneous.logLevel.low";
    private static final String LOG_FILE_NAME = "frost%g.log";
    private static Logging instance;
    private final SettingsClass frostSettings;
    private final Listener listener = new Listener();
    private Logger rootLogger = null;
    private FileHandler fileHandler = null;
    private final SimpleFormatter simpleFormatter = new SimpleFormatter();
    private boolean logFcp2Messages = false;
    private boolean logFilebaseMessages = false;

    public Logging(SettingsClass frostSettings) {
        this.frostSettings = frostSettings;
        this.initialize();
        instance = this;
    }

    public static Logging inst() {
        return instance;
    }

    public boolean doLogFcp2Messages() {
        return this.logFcp2Messages;
    }

    public boolean doLogFilebaseMessages() {
        return this.logFilebaseMessages;
    }

    private void initialize() {
        LogManager logManager = LogManager.getLogManager();
        this.rootLogger = logManager.getLogger("");
        if (!this.frostSettings.getBoolValue("logToConsole")) {
            Handler[] handlers;
            for (Handler element : handlers = this.rootLogger.getHandlers()) {
                this.rootLogger.removeHandler(element);
            }
        }
        this.logToFileSettingChanged();
        this.frostSettings.addPropertyChangeListener("logToFile", this.listener);
        this.frostSettings.addPropertyChangeListener("logFileSizeLimit", this.listener);
        this.frostSettings.addPropertyChangeListener("logLevel", this.listener);
        this.logFcp2Messages = this.frostSettings.getBoolValue("log.logFcp2MessagesToConsole");
        this.logFilebaseMessages = this.frostSettings.getBoolValue("log.logFilebaseMessagesToConsole");
    }

    private void logLevelSettingChanged() {
        boolean valueFound = this.setLevel(this.frostSettings.getValue("logLevel"));
        if (!valueFound) {
            this.setLevel(this.frostSettings.getDefaultValue("logLevel"));
        }
    }

    private boolean setLevel(String level) {
        if (level.equals(VERY_LOW)) {
            this.rootLogger.setLevel(Level.SEVERE);
            return true;
        }
        if (level.equals("Options.miscellaneous.logLevel.low")) {
            this.rootLogger.setLevel(Level.WARNING);
            return true;
        }
        if (level.equals(MEDIUM)) {
            this.rootLogger.setLevel(Level.INFO);
            return true;
        }
        if (level.equals(HIGH)) {
            this.rootLogger.setLevel(Level.FINER);
            return true;
        }
        if (level.equals(VERY_HIGH)) {
            this.rootLogger.setLevel(Level.FINEST);
            return true;
        }
        return false;
    }

    private void logFileSizeSettingChanged() {
        if (!Level.OFF.equals(this.rootLogger.getLevel())) {
            try {
                int fileSize = this.frostSettings.getIntValue("logFileSizeLimit");
                if (this.fileHandler != null) {
                    this.rootLogger.removeHandler(this.fileHandler);
                    this.fileHandler.close();
                    this.fileHandler = null;
                }
                this.fileHandler = new FileHandler(LOG_FILE_NAME, fileSize * 1024, 2, true);
                this.fileHandler.setEncoding("UTF-8");
                this.fileHandler.setFormatter(this.simpleFormatter);
                this.rootLogger.addHandler(this.fileHandler);
            }
            catch (IOException exception) {
                logger.log(Level.SEVERE, "There was an error while initializing the logging system.", exception);
            }
        }
    }

    private void logToFileSettingChanged() {
        if (!Level.OFF.equals(this.rootLogger.getLevel())) {
            if (this.frostSettings.getBoolValue("logToFile")) {
                this.rootLogger.setLevel(null);
                this.logLevelSettingChanged();
                this.logFileSizeSettingChanged();
            } else {
                this.rootLogger.setLevel(Level.OFF);
            }
        }
    }

    public void shutdownLogging() {
        this.frostSettings.removePropertyChangeListener("logToFile", this.listener);
        this.frostSettings.removePropertyChangeListener("logFileSizeLimit", this.listener);
        this.frostSettings.removePropertyChangeListener("logLevel", this.listener);
        if (this.fileHandler != null) {
            this.rootLogger.removeHandler(this.fileHandler);
            this.fileHandler.close();
        }
    }

    private class Listener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("logToFile")) {
                Logging.this.logToFileSettingChanged();
            }
            if (evt.getPropertyName().equals("logFileSizeLimit")) {
                Logging.this.logFileSizeSettingChanged();
            }
            if (evt.getPropertyName().equals("logLevel")) {
                Logging.this.logLevelSettingChanged();
            }
        }
    }
}

