/*
 * Decompiled with CFR 0.152.
 */
package frost.util;

import frost.Core;
import frost.util.DateFun;
import java.util.logging.Logger;
import org.joda.time.DateTime;

public final class Mixed {
    private static final Logger logger = Logger.getLogger(Mixed.class.getName());
    private static final char[] invalidChars = new char[]{'/', '\\', '?', '*', '<', '>', '\"', ':', '|', '#', '&'};

    public static void main(String[] args) {
        System.out.println(Mixed.createUniqueId());
    }

    public static String createUniqueId() {
        StringBuilder idStrSb = new StringBuilder();
        idStrSb.append(Long.toString(System.currentTimeMillis()));
        idStrSb.append(DateFun.FORMAT_DATE_EXT.print(new DateTime()));
        idStrSb.append(Long.toString(Runtime.getRuntime().freeMemory()));
        idStrSb.append(DateFun.FORMAT_TIME_EXT.print(new DateTime()));
        byte[] idStrPart = idStrSb.toString().getBytes();
        byte[] idRandomPart = new byte[64];
        Core.getCrypto().getSecureRandom().nextBytes(idRandomPart);
        byte[] idBytes = new byte[idStrPart.length + idRandomPart.length];
        System.arraycopy(idStrPart, 0, idBytes, 0, idStrPart.length);
        System.arraycopy(idRandomPart, 0, idBytes, idStrPart.length - 1, idRandomPart.length);
        String uniqueId = Core.getCrypto().computeChecksumSHA256(idBytes);
        return uniqueId;
    }

    public static int compareInt(int i1, int i2) {
        if (i1 < i2) {
            return -1;
        }
        if (i1 > i2) {
            return 1;
        }
        return 0;
    }

    public static int compareLong(long i1, long i2) {
        if (i1 < i2) {
            return -1;
        }
        if (i1 > i2) {
            return 1;
        }
        return 0;
    }

    public static void wait(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void waitRandom(int maxMillis) {
        Mixed.wait((int)(Math.random() * (double)maxMillis));
    }

    public static String makeFilename(String text) {
        if (text == null) {
            logger.severe("ERROR: mixed.makeFilename() was called with NULL!");
            return null;
        }
        StringBuilder newText = new StringBuilder();
        if (text.startsWith(".")) {
            newText.append("_");
        }
        for (char element : invalidChars) {
            text = text.replace(element, '_');
        }
        newText.append(text);
        return newText.toString();
    }

    public static String makeASCIIFilename(String text) {
        StringBuilder newText = new StringBuilder();
        String allowedCharacters = "()-!.";
        for (int i = 0; i < text.length(); ++i) {
            int value = Character.getNumericValue(text.charAt(i));
            char character = text.charAt(i);
            if (value >= 0 && value < 36 || "()-!.".indexOf(character) != -1) {
                newText.append(character);
                continue;
            }
            newText.append("_");
        }
        return Mixed.makeFilename(newText.toString());
    }

    public static boolean binaryCompare(byte[] src, int offs, String searchTxt) {
        int searchLen = searchTxt.length();
        for (int x = 0; x < searchLen; ++x) {
            byte b;
            byte a = (byte)searchTxt.charAt(x);
            if (a == (b = src[offs + x])) continue;
            return false;
        }
        return true;
    }
}

