/*
 * Decompiled with CFR 0.152.
 */
package frost.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class RandomGuid {
    private static Random random = new Random();
    private String guid;

    public RandomGuid() throws NoSuchAlgorithmException {
        this.generateGuid();
    }

    private void generateGuid() throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        StringBuilder stringToDigest = new StringBuilder();
        long time = System.currentTimeMillis();
        long rand = random.nextLong();
        stringToDigest.append(time);
        stringToDigest.append("-");
        stringToDigest.append(rand);
        md5.update(stringToDigest.toString().getBytes());
        byte[] digestBytes = md5.digest();
        StringBuilder digest = new StringBuilder();
        for (int i = 0; i < digestBytes.length; ++i) {
            int b = digestBytes[i] & 0xFF;
            if (b < 16) {
                digest.append('0');
            }
            digest.append(Integer.toHexString(b));
        }
        this.guid = digest.toString();
    }

    public String toString() {
        String guidUpperCase = this.guid.toUpperCase();
        StringBuilder sb = new StringBuilder();
        sb.append(guidUpperCase.substring(0, 8));
        sb.append("-");
        sb.append(guidUpperCase.substring(8, 12));
        sb.append("-");
        sb.append(guidUpperCase.substring(12, 16));
        sb.append("-");
        sb.append(guidUpperCase.substring(16, 20));
        sb.append("-");
        sb.append(guidUpperCase.substring(20));
        return sb.toString();
    }
}

