/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class GlassPane
extends JComponent
implements AWTEventListener {
    private Window theWindow;
    private Component activeComponent;
    private static final Logger logger = Logger.getLogger(GlassPane.class.getName());

    protected GlassPane(Component activeComponent) {
        this.addMouseListener(new MouseAdapter(){});
        this.addKeyListener(new KeyAdapter(){});
        this.setActiveComponent(activeComponent);
    }

    public void eventDispatched(AWTEvent event) {
        Object source = event.getSource();
        boolean sourceIsComponent = event.getSource() instanceof Component;
        if (event instanceof KeyEvent && sourceIsComponent && SwingUtilities.windowForComponent((Component)source) == this.theWindow) {
            ((KeyEvent)event).consume();
        }
    }

    public static synchronized GlassPane mount(Component startComponent, boolean create) {
        RootPaneContainer aContainer = null;
        Component aComponent = startComponent;
        while (aComponent.getParent() != null && !(aComponent instanceof RootPaneContainer)) {
            aComponent = aComponent.getParent();
        }
        if (aComponent instanceof RootPaneContainer) {
            aContainer = (RootPaneContainer)((Object)aComponent);
        }
        if (aContainer != null) {
            if (aContainer.getGlassPane() != null && aContainer.getGlassPane() instanceof GlassPane) {
                return (GlassPane)aContainer.getGlassPane();
            }
            if (create) {
                GlassPane aGlassPane = new GlassPane(startComponent);
                aContainer.setGlassPane(aGlassPane);
                logger.fine("GlassPane mounted on " + aContainer.getClass());
                return aGlassPane;
            }
            return null;
        }
        return null;
    }

    private void setActiveComponent(Component aComponent) {
        this.activeComponent = aComponent;
    }

    public void setVisible(boolean value) {
        if (value) {
            if (this.theWindow == null) {
                this.theWindow = SwingUtilities.windowForComponent(this.activeComponent);
                if (this.theWindow == null && this.activeComponent instanceof Window) {
                    this.theWindow = (Window)this.activeComponent;
                }
            }
            this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
            this.activeComponent = this.theWindow.getFocusOwner();
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
            this.requestFocus();
            super.setVisible(value);
        } else {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            super.setVisible(value);
            if (this.getTopLevelAncestor() != null) {
                this.getTopLevelAncestor().setCursor(null);
            }
        }
    }
}

