/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui;

import java.awt.Color;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextHighlighter {
    private final Color color;
    private final boolean matchAnyCase;
    Highlighter.HighlightPainter myHighlightPainter;

    public TextHighlighter(Color col) {
        this.color = col;
        this.myHighlightPainter = new MyHighlightPainter(this.color);
        this.matchAnyCase = true;
    }

    public TextHighlighter(Color col, boolean matchAnyCase) {
        this.color = col;
        this.myHighlightPainter = new MyHighlightPainter(this.color);
        this.matchAnyCase = matchAnyCase;
    }

    public void highlight(JTextComponent textComp, List<String> patterns, boolean removeOldHighlights) {
        for (String p : patterns) {
            this.highlight(textComp, p, removeOldHighlights);
            if (!removeOldHighlights) continue;
            removeOldHighlights = false;
        }
    }

    public void highlight(JTextComponent textComp, String pattern, boolean removeOldHighlights) {
        if (removeOldHighlights) {
            this.removeHighlights(textComp);
        }
        try {
            Highlighter hilite = textComp.getHighlighter();
            Document doc = textComp.getDocument();
            String text = doc.getText(0, doc.getLength());
            if (this.matchAnyCase) {
                text = text.toLowerCase();
            }
            int pos = 0;
            while ((pos = text.indexOf(pattern, pos)) >= 0) {
                hilite.addHighlight(pos, pos + pattern.length(), this.myHighlightPainter);
                pos += pattern.length();
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    public void highlight(JTextComponent textComp, int pos, int len, boolean removeOldHighlights) {
        if (removeOldHighlights) {
            this.removeHighlights(textComp);
        }
        try {
            Highlighter hilite = textComp.getHighlighter();
            hilite.addHighlight(pos, pos + len, this.myHighlightPainter);
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    public void removeHighlights(JTextComponent textComp) {
        Highlighter.Highlight[] hilites;
        Highlighter hilite = textComp.getHighlighter();
        for (Highlighter.Highlight element : hilites = hilite.getHighlights()) {
            if (!(element.getPainter() instanceof MyHighlightPainter)) continue;
            hilite.removeHighlight(element);
        }
    }

    private class MyHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public MyHighlightPainter(Color color) {
            super(color);
        }
    }
}

