/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui.textpane;

import frost.util.gui.textpane.MouseHyperlinkEvent;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

public class LinkEditorKit
extends StyledEditorKit {
    public static final Object LINK = new String("link");
    private static MouseInputListener linkHandler = new LinkHandler();

    public void install(JEditorPane p) {
        super.install(p);
        p.addMouseListener(linkHandler);
        p.addMouseMotionListener(linkHandler);
    }

    public void deinstall(JEditorPane p) {
        p.removeMouseListener(linkHandler);
        super.deinstall(p);
    }

    private static class LinkHandler
    extends MouseInputAdapter {
        private Element activeElement;

        private LinkHandler() {
        }

        private Element characterElementAt(MouseEvent e) {
            JEditorPane p = (JEditorPane)e.getComponent();
            Position.Bias[] bias = new Position.Bias[1];
            int position = p.getUI().viewToModel(p, e.getPoint(), bias);
            if (bias[0] == Position.Bias.Backward && position != 0) {
                --position;
            }
            Element c = ((StyledDocument)p.getDocument()).getCharacterElement(position);
            return c;
        }

        public void mousePressed(MouseEvent e) {
            JEditorPane p = (JEditorPane)e.getComponent();
            if (p.isEditable()) {
                return;
            }
            Element c = this.characterElementAt(e);
            if (c != null && c.getAttributes().getAttribute(LINK) != null) {
                this.activeElement = c;
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.activeElement == null) {
                return;
            }
            JEditorPane p = (JEditorPane)e.getComponent();
            Element c = this.characterElementAt(e);
            if (!p.isEditable() && c == this.activeElement) {
                this.activeElement = null;
                Object target = c.getAttributes().getAttribute(LINK);
                MouseHyperlinkEvent evt = new MouseHyperlinkEvent((Object)p, HyperlinkEvent.EventType.ACTIVATED, null, target.toString(), c, e);
                p.fireHyperlinkUpdate(evt);
            }
        }

        public void mouseMoved(MouseEvent e) {
            JEditorPane p = (JEditorPane)e.getComponent();
            if (p.isEditable()) {
                return;
            }
            Element c = this.characterElementAt(e);
            if (c != null && c.getAttributes().getAttribute(LINK) != null) {
                p.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                p.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

