/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui.translation;

import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import javax.swing.JComboBox;

public class JTranslatableComboBox
extends JComboBox
implements LanguageListener {
    private Language language = null;
    private String[] keys;

    public JTranslatableComboBox(Language language, String[] keys) {
        this.language = language;
        this.keys = keys;
        language.addLanguageListener(this);
        for (int i = 0; i < keys.length; ++i) {
            String value = language.getString(keys[i]);
            CheckBoxItem item = new CheckBoxItem(keys[i], value);
            this.addItem(item);
        }
    }

    public void languageChanged(LanguageEvent event) {
        this.refreshLanguage();
    }

    private void refreshLanguage() {
        for (int i = 0; i < this.keys.length; ++i) {
            CheckBoxItem item = (CheckBoxItem)this.getItemAt(i);
            String newValue = this.language.getString(item.getKey());
            item.setValue(newValue);
        }
        CheckBoxItem dummy = new CheckBoxItem("", "");
        this.addItem(dummy);
        this.removeItem(dummy);
    }

    public String getSelectedKey() {
        Object selectedItem = this.getSelectedItem();
        if (selectedItem != null && selectedItem instanceof CheckBoxItem) {
            return ((CheckBoxItem)selectedItem).getKey();
        }
        return null;
    }

    public void setSelectedKey(String aKey) {
        boolean found = false;
        for (int i = 0; i < this.getItemCount() && !found; ++i) {
            Object item = this.getItemAt(i);
            if (!(item instanceof CheckBoxItem) || !((CheckBoxItem)item).getKey().equals(aKey)) continue;
            this.setSelectedIndex(i);
            found = true;
        }
    }

    private class CheckBoxItem {
        private String key = null;
        private String value = null;

        public CheckBoxItem(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

