/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui.translation;

import frost.util.gui.translation.FrostResourceBundle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TranslateableFrostResourceBundle
extends FrostResourceBundle {
    private static final Logger logger = Logger.getLogger(TranslateableFrostResourceBundle.class.getName());

    public TranslateableFrostResourceBundle() {
        this.bundle = new HashMap();
    }

    public TranslateableFrostResourceBundle(String localeName, FrostResourceBundle parent, boolean isExternal) {
        super(localeName, parent, isExternal);
    }

    public TranslateableFrostResourceBundle(File bundleFile) {
        super(bundleFile);
    }

    public String removeKey(String key) {
        return (String)this.bundle.remove(key);
    }

    public String setKey(String key, String value) {
        return this.bundle.put(key, value);
    }

    public boolean containsKey(String key) {
        return this.bundle.containsKey(key);
    }

    public boolean saveBundleToFile(String localeName) {
        try {
            File externalBundleDir = new File("localdata/i18n/");
            if (!externalBundleDir.isDirectory()) {
                externalBundleDir.mkdirs();
            }
            String filename = "localdata/i18n/langres_" + localeName + ".properties";
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8")));
            TreeMap sorter = new TreeMap(this.bundle);
            Iterator i$ = sorter.keySet().iterator();
            while (i$.hasNext()) {
                String string;
                String key = string = (String)i$.next();
                String val = this.getString(key);
                key = key.trim();
                val = val.trim();
                StringBuilder sbTmp = new StringBuilder();
                for (int x = 0; x < val.length(); ++x) {
                    char c = val.charAt(x);
                    if (c == '\n') {
                        sbTmp.append("\\n");
                        continue;
                    }
                    sbTmp.append(c);
                }
                val = sbTmp.toString();
                out.println(key + "=" + val);
            }
            out.close();
            return true;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error saving bundle.", t);
            return false;
        }
    }
}

