/*
 * Decompiled with CFR 0.152.
 */
package frost.util.model;

import frost.util.model.ModelItem;
import frost.util.model.SortedModelListener;
import frost.util.model.SortedModelListenerSupport;
import frost.util.model.SortedModelTable;
import frost.util.model.SortedTableFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SortedModel {
    protected List<ModelItem> data = new ArrayList<ModelItem>();
    private SortedModelListenerSupport listenerSupport;
    private boolean ascending;
    private int columnNumber = -1;
    private final SortedTableFormat tableFormat;
    private SortedModelTable table = null;

    public SortedModel(SortedTableFormat newFormat) {
        this.tableFormat = newFormat;
    }

    public void setTable(SortedModelTable t) {
        this.table = t;
    }

    public SortedModelTable getTable() {
        return this.table;
    }

    public SortedTableFormat getTableFormat() {
        return this.tableFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addItem(ModelItem item) {
        if (this.columnNumber == -1) {
            List<ModelItem> list = this.data;
            synchronized (list) {
                this.data.add(item);
                this.fireItemAdded(item);
            }
            item.setModel(this);
        } else {
            this.addItem(item, this.getInsertionPoint(item));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addItem(ModelItem item, int position) {
        List<ModelItem> list = this.data;
        synchronized (list) {
            this.data.add(position, item);
            this.fireItemAdded(item);
        }
        item.setModel(this);
    }

    public synchronized void addOrderedModelListener(SortedModelListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listenerSupport == null) {
            this.listenerSupport = new SortedModelListenerSupport();
        }
        this.listenerSupport.addModelListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        List<ModelItem> list = this.data;
        synchronized (list) {
            for (ModelItem item : this.data) {
                item.setModel(null);
            }
            this.data.clear();
            this.getTable().fireTableDataChanged();
            if (this.listenerSupport == null) {
                return;
            }
            this.listenerSupport.fireModelCleared();
        }
    }

    protected void fireItemAdded(ModelItem item) {
        int position = this.data.indexOf(item);
        this.getTable().fireTableRowsInserted(position, position);
        if (this.listenerSupport == null) {
            return;
        }
        this.listenerSupport.fireItemAdded(item, position);
    }

    protected void fireItemChanged(ModelItem item) {
        if (this.columnNumber == -1) {
            this.fireItemChanged(item);
        } else {
            boolean reinsert = true;
            if (this.data.size() > 1) {
                int p = this.data.indexOf(item);
                Comparator cmp = this.getComparator();
                if (p == 0) {
                    ModelItem compItem = this.data.get(1);
                    if (cmp.compare(item, compItem) <= 0) {
                        reinsert = false;
                    }
                } else if (p == this.data.size() - 1) {
                    ModelItem compItem = this.data.get(p - 1);
                    if (cmp.compare(item, compItem) >= 0) {
                        reinsert = false;
                    }
                } else {
                    ModelItem compItem1 = this.data.get(p - 1);
                    ModelItem compItem2 = this.data.get(p + 1);
                    if (cmp.compare(item, compItem1) >= 0 && cmp.compare(item, compItem2) <= 0) {
                        reinsert = false;
                    }
                }
            } else {
                reinsert = false;
            }
            if (reinsert) {
                this.data.remove(item);
                this.data.add(this.getInsertionPoint(item), item);
                this.table.fireTableDataChanged();
            }
        }
        int position = this.data.indexOf(item);
        this.getTable().fireTableRowsUpdated(position, position);
        if (this.listenerSupport == null) {
            return;
        }
        this.listenerSupport.fireItemChanged(item, position);
    }

    void itemChanged(ModelItem item) {
        this.fireItemChanged(item);
    }

    private void fireItemsRemoved(int[] positions, ModelItem[] items) {
        this.getTable().fireTableRowsDeleted(positions);
        if (this.listenerSupport == null) {
            return;
        }
        this.listenerSupport.fireItemsRemoved(positions, items);
    }

    public ModelItem getItemAt(int position) {
        if (position >= this.data.size()) {
            System.out.println("SortedModel.getItemAt: position=" + position + ", but size=" + this.data.size());
            return null;
        }
        return this.data.get(position);
    }

    public int getItemCount() {
        return this.data.size();
    }

    public List getItems() {
        return new ArrayList<ModelItem>(this.data);
    }

    public int indexOf(ModelItem item) {
        return this.data.indexOf(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeItems(ModelItem[] items) {
        for (ModelItem modelItem : items) {
            modelItem.setModel(null);
        }
        int[] removedPositions = new int[items.length];
        ModelItem[] removedItems = new ModelItem[items.length];
        int count = 0;
        List<ModelItem> list = this.data;
        synchronized (list) {
            for (ModelItem element3 : items) {
                int position = this.data.indexOf(element3);
                if (position == -1) continue;
                this.data.remove(position);
                removedItems[count] = element3;
                removedPositions[count] = position;
                ++count;
            }
        }
        if (count != 0) {
            int[] nArray = new int[count];
            ModelItem[] croppedItems = new ModelItem[count];
            System.arraycopy(removedPositions, 0, nArray, 0, count);
            System.arraycopy(removedItems, 0, croppedItems, 0, count);
            this.fireItemsRemoved(nArray, croppedItems);
            return true;
        }
        return false;
    }

    protected void sort(int newColumnNumber, boolean newAscending) {
        this.columnNumber = newColumnNumber;
        this.ascending = newAscending;
        Collections.sort(this.data, this.getComparator());
    }

    private Comparator getComparator() {
        if (this.ascending) {
            return this.tableFormat.getComparator(this.columnNumber);
        }
        return this.tableFormat.getReverseComparator(this.columnNumber);
    }

    private int getInsertionPoint(ModelItem item) {
        int position = Collections.binarySearch(this.data, item, this.getComparator());
        if (position < 0) {
            position = (position + 1) * -1;
        } else {
            position = Collections.lastIndexOfSubList(this.data, Collections.singletonList(this.data.get(position)));
            ++position;
        }
        return position;
    }
}

