/*
 * Decompiled with CFR 0.152.
 */
package frost.util.model;

import frost.util.gui.MiscToolkit;
import frost.util.model.ModelTableHeader;
import frost.util.model.SortedModelTable;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class SortedTableHeader
extends ModelTableHeader {
    private static Icon ascendingIcon = MiscToolkit.loadImageIcon("/data/SortedTable_ascending.png");
    private static Icon descendingIcon = MiscToolkit.loadImageIcon("/data/SortedTable_descending.png");
    private final ArrowRenderer arrowRenderer = new ArrowRenderer();
    private final SortedModelTable sortedTable;

    public SortedTableHeader(SortedModelTable newSortedTable) {
        super(newSortedTable);
        this.sortedTable = newSortedTable;
        Enumeration<TableColumn> enumeration = this.sortedTable.getTable().getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn column = enumeration.nextElement();
            column.setHeaderRenderer(this.arrowRenderer);
        }
    }

    protected void headerClicked(MouseEvent e) {
        TableColumnModel lColumnModel;
        int columnNumber;
        super.headerClicked(e);
        if (e.getButton() == 1 && (columnNumber = (lColumnModel = this.getTable().getColumnModel()).getColumnIndexAtX(e.getX())) != -1) {
            int modelIndex = lColumnModel.getColumn(columnNumber).getModelIndex();
            this.sortedTable.columnClicked(modelIndex);
        }
    }

    private class ArrowRenderer
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable lTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TableCellRenderer defaultRenderer = lTable.getTableHeader().getDefaultRenderer();
            if (defaultRenderer instanceof JLabel) {
                JLabel labelRenderer = (JLabel)((Object)defaultRenderer);
                int modelIndex = lTable.getColumnModel().getColumn(column).getModelIndex();
                if (SortedTableHeader.this.sortedTable.getSortedColumn() == modelIndex) {
                    if (SortedTableHeader.this.sortedTable.isSortedAscending()) {
                        labelRenderer.setIcon(ascendingIcon);
                    } else {
                        labelRenderer.setIcon(descendingIcon);
                    }
                    labelRenderer.setHorizontalTextPosition(10);
                } else {
                    labelRenderer.setIcon(null);
                }
                labelRenderer.setToolTipText(value.toString());
            }
            return defaultRenderer.getTableCellRendererComponent(lTable, value, isSelected, hasFocus, row, column);
        }
    }
}

