/*
 * Decompiled with CFR 0.152.
 */
package mseries.Calendar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Calendar;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import mseries.Calendar.GridSelectionEvent;
import mseries.Calendar.GridSelectionListener;
import mseries.Calendar.MMonth;
import mseries.Calendar.SpecialDayModel;
import mseries.ui.ScreenUtilities;

public class CalendarPanel
extends JComponent {
    protected Color[] background;
    protected Color[] foreground;
    protected Color todayBG;
    protected Color todayFG;
    protected Color outOfRangeFG;
    protected Color outOfRangeBG;
    private boolean hasImage = false;
    private MMonth model;
    private SpecialDayModel specialModel;
    public int month;
    private Point selectedCell = new Point(-1, -1);
    public Point firstCell = new Point(-1, 0);
    public Point lastCell = new Point(-1, -1);
    private Vector listeners = new Vector();
    public static int DAYS = 7;
    public static int WEEKS = 6;
    public Dimension cellSize = new Dimension(22, 20);
    private static final String uiClassID = "CalendarPanelUI";

    public CalendarPanel() {
        this.updateUI();
        this.background = new Color[DAYS];
        this.foreground = new Color[DAYS];
        this.setFocusTraversalKeys(0, ScreenUtilities.getDefaultFocusTraversalKeys(0));
        this.setFocusTraversalKeys(1, ScreenUtilities.getDefaultFocusTraversalKeys(1));
    }

    public void updateUI() {
        this.setUI(this.registerUIDelegate());
    }

    protected ComponentUI registerUIDelegate() {
        ComponentUI compUI = (ComponentUI)UIManager.get(uiClassID);
        if (compUI == null) {
            String uiDelegateClassName = "mseries.plaf.basic.BasicCalendarPanelUI";
            String lafName = UIManager.getLookAndFeel().getID();
            if (lafName.equals("Windows")) {
                uiDelegateClassName = "mseries.plaf." + lafName + "." + lafName + uiClassID;
            } else if (lafName.equals("Metal")) {
                uiDelegateClassName = "mseries.plaf." + lafName + "." + lafName + uiClassID;
            } else if (lafName.equals("Motif")) {
                uiDelegateClassName = "mseries.plaf." + lafName + "." + lafName + uiClassID;
            }
            try {
                compUI = (ComponentUI)Class.forName(uiDelegateClassName).newInstance();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return compUI;
    }

    public boolean isInMonth(int row, int col) {
        Calendar date = (Calendar)this.model.getValueAt(row, col);
        int clickMonth = date.get(2);
        return clickMonth == this.month;
    }

    public boolean isInRange(int row, int col) {
        Calendar date = (Calendar)this.model.getValueAt(row, col);
        return this.model.isInRange(date);
    }

    public int getLegendFor(int row, int col) {
        Calendar date = (Calendar)this.model.getValueAt(row, col);
        int day = date.get(5);
        return day;
    }

    public int getDOW(int row, int col) {
        Calendar date = (Calendar)this.model.getValueAt(row, col);
        int day = date.get(7);
        return day;
    }

    protected void setSpecialModel(SpecialDayModel sdm) {
        this.specialModel = sdm;
    }

    public void setModel(MMonth model) {
        this.model = model;
        this.month = this.calculateMonth();
        DAYS = model.getColumnCount();
        WEEKS = model.getRowCount();
    }

    private int calculateMonth() {
        Calendar scratchDate = (Calendar)this.model.getValueAt(0, 0);
        Calendar firstDate = (Calendar)scratchDate.clone();
        if (firstDate.get(5) != 1) {
            firstDate.add(2, 1);
        }
        return firstDate.get(2);
    }

    public void tableChanged() {
        this.month = this.calculateMonth();
        this.repaint();
    }

    public void setCurrentDate(Point pnt) {
        this.setSelectedCell(pnt);
    }

    public void setSelectedCell(Point cell) {
        this.setSelectedCell(cell.x, cell.y);
    }

    public void setSelectedCell(int x, int y) {
        if (this.isEnabled()) {
            this.selectedCell.x = x;
            this.selectedCell.y = y;
        }
    }

    public void setLastCell(Point cell) {
        this.lastCell.x = cell.x;
        this.lastCell.y = cell.y;
    }

    public void setFirstCell(Point cell) {
        this.firstCell.x = cell.x;
        this.firstCell.y = cell.y;
    }

    public Point getSelectedCell() {
        return this.selectedCell;
    }

    public void addGridSelectionListener(GridSelectionListener l) {
        this.listeners.addElement(l);
    }

    public void removeGridSelectionListener(GridSelectionListener l) {
        this.listeners.removeElement(l);
    }

    public void notifyListeners() {
        if (this.isEnabled()) {
            this.notifyListeners(new GridSelectionEvent((Object)this, this.getSelectedCell()));
        }
    }

    public void notifyListeners(GridSelectionEvent event) {
        Vector list = (Vector)this.listeners.clone();
        for (int i = 0; i < list.size(); ++i) {
            GridSelectionListener l = (GridSelectionListener)this.listeners.elementAt(i);
            l.gridCellChanged(event);
        }
    }

    public boolean isFocusable() {
        return true;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setForeground(int day, Color color) {
        this.foreground[day - 1] = color;
    }

    public void setBackground(int day, Color color) {
        this.background[day - 1] = color;
    }

    public void setBackground(Color[] colors) {
        this.background = colors;
    }

    public void setForeground(Color[] colors) {
        this.foreground = colors;
    }

    public void setOutOfRangeForeground(Color colour) {
        this.outOfRangeFG = colour;
    }

    public Color getOutOfRangeBackground() {
        return this.outOfRangeBG;
    }

    public void setOutOfRangeBackground(Color outOfRangeBG) {
        this.outOfRangeBG = outOfRangeBG;
    }

    public void setTodayForeground(Color colour) {
        this.todayFG = colour;
    }

    public void setTodayBackground(Color colour) {
        this.todayBG = colour;
    }

    public Color getBackground(int day) {
        Color c = this.background[day - 1];
        if (c == null) {
            return this.getBackground();
        }
        return c;
    }

    public Color getBackground(int w, int d) {
        Color bg;
        if (this.model.isCurrentDate(w, d) && this.todayBG != null) {
            return this.todayBG;
        }
        if (!this.model.isInRange(this.model.getAsDate(w, d)) && this.outOfRangeBG != null) {
            return this.outOfRangeBG;
        }
        if (this.specialModel.isSpecialDay(this.model.getAsDate(w, d)) && (bg = this.specialModel.getBackground(this.model.getAsDate(w, d))) != null) {
            return bg;
        }
        return this.getBackground(this.getDOW(w, d));
    }

    public Color getForeground(int day) {
        Color c = this.foreground[day - 1];
        if (c == null) {
            return this.getForeground();
        }
        return c;
    }

    public Color getForeground(int w, int d) {
        Color fg;
        if (this.model.isCurrentDate(w, d) && this.todayFG != null) {
            return this.todayFG;
        }
        if (!this.model.isInRange(this.model.getAsDate(w, d)) && this.outOfRangeFG != null) {
            return this.outOfRangeFG;
        }
        if (this.specialModel.isSpecialDay(this.model.getAsDate(w, d)) && (fg = this.specialModel.getForeground(this.model.getAsDate(w, d))) != null) {
            return fg;
        }
        return this.getForeground(this.getDOW(w, d));
    }

    public void setCellSize(Dimension cellSize) {
        this.cellSize = cellSize;
        Dimension size = new Dimension(1, 1);
        size.width = DAYS * cellSize.width;
        size.height = WEEKS * cellSize.height;
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.setPreferredSize(size);
    }

    public Dimension getCellSize() {
        return this.cellSize;
    }

    public void setHasImage(boolean hasImage) {
        this.hasImage = hasImage;
    }

    public boolean hasImage() {
        return this.hasImage;
    }
}

