/*
 * Decompiled with CFR 0.152.
 */
package mseries.Calendar;

import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import mseries.Calendar.MDateChanger;
import mseries.ui.MChangeEvent;
import mseries.ui.MChangeListener;
import mseries.ui.MDateSpinnerModel;

class MScrollBarChanger
extends JScrollBar
implements MDateChanger,
AdjustmentListener {
    private Calendar maxC = Calendar.getInstance();
    private Calendar minC = Calendar.getInstance();
    private int minMonth;
    private int minYear;
    private int maxMonth;
    private int maxYear;
    private int day;
    protected Vector listeners = new Vector();
    protected MDateSpinnerModel model = new MDateSpinnerModel();
    private static final int UP = 1;
    private static final int DOWN = -1;

    public MScrollBarChanger() {
        this(0);
    }

    public MScrollBarChanger(int orientation) {
        super(orientation);
        this.model.setValue(new Date());
        super.addAdjustmentListener(this);
        this.minC.set(1900, 0, 1);
        this.minMonth = this.minC.get(2);
        this.minYear = this.minC.get(1);
        this.maxC.set(2037, 11, 31);
        super.setMinimum(0);
        super.setMaximum(1656);
        super.setVisibleAmount(1);
        super.setBlockIncrement(12);
        super.setUnitIncrement(1);
        super.setValue(0);
        this.installKeyboardActions();
    }

    private void installKeyboardActions() {
        this.registerKeyboardAction(new UpDownAction(1, 2), KeyStroke.getKeyStroke(33, 0), 2);
        this.registerKeyboardAction(new UpDownAction(-1, 2), KeyStroke.getKeyStroke(34, 0), 2);
        this.registerKeyboardAction(new UpDownAction(1, 1), KeyStroke.getKeyStroke(33, 1), 2);
        this.registerKeyboardAction(new UpDownAction(-1, 1), KeyStroke.getKeyStroke(34, 1), 2);
    }

    public void setMinimum(Date min) {
        this.minC.setTime(min);
        this.minMonth = this.minC.get(2);
        this.minYear = this.minC.get(1);
        this.maxMonth = this.maxC.get(2);
        this.maxYear = this.maxC.get(1);
        int minMonths = (this.minYear - 1900) * 12 + this.minMonth;
        int maxMonths = (this.maxYear - 1900) * 12 + this.maxMonth;
        super.setMaximum(maxMonths - minMonths);
        this.setValue(min);
        this.model.setMinimum(min);
    }

    public void setMaximum(Date max) {
        this.maxC.setTime(max);
        int month = this.maxC.get(2);
        int year = this.maxC.get(1);
        int lastMonth = (year - 1900) * 12 + month;
        int minMonths = (this.minYear - 1900) * 12 + this.minMonth;
        int monthRange = lastMonth - minMonths + 1;
        super.setMaximum(monthRange);
        this.setValue(this.minC.getTime());
        this.model.setMaximum(max);
    }

    public void setValue(Date newVal) {
        Calendar valC = Calendar.getInstance();
        valC.setTime(newVal);
        int month = valC.get(2);
        int year = valC.get(1);
        if (!newVal.before(this.minC.getTime()) && !newVal.after(this.maxC.getTime())) {
            int newValue = (year - this.minYear) * 12 + month - this.minMonth;
            super.setValue(newValue);
        }
        this.model.setValue(newVal);
    }

    public void setDay(int day) {
        this.day = day;
    }

    public void setBlockIncrement(int v) {
        super.setBlockIncrement(12);
    }

    public void setUnitIncrement(int v) {
        super.setUnitIncrement(1);
    }

    private void notifyListeners(int type) {
        Vector list = (Vector)this.listeners.clone();
        for (int i = 0; i < list.size(); ++i) {
            MChangeListener l = (MChangeListener)this.listeners.elementAt(i);
            l.valueChanged(new MChangeEvent(this, new Integer(this.getValue()), type));
        }
    }

    public void addMChangeListener(MChangeListener l) {
        this.listeners.addElement(l);
    }

    public void removeMChangeListener(MChangeListener l) {
        this.listeners.removeElement(l);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.notifyListeners(0);
    }

    public boolean hasFocus() {
        return false;
    }

    public void addFListener(FocusListener l) {
    }

    public void removeFListener(FocusListener l) {
    }

    protected class UpDownAction
    extends AbstractAction {
        int direction;
        int step;

        public UpDownAction(int direction, int step) {
            this.step = step;
            this.direction = direction;
        }

        public void actionPerformed(ActionEvent evt) {
            MScrollBarChanger.this.model.setStep(this.step);
            Object val = this.direction == 1 ? MScrollBarChanger.this.model.getNextValue() : MScrollBarChanger.this.model.getPreviousValue();
            MScrollBarChanger.this.setValue((Date)val);
            MScrollBarChanger.this.notifyListeners(0);
        }
    }
}

