/*
 * Decompiled with CFR 0.152.
 */
package freenet;

import freenet.FieldSet;
import freenet.crypt.DSA;
import freenet.crypt.DSAGroup;
import freenet.crypt.DSAPrivateKey;
import freenet.crypt.DSAPublicKey;
import freenet.crypt.DSASignature;
import freenet.crypt.Digest;
import freenet.crypt.SHA1;
import freenet.crypt.Util;
import freenet.support.Fields;
import java.math.BigInteger;
import java.util.Random;

public class Storables
extends FieldSet {
    public static final String PREFIX = "Storable";
    private static final String[] ypqgS = new String[]{"y", "p", "q", "g"};

    public Storables() {
    }

    private Storables(FieldSet sto) {
        super(sto);
    }

    public static Storables readFrom(FieldSet fs) {
        FieldSet sto = fs.getSet(PREFIX);
        return sto == null ? null : new Storables(sto);
    }

    public void addTo(FieldSet fs) {
        fs.put(PREFIX, this);
    }

    public boolean isLegalForCHK() {
        return this.size() == 4 && this.getPartSize() > 0L && this.getInitialDigest() != null && this.getSymmetricCipher() != null && this.getDocumentHeader() != null;
    }

    public boolean isLegalForSVK() {
        if (this.size() != 6 && (this.size() != 7 || this.getDocumentName() == null)) {
            return false;
        }
        return this.getPartSize() > 0L && this.getInitialDigest() != null && this.getSymmetricCipher() != null && this.getDocumentHeader() != null && this.getPublicKey() != null && this.getSignature() != null;
    }

    public void sign(Random r, DSAPrivateKey sk, DSAGroup g) {
        this.setPublicKey(new DSAPublicKey(g, sk));
        Digest ctx = SHA1.getInstance();
        this.hashUpdate(ctx, new String[]{"Signature"});
        BigInteger k = Util.generateLargeRandom(80, 160, r);
        BigInteger m = Util.byteArrayToMPI(ctx.digest());
        this.setSignature(DSA.sign(g, sk, k, m));
    }

    public boolean verifies() {
        Digest ctx = SHA1.getInstance();
        this.hashUpdate(ctx, new String[]{"Signature"});
        BigInteger m = Util.byteArrayToMPI(ctx.digest());
        return DSA.verify(this.getPublicKey(), this.getSignature(), m);
    }

    public long getPartSize() {
        try {
            return Math.max(0L, Long.parseLong(this.get("Part-size"), 16));
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public void setPartSize(long partSize) {
        this.put("Part-size", Long.toHexString(Math.max(0L, partSize)));
    }

    public byte[] getInitialDigest() {
        String s = this.get("Initial-digest");
        return s == null ? null : Fields.hexToBytes(s);
    }

    public void setInitialDigest(byte[] digest) {
        this.put("Initial-digest", Fields.bytesToHex(digest));
    }

    public String getSymmetricCipher() {
        return this.get("Symmetric-cipher");
    }

    public void setSymmetricCipher(String cipher) {
        this.put("Symmetric-cipher", cipher);
    }

    public byte[] getDocumentHeader() {
        String s = this.get("Document-header");
        return s == null ? null : Fields.hexToBytes(s);
    }

    public void setDocumentHeader(byte[] header) {
        this.put("Document-header", Fields.bytesToHex(header));
    }

    public DSAPublicKey getPublicKey() {
        FieldSet fs = this.getSet("Public-key");
        if (fs == null) {
            return null;
        }
        BigInteger[] ypqg = new BigInteger[4];
        for (int i = 0; i < 4; ++i) {
            String n = fs.get(ypqgS[i]);
            if (n == null) {
                return null;
            }
            ypqg[i] = new BigInteger(n, 16);
        }
        return new DSAPublicKey(new DSAGroup(ypqg[1], ypqg[2], ypqg[3]), ypqg[0]);
    }

    public void setPublicKey(DSAPublicKey pk) {
        FieldSet fs = new FieldSet();
        fs.put("y", pk.getY().toString(16));
        fs.put("p", pk.getP().toString(16));
        fs.put("q", pk.getQ().toString(16));
        fs.put("g", pk.getG().toString(16));
        this.put("Public-key", fs);
    }

    public byte[] getDocumentName() {
        String s = this.get("Document-name");
        return s == null ? null : Fields.hexToBytes(s);
    }

    public void setDocumentName(byte[] hash) {
        this.put("Document-name", Fields.bytesToHex(hash));
    }

    public DSASignature getSignature() {
        String s = this.get("Signature");
        return s == null ? null : new DSASignature(s);
    }

    public void setSignature(DSASignature sig) {
        this.put("Signature", sig.toString());
    }
}

