/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.crypt.BlockCipher;
import freenet.crypt.CipherInputStream;
import freenet.crypt.CipherOutputStream;
import freenet.crypt.DecipherOutputStream;
import freenet.crypt.EncipherInputStream;
import freenet.crypt.PCFBMode;
import freenet.crypt.SHA1;
import freenet.crypt.Util;
import freenet.support.io.DataNotValidIOException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Vector;

public class Document {
    public static final int DOC_BAD_HEADER = 193;
    public static final int DOC_BAD_KEY = 194;
    public static final int DOC_UNKNOWN_CIPHER = 195;
    public static final int DOC_BAD_LENGTH = 196;
    public static final int DOC_BAD_STORABLES = 197;
    protected long length;
    protected long metaLength;
    protected byte[] header;
    protected byte[] cryptoKey;
    protected PCFBMode ctx;

    public static final String getTextForDNV(int code) {
        switch (code) {
            case 193: {
                return "DOC_BAD_HEADER";
            }
            case 194: {
                return "DOC_BAD_KEY";
            }
            case 195: {
                return "DOC_UNKNOWN_CIPHER";
            }
            case 196: {
                return "DOC_BAD_LENGTH";
            }
            case 197: {
                return "DOC_BAD_STORABLES";
            }
        }
        return null;
    }

    protected static int fieldSize(long n) {
        int byteLen = Util.log2(n + 1L) + 7 >> 3;
        return byteLen == 0 ? 1 : byteLen;
    }

    public Document(BlockCipher cipher, byte[] cryptoKey, long length, long metaLength) throws IOException {
        if (length < 0L || Util.log2(length) > 62) {
            throw new IllegalArgumentException("length out of bounds");
        }
        if (metaLength < 0L || metaLength > length) {
            throw new IllegalArgumentException("metadata length out of bounds");
        }
        if (length + metaLength <= 0L) {
            throw new IllegalArgumentException("completely empty insert");
        }
        this.cryptoKey = cryptoKey;
        this.length = length;
        this.metaLength = metaLength;
        cipher.initialize(cryptoKey);
        this.ctx = new PCFBMode(cipher);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.fillHeader(bout, Util.hashBytes(new SHA1(), cryptoKey));
        this.fillHeader(bout, length);
        this.fillHeader(bout, metaLength);
        bout.write(0);
        bout.write(0);
        int padLen = (1 << Util.log2(bout.size())) - bout.size();
        if (padLen > 0) {
            SHA1 dig = new SHA1();
            dig.update(bout.toByteArray());
            Util.rollingHashPad(bout, padLen, dig);
        }
        this.header = bout.toByteArray();
        for (int i = 0; i < this.header.length; ++i) {
            this.header[i] = (byte)this.ctx.encipher(this.header[i]);
        }
    }

    protected void fillHeader(ByteArrayOutputStream bout, byte[] b) throws IOException {
        bout.write(0xFF & b.length >> 8);
        bout.write(0xFF & b.length);
        bout.write(b);
    }

    protected void fillHeader(ByteArrayOutputStream bout, long num) throws IOException {
        int byteLen = Document.fieldSize(num);
        bout.write(0xFF & byteLen >> 8);
        bout.write(0xFF & byteLen);
        for (int i = 8 * (byteLen - 1); i >= 0; i -= 8) {
            bout.write((int)(0xFFL & num >> i));
        }
    }

    public Document(BlockCipher cipher, byte[] cryptoKey, byte[] header) throws DataNotValidIOException {
        if (header.length != 1 << Util.log2(header.length)) {
            throw new DataNotValidIOException(193);
        }
        this.header = header;
        this.cryptoKey = cryptoKey;
        cipher.initialize(cryptoKey);
        this.ctx = new PCFBMode(cipher);
        Vector<byte[]> fields = new Vector<byte[]>();
        try {
            int len;
            int i = 0;
            while (i < header.length && (len = (byte)this.ctx.decipher(header[i++]) << 8 | (byte)this.ctx.decipher(header[i++])) > 0) {
                byte[] f = new byte[len];
                for (int j = 0; j < len; ++j) {
                    f[j] = (byte)this.ctx.decipher(header[i++]);
                }
                fields.addElement(f);
            }
            while (i < header.length) {
                this.ctx.decipher(header[i++]);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataNotValidIOException(193);
        }
        if (fields.size() < 1) {
            throw new DataNotValidIOException(194);
        }
        byte[] tmp = (byte[])fields.elementAt(0);
        if (tmp == null || !Util.byteArrayEqual(tmp, Util.hashBytes(new SHA1(), cryptoKey))) {
            throw new DataNotValidIOException(194);
        }
        if (fields.size() < 3) {
            throw new DataNotValidIOException(193);
        }
        tmp = (byte[])fields.elementAt(1);
        if (tmp == null) {
            throw new DataNotValidIOException(193);
        }
        this.length = new BigInteger(1, tmp).longValue();
        if (this.length <= 0L || Util.log2(this.length) > 62 || Document.fieldSize(this.length) != tmp.length) {
            throw new DataNotValidIOException(193);
        }
        tmp = (byte[])fields.elementAt(2);
        if (tmp == null) {
            throw new DataNotValidIOException(193);
        }
        this.metaLength = new BigInteger(1, tmp).longValue();
        if (this.metaLength < 0L || this.metaLength > this.length || Document.fieldSize(this.metaLength) != tmp.length) {
            throw new DataNotValidIOException(193);
        }
    }

    public byte[] getDocumentHeader() {
        return this.header;
    }

    public boolean hasMetadata() {
        return this.metaLength != 0L;
    }

    public long length() {
        return this.length;
    }

    public long metadataLength() {
        return this.metaLength;
    }

    public long dataLength() {
        return this.length - this.metaLength;
    }

    public OutputStream decipheringOutputStream(OutputStream out) throws IOException {
        return new DecipherOutputStream(out, this.ctx);
    }

    public OutputStream encipheringOutputStream(OutputStream out) throws IOException {
        return new CipherOutputStream(this.ctx, out);
    }

    public InputStream decipheringInputStream(InputStream in) throws IOException {
        return new CipherInputStream(this.ctx, in);
    }

    public InputStream encipheringInputStream(InputStream in) throws IOException {
        return new EncipherInputStream(in, this.ctx);
    }
}

