/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.CryptoKey;
import freenet.crypt.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.StringTokenizer;

public class DHGroup
extends CryptoKey {
    public final BigInteger p;
    public final BigInteger g;

    public DHGroup(BigInteger p, BigInteger g) {
        this.p = p;
        this.g = g;
    }

    public void write(OutputStream out) throws IOException {
        super.write(new DataOutputStream(out), this.getClass().getName());
    }

    public String writeAsField() {
        StringBuffer b = new StringBuffer();
        b.append(this.p.toString(16)).append(',');
        b.append(this.g.toString(16));
        return b.toString();
    }

    public static CryptoKey readFromField(String field) {
        StringTokenizer str = new StringTokenizer(field, ",");
        BigInteger p = Util.byteArrayToMPI(Util.hexToBytes(str.nextToken()));
        BigInteger g = Util.byteArrayToMPI(Util.hexToBytes(str.nextToken()));
        return new DHGroup(p, g);
    }

    public static CryptoKey read(DataInputStream i) throws IOException {
        BigInteger p = Util.readMPI(i);
        BigInteger g = Util.readMPI(i);
        return new DHGroup(p, g);
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getG() {
        return this.g;
    }

    public String keyType() {
        return "DHG-" + this.p.bitLength();
    }

    public byte[] fingerprint() {
        return this.fingerprint(new BigInteger[]{this.p, this.g});
    }

    public byte[] asBytes() {
        byte[] pb = Util.MPIbytes(this.p);
        byte[] gb = Util.MPIbytes(this.g);
        byte[] tb = new byte[pb.length + gb.length];
        System.arraycopy(pb, 0, tb, 0, pb.length);
        System.arraycopy(gb, 0, tb, pb.length, gb.length);
        return tb;
    }
}

