/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.CryptoKey;
import freenet.crypt.Global;
import freenet.crypt.Util;
import freenet.crypt.Yarrow;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;

public class DSAGroup
extends CryptoKey {
    private static Logger logger = Logger.getLogger(DSAGroup.class.getName());
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;
    private String pAsHexString;
    private String gAsHexString;
    private String qAsHexString;
    static BigInteger[] smallPrimes = new BigInteger[]{BigInteger.valueOf(3L), BigInteger.valueOf(5L), BigInteger.valueOf(7L), BigInteger.valueOf(11L), BigInteger.valueOf(13L), BigInteger.valueOf(17L), BigInteger.valueOf(19L), BigInteger.valueOf(23L), BigInteger.valueOf(29L)};
    static boolean multithread = true;

    public DSAGroup(BigInteger p, BigInteger q, BigInteger g) {
        this.p = p;
        this.q = q;
        this.g = g;
        this.updateCachedHexStrings();
    }

    private void updateCachedHexStrings() {
        this.pAsHexString = this.p.toString(16);
        this.qAsHexString = this.q.toString(16);
        this.gAsHexString = this.g.toString(16);
    }

    public static CryptoKey read(InputStream i) throws IOException {
        BigInteger p = Util.readMPI(i);
        BigInteger q = Util.readMPI(i);
        BigInteger g = Util.readMPI(i);
        return new DSAGroup(p, q, g);
    }

    public void writeForWire(OutputStream out) throws IOException {
        Util.writeMPI(this.p, out);
        Util.writeMPI(this.q, out);
        Util.writeMPI(this.g, out);
    }

    public void write(OutputStream out) throws IOException {
        DataOutputStream dos = this.write(out, this.getClass().getName());
        this.writeForWire(out);
    }

    public String writeAsField() {
        StringBuffer b = new StringBuffer();
        b.append(this.pAsHexString).append(',');
        b.append(this.qAsHexString).append(',');
        b.append(this.gAsHexString);
        return b.toString();
    }

    public static DSAGroup readFromField(String field) {
        BigInteger g;
        BigInteger q;
        StringTokenizer str = new StringTokenizer(field, ",");
        if (str.countTokens() != 3) {
            throw new NumberFormatException();
        }
        BigInteger p = new BigInteger(str.nextToken(), 16);
        DSAGroup r = new DSAGroup(p, q = new BigInteger(str.nextToken(), 16), g = new BigInteger(str.nextToken(), 16));
        return r.equals(Global.DSAgroupA) ? Global.DSAgroupA : (r.equals(Global.DSAgroupB) ? Global.DSAgroupB : (r.equals(Global.DSAgroupC) ? Global.DSAgroupC : r));
    }

    public String keyType() {
        return "DSA.g-" + this.p.bitLength();
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getG() {
        return this.g;
    }

    public String getPAsHexString() {
        return this.pAsHexString;
    }

    public String getQAsHexString() {
        return this.qAsHexString;
    }

    public String getGAsHexString() {
        return this.gAsHexString;
    }

    public byte[] fingerprint() {
        BigInteger[] fp = new BigInteger[]{this.p, this.q, this.g};
        return this.fingerprint(fp);
    }

    public static BigInteger makePrime(int bits, int confidence, Random r) {
        BigInteger rv;
        while (!DSAGroup.isPrime(rv = new BigInteger(bits, r).setBit(0).setBit(bits - 1), confidence)) {
        }
        return rv;
    }

    public static boolean isPrime(BigInteger b, int confidence) {
        for (int i = 0; i < smallPrimes.length; ++i) {
            if (!b.mod(smallPrimes[i]).equals(Util.ZERO)) continue;
            return false;
        }
        return b.isProbablePrime(80);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DSAGroup generate(int bits, Random r) {
        BigInteger g;
        BigInteger h;
        BigInteger q;
        BigInteger c;
        BigInteger X;
        BigInteger p;
        int cc = 0;
        QG qg = null;
        if (multithread) {
            qg = new QG(r);
            qg.start();
        }
        do {
            if (cc++ % 15 == 0) {
                logger.finer(".");
            }
            if (multithread) {
                while (qg.qs.size() < 1) {
                    try {
                        QG qG = qg;
                        synchronized (qG) {
                            qg.wait(50L);
                        }
                    }
                    catch (InterruptedException ie) {
                    }
                }
                q = (BigInteger)qg.qs.elementAt(0);
                qg.qs.removeElementAt(0);
                QG ie = qg;
                synchronized (ie) {
                    qg.notify();
                }
            } else {
                q = DSAGroup.makePrime(160, 80, r);
            }
        } while (!DSAGroup.isPrime(p = (X = new BigInteger(bits, r).setBit(bits - 1)).subtract((c = X.mod(q.multiply(Util.TWO))).subtract(Util.ONE)), 80));
        qg.qs.trimToSize();
        BigInteger pmin1 = p.subtract(Util.ONE);
        do {
            if (cc++ % 5 == 0) {
                logger.finer("+");
            }
            h = new BigInteger(160, r);
            g = h.modPow(pmin1.divide(q), p);
        } while (h.compareTo(p.subtract(Util.ONE)) != -1 || h.compareTo(Util.ONE) < 1 || g.compareTo(Util.ONE) == 0 || g.bitLength() != bits);
        return new DSAGroup(p, q, g);
    }

    public static boolean testGroup(DSAGroup grp) {
        BigInteger p = grp.getP();
        BigInteger q = grp.getQ();
        BigInteger g = grp.getG();
        BigInteger pmin1 = p.subtract(Util.ONE);
        boolean rv = p.bitLength() <= 1024 && p.bitLength() >= 512 && p.bitLength() % 64 == 0 && q.bitLength() == 160 && q.compareTo(p) == -1 && DSAGroup.isPrime(p, 80) && DSAGroup.isPrime(q, 80) && pmin1.mod(q).equals(Util.ZERO) && g.compareTo(Util.ONE) == 1 && !g.equals(pmin1.modPow(pmin1.divide(q), p));
        return rv;
    }

    public static void main(String[] args) throws IOException {
        if (args[0].equals("test")) {
            System.out.print("GroupA: ");
            System.out.println(DSAGroup.testGroup(Global.DSAgroupA));
            System.out.print("GroupB: ");
            System.out.println(DSAGroup.testGroup(Global.DSAgroupB));
            System.out.print("GroupC: ");
            System.out.println(DSAGroup.testGroup(Global.DSAgroupC));
        } else {
            DSAGroup g = DSAGroup.generate(Integer.parseInt(args[0]), new Yarrow("/dev/urandom", "SHA1", "Rijndael"));
            System.err.print("\nVerifying group: ");
            System.err.println(DSAGroup.testGroup(g) ? "passed" : "failed");
            g.write(System.out);
        }
    }

    public byte[] asBytes() {
        byte[] pb = Util.MPIbytes(this.p);
        byte[] qb = Util.MPIbytes(this.q);
        byte[] gb = Util.MPIbytes(this.g);
        byte[] tb = new byte[pb.length + qb.length + gb.length];
        System.arraycopy(pb, 0, tb, 0, pb.length);
        System.arraycopy(qb, 0, tb, pb.length, qb.length);
        System.arraycopy(gb, 0, tb, pb.length + qb.length, gb.length);
        return tb;
    }

    public boolean equals(Object o) {
        return o instanceof DSAGroup && this.p.equals(((DSAGroup)o).p) && this.q.equals(((DSAGroup)o).q) && this.g.equals(((DSAGroup)o).g);
    }

    public boolean equals(DSAGroup o) {
        return this.p.equals(o.p) && this.q.equals(o.q) && this.g.equals(o.g);
    }

    public void destroy() {
        this.g = null;
        this.q = null;
        this.p = null;
    }

    static class QG
    extends Thread {
        public Vector qs = new Vector();
        protected Random r;

        public QG(Random r) {
            this.setDaemon(true);
            this.r = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block8: while (true) {
                this.qs.addElement(DSAGroup.makePrime(160, 80, this.r));
                QG qG = this;
                synchronized (qG) {
                    this.notifyAll();
                }
                while (true) {
                    if (this.qs.size() < 3) continue block8;
                    qG = this;
                    synchronized (qG) {
                        try {
                            this.wait(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                break;
            }
        }
    }
}

